/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.execution.impl.jsch;

import com.dtolabs.rundeck.core.common.Framework;
import com.dtolabs.rundeck.core.common.INodeEntry;
import com.dtolabs.rundeck.core.execution.ExecutionContext;
import com.dtolabs.rundeck.core.execution.impl.common.BaseFileCopier;
import com.dtolabs.rundeck.core.execution.impl.jsch.JschNodeExecutor;
import com.dtolabs.rundeck.core.execution.service.FileCopier;
import com.dtolabs.rundeck.core.execution.service.FileCopierException;
import com.dtolabs.rundeck.core.execution.workflow.steps.FailureReason;
import com.dtolabs.rundeck.core.execution.workflow.steps.StepFailureReason;
import com.dtolabs.rundeck.core.plugins.configuration.Describable;
import com.dtolabs.rundeck.core.plugins.configuration.Description;
import com.dtolabs.rundeck.core.tasks.net.SSHTaskBuilder;
import com.dtolabs.rundeck.plugins.util.DescriptionBuilder;
import java.io.File;
import java.io.InputStream;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Echo;
import org.apache.tools.ant.taskdefs.Sequential;
import org.apache.tools.ant.taskdefs.optional.ssh.Scp;

public class JschScpFileCopier
extends BaseFileCopier
implements FileCopier,
Describable {
    public static final String SERVICE_PROVIDER_TYPE = "jsch-scp";
    static final Description DESC = DescriptionBuilder.builder().name("jsch-scp").title("SCP").description("Copies a script file to a remote node via SCP.").mapping("keypath", "project.ssh-keypath").mapping("authentication", "project.ssh-authentication").build();
    private Framework framework;

    @Override
    public Description getDescription() {
        return DESC;
    }

    public JschScpFileCopier(Framework framework) {
        this.framework = framework;
    }

    @Override
    public String copyFileStream(ExecutionContext context, InputStream input, INodeEntry node) throws FileCopierException {
        return this.copyFile(context, null, input, null, node);
    }

    @Override
    public String copyFile(ExecutionContext context, File scriptfile, INodeEntry node) throws FileCopierException {
        return this.copyFile(context, scriptfile, null, null, node);
    }

    @Override
    public String copyScriptContent(ExecutionContext context, String script, INodeEntry node) throws FileCopierException {
        return this.copyFile(context, null, null, script, node);
    }

    private String copyFile(ExecutionContext context, File scriptfile, InputStream input, String script, INodeEntry node) throws FileCopierException {
        Scp scp;
        Project project = new Project();
        Sequential seq = new Sequential();
        seq.setProject(project);
        String remotefile = JschScpFileCopier.generateRemoteFilepathForNode(node, null != scriptfile ? scriptfile.getName() : "dispatch-script");
        File localTempfile = JschScpFileCopier.writeScriptTempFile(context, scriptfile, input, script, node);
        JschNodeExecutor.NodeSSHConnectionInfo nodeAuthentication = new JschNodeExecutor.NodeSSHConnectionInfo(node, this.framework, context);
        try {
            scp = SSHTaskBuilder.buildScp(node, project, remotefile, localTempfile, nodeAuthentication, context.getLoglevel());
        }
        catch (SSHTaskBuilder.BuilderException e) {
            throw new FileCopierException("Configuration error: " + e.getMessage(), StepFailureReason.ConfigurationFailure, e);
        }
        seq.addTask((Task)this.createEchoVerbose("copying scriptfile: '" + localTempfile.getAbsolutePath() + "' to: '" + node.getNodename() + ":" + remotefile + "'", project));
        seq.addTask((Task)scp);
        String errormsg = null;
        try {
            seq.execute();
        }
        catch (BuildException e) {
            JschNodeExecutor.ExtractFailure failure = JschNodeExecutor.extractFailure(e, node, nodeAuthentication.getSSHTimeout(), this.framework);
            errormsg = failure.getErrormsg();
            FailureReason failureReason = failure.getReason();
            context.getExecutionListener().log(0, errormsg);
            context.getExecutionListener().log(0, errormsg);
            throw new FileCopierException("[jsch-scp] Failed copying the file: " + errormsg, failureReason, (Exception)((Object)e));
        }
        if (!localTempfile.delete()) {
            context.getExecutionListener().log(1, "Unable to remove local temp file: " + localTempfile.getAbsolutePath());
        }
        return remotefile;
    }

    private Echo createEcho(String message, Project project, String logLevel) {
        Echo echo = new Echo();
        echo.setProject(project);
        Echo.EchoLevel level = new Echo.EchoLevel();
        level.setValue(logLevel);
        echo.setLevel(level);
        echo.setMessage(message);
        return echo;
    }

    private Echo createEchoVerbose(String message, Project project) {
        return this.createEcho(message, project, "debug");
    }
}

