/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.execution.workflow;

import com.dtolabs.rundeck.core.common.Framework;
import com.dtolabs.rundeck.core.common.INodeEntry;
import com.dtolabs.rundeck.core.common.SelectorUtils;
import com.dtolabs.rundeck.core.execution.ExecutionContext;
import com.dtolabs.rundeck.core.execution.ExecutionContextImpl;
import com.dtolabs.rundeck.core.execution.ExecutionListener;
import com.dtolabs.rundeck.core.execution.ExecutionListenerOverride;
import com.dtolabs.rundeck.core.execution.FailedNodesListener;
import com.dtolabs.rundeck.core.execution.HandlerExecutionItem;
import com.dtolabs.rundeck.core.execution.HasFailureHandler;
import com.dtolabs.rundeck.core.execution.StepExecutionItem;
import com.dtolabs.rundeck.core.execution.dispatch.DispatcherException;
import com.dtolabs.rundeck.core.execution.dispatch.DispatcherResult;
import com.dtolabs.rundeck.core.execution.workflow.NodeRecorder;
import com.dtolabs.rundeck.core.execution.workflow.StepExecutionContext;
import com.dtolabs.rundeck.core.execution.workflow.StepFirstWorkflowStrategy;
import com.dtolabs.rundeck.core.execution.workflow.WorkflowExecutionItem;
import com.dtolabs.rundeck.core.execution.workflow.WorkflowExecutionListener;
import com.dtolabs.rundeck.core.execution.workflow.WorkflowExecutionResult;
import com.dtolabs.rundeck.core.execution.workflow.WorkflowStrategy;
import com.dtolabs.rundeck.core.execution.workflow.steps.FailureReason;
import com.dtolabs.rundeck.core.execution.workflow.steps.NodeDispatchStepExecutor;
import com.dtolabs.rundeck.core.execution.workflow.steps.StepException;
import com.dtolabs.rundeck.core.execution.workflow.steps.StepExecutionResult;
import com.dtolabs.rundeck.core.execution.workflow.steps.StepExecutionResultImpl;
import com.dtolabs.rundeck.core.execution.workflow.steps.StepFailureReason;
import com.dtolabs.rundeck.core.execution.workflow.steps.node.NodeStepResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public abstract class BaseWorkflowStrategy
implements WorkflowStrategy {
    final Framework framework;

    public BaseWorkflowStrategy(Framework framework) {
        this.framework = framework;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final WorkflowExecutionResult executeWorkflow(StepExecutionContext executionContext, WorkflowExecutionItem item) {
        WorkflowExecutionListener wlistener = this.getWorkflowListener(executionContext);
        if (null != wlistener && !StepFirstWorkflowStrategy.isInnerLoop(item)) {
            wlistener.beginWorkflowExecution(executionContext, item);
        }
        WorkflowExecutionResult result = null;
        try {
            result = this.executeWorkflowImpl(executionContext, item);
        }
        finally {
            if (null != wlistener && !StepFirstWorkflowStrategy.isInnerLoop(item)) {
                wlistener.finishWorkflowExecution(result, executionContext, item);
            }
        }
        return result;
    }

    protected WorkflowExecutionListener getWorkflowListener(ExecutionContext executionContext) {
        WorkflowExecutionListener wlistener = null;
        ExecutionListener elistener = executionContext.getExecutionListener();
        if (null != elistener && elistener instanceof WorkflowExecutionListener) {
            wlistener = (WorkflowExecutionListener)elistener;
        }
        return wlistener;
    }

    public abstract WorkflowExecutionResult executeWorkflowImpl(StepExecutionContext var1, WorkflowExecutionItem var2);

    protected StepExecutionResult executeWFItem(StepExecutionContext executionContext, Map<Integer, StepExecutionResult> failedMap, int c, StepExecutionItem cmd) {
        StepExecutionResult result;
        if (null != executionContext.getExecutionListener()) {
            executionContext.getExecutionListener().log(4, c + ": Workflow step executing: " + cmd);
        }
        try {
            result = this.framework.getExecutionService().executeStep(ExecutionContextImpl.builder(executionContext).stepNumber(c).build(), cmd);
            if (!result.isSuccess()) {
                failedMap.put(c, result);
            }
        }
        catch (StepException e) {
            result = StepExecutionResultImpl.wrapStepException(e);
            failedMap.put(c, result);
        }
        if (null != executionContext.getExecutionListener()) {
            executionContext.getExecutionListener().log(4, c + ": Workflow step finished, result: " + result);
        }
        return result;
    }

    protected boolean executeWorkflowItemsForNodeSet(StepExecutionContext executionContext, Map<Integer, StepExecutionResult> failedMap, List<StepExecutionResult> resultList, List<StepExecutionItem> iWorkflowCmdItems, boolean keepgoing) {
        return this.executeWorkflowItemsForNodeSet(executionContext, failedMap, resultList, iWorkflowCmdItems, keepgoing, executionContext.getStepNumber());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean executeWorkflowItemsForNodeSet(StepExecutionContext executionContext, Map<Integer, StepExecutionResult> failedMap, List<StepExecutionResult> resultList, List<StepExecutionItem> iWorkflowCmdItems, boolean keepgoing, int beginStepIndex) {
        boolean workflowsuccess = true;
        WorkflowExecutionListener wlistener = this.getWorkflowListener(executionContext);
        int c = beginStepIndex;
        for (StepExecutionItem cmd : iWorkflowCmdItems) {
            boolean stepSuccess = false;
            if (null != wlistener) {
                wlistener.beginWorkflowItem(c, cmd);
            }
            NodeRecorder stepCaptureFailedNodesListener = new NodeRecorder();
            StepExecutionContext stepContext = this.replaceFailedNodesListenerInContext(executionContext, stepCaptureFailedNodesListener);
            StepExecutionResult stepResult = null;
            HashMap<Integer, StepExecutionResult> stepFailedMap = new HashMap<Integer, StepExecutionResult>();
            stepResult = this.executeWFItem(stepContext, stepFailedMap, c, cmd);
            stepSuccess = stepResult.isSuccess();
            HashMap<String, NodeStepResult> nodeFailures = stepCaptureFailedNodesListener.getFailedNodes();
            if (null != executionContext.getExecutionListener() && null != executionContext.getExecutionListener().getFailedNodesListener()) {
                executionContext.getExecutionListener().getFailedNodesListener().matchedNodes(stepCaptureFailedNodesListener.getMatchedNodes());
            }
            try {
                HasFailureHandler handles;
                StepExecutionItem handler;
                if (!stepSuccess && cmd instanceof HasFailureHandler && null != (handler = (handles = (HasFailureHandler)((Object)cmd)).getFailureHandler())) {
                    NodeRecorder handlerCaptureFailedNodesListener = new NodeRecorder();
                    StepExecutionContext handlerExecContext = this.replaceFailedNodesListenerInContext(executionContext, handlerCaptureFailedNodesListener);
                    if (stepCaptureFailedNodesListener.getMatchedNodes().size() > 1) {
                        HashSet<String> failedNodeList = new HashSet<String>(stepCaptureFailedNodesListener.getFailedNodes().keySet());
                        handlerExecContext = new ExecutionContextImpl.Builder(handlerExecContext).nodeSelector(SelectorUtils.nodeList(failedNodeList)).build();
                    }
                    if (null != stepResult) {
                        handlerExecContext = this.addStepFailureContextData(stepResult, handlerExecContext);
                        handlerExecContext = this.addNodeStepFailureContextData(stepResult, handlerExecContext);
                    }
                    HashMap<Integer, StepExecutionResult> handlerFailedMap = new HashMap<Integer, StepExecutionResult>();
                    StepExecutionResult handlerResult = this.executeWFItem(handlerExecContext, handlerFailedMap, c, handler);
                    boolean handlerSuccess = handlerResult.isSuccess();
                    boolean useHandlerResults = keepgoing;
                    if (!keepgoing && handlerSuccess && handler instanceof HandlerExecutionItem) {
                        useHandlerResults = ((HandlerExecutionItem)handler).isKeepgoingOnSuccess();
                    }
                    if (useHandlerResults) {
                        stepSuccess = handlerSuccess;
                        stepResult = handlerResult;
                        stepFailedMap = handlerFailedMap;
                        nodeFailures = handlerCaptureFailedNodesListener.getFailedNodes();
                    }
                }
            }
            finally {
                if (null != wlistener) {
                    wlistener.finishWorkflowItem(c, cmd);
                }
            }
            resultList.add(stepResult);
            failedMap.putAll(stepFailedMap);
            if (!stepSuccess) {
                workflowsuccess = false;
            }
            if (null != executionContext.getExecutionListener() && null != executionContext.getExecutionListener().getFailedNodesListener()) {
                if (nodeFailures.size() > 0) {
                    executionContext.getExecutionListener().getFailedNodesListener().nodesFailed(nodeFailures);
                } else if (workflowsuccess) {
                    executionContext.getExecutionListener().getFailedNodesListener().nodesSucceeded();
                }
            }
            if (!stepSuccess && !keepgoing) break;
            ++c;
        }
        return workflowsuccess;
    }

    private StepExecutionContext addStepFailureContextData(StepExecutionResult stepResult, StepExecutionContext handlerExecContext) {
        FailureReason reason;
        HashMap<String, String> resultData = new HashMap<String, String>();
        if (null != stepResult.getFailureData()) {
            for (Map.Entry<String, Object> entry : stepResult.getFailureData().entrySet()) {
                resultData.put(entry.getKey(), entry.getValue().toString());
            }
        }
        if (null == (reason = stepResult.getFailureReason())) {
            reason = StepFailureReason.Unknown;
        }
        resultData.put("reason", reason.toString());
        String message = stepResult.getFailureMessage();
        if (null == message) {
            message = "No message";
        }
        resultData.put("message", message);
        handlerExecContext = ExecutionContextImpl.builder(handlerExecContext).setContext("result", resultData).build();
        return handlerExecContext;
    }

    private StepExecutionContext addNodeStepFailureContextData(StepExecutionResult dispatcherStepResult, StepExecutionContext handlerExecContext) {
        Map<String, ? extends NodeStepResult> resultMap;
        if (NodeDispatchStepExecutor.isWrappedDispatcherResult(dispatcherStepResult)) {
            DispatcherResult dispatcherResult = NodeDispatchStepExecutor.extractDispatcherResult(dispatcherStepResult);
            resultMap = dispatcherResult.getResults();
        } else if (NodeDispatchStepExecutor.isWrappedDispatcherException(dispatcherStepResult)) {
            DispatcherException exception = NodeDispatchStepExecutor.extractDispatcherException(dispatcherStepResult);
            resultMap = exception.getResultMap();
        } else {
            return handlerExecContext;
        }
        ExecutionContextImpl.Builder builder = ExecutionContextImpl.builder(handlerExecContext);
        for (Map.Entry<String, ? extends NodeStepResult> dentry : resultMap.entrySet()) {
            FailureReason reason;
            String nodename = dentry.getKey();
            NodeStepResult stepResult = dentry.getValue();
            HashMap<String, String> resultData = new HashMap<String, String>();
            if (null != stepResult.getFailureData()) {
                for (Map.Entry<String, Object> entry : stepResult.getFailureData().entrySet()) {
                    resultData.put(entry.getKey(), entry.getValue().toString());
                }
            }
            if (null == (reason = stepResult.getFailureReason())) {
                reason = StepFailureReason.Unknown;
            }
            resultData.put("reason", reason.toString());
            String message = stepResult.getFailureMessage();
            if (null == message) {
                message = "No message";
            }
            resultData.put("message", message);
            HashMap<String, Map<String, String>> ndata = new HashMap<String, Map<String, String>>();
            ndata.put("result", resultData);
            builder.nodeDataContext(nodename, ndata);
        }
        return builder.build();
    }

    private StepExecutionContext replaceFailedNodesListenerInContext(StepExecutionContext executionContext, FailedNodesListener captureFailedNodesListener) {
        ExecutionListenerOverride listen = null;
        if (null != executionContext.getExecutionListener()) {
            listen = executionContext.getExecutionListener().createOverride();
        }
        if (null != listen) {
            listen.setFailedNodesListener(captureFailedNodesListener);
        }
        return new ExecutionContextImpl.Builder(executionContext).executionListener(listen).build();
    }

    protected Map<String, Collection<StepExecutionResult>> convertFailures(Map<Integer, StepExecutionResult> failedMap) {
        HashMap<String, Collection<StepExecutionResult>> failures = new HashMap<String, Collection<StepExecutionResult>>();
        for (Map.Entry<Integer, StepExecutionResult> entry : failedMap.entrySet()) {
            StepExecutionResult o = entry.getValue();
            if (NodeDispatchStepExecutor.isWrappedDispatcherResult(o)) {
                DispatcherResult dispatcherResult = NodeDispatchStepExecutor.extractDispatcherResult(o);
                for (String s : dispatcherResult.getResults().keySet()) {
                    NodeStepResult interpreterResult = dispatcherResult.getResults().get(s);
                    if (!failures.containsKey(s)) {
                        failures.put(s, new ArrayList());
                    }
                    ((Collection)failures.get(s)).add(interpreterResult);
                }
                continue;
            }
            if (!NodeDispatchStepExecutor.isWrappedDispatcherException(o)) continue;
            DispatcherException e = NodeDispatchStepExecutor.extractDispatcherException(o);
            INodeEntry node = e.getNode();
            if (null != node) {
                String key = node.getNodename();
                if (!failures.containsKey(key)) {
                    failures.put(key, new ArrayList());
                }
                ((Collection)failures.get(key)).add(e.getResultMap().get(node.getNodename()));
                continue;
            }
            for (String s : e.getResultMap().keySet()) {
                NodeStepResult interpreterResult = e.getResultMap().get(s);
                if (!failures.containsKey(s)) {
                    failures.put(s, new ArrayList());
                }
                ((Collection)failures.get(s)).add(interpreterResult);
            }
        }
        return failures;
    }

    static class BaseWorkflowExecutionResult
    implements WorkflowExecutionResult {
        private final List<StepExecutionResult> results;
        private final Map<String, Collection<StepExecutionResult>> failures;
        private final Map<Integer, StepExecutionResult> stepFailures;
        private final boolean success;
        private final Exception orig;

        public BaseWorkflowExecutionResult(List<StepExecutionResult> results, Map<String, Collection<StepExecutionResult>> failures, Map<Integer, StepExecutionResult> stepFailures, boolean success, Exception orig) {
            this.results = results;
            this.failures = failures;
            this.stepFailures = stepFailures;
            this.success = success;
            this.orig = orig;
        }

        @Override
        public List<StepExecutionResult> getResultSet() {
            return this.results;
        }

        @Override
        public Map<String, Collection<StepExecutionResult>> getNodeFailures() {
            return this.failures;
        }

        @Override
        public boolean isSuccess() {
            return this.success;
        }

        @Override
        public Exception getException() {
            return this.orig;
        }

        public String toString() {
            return "[Workflow " + (null != this.getStepFailures() && this.getStepFailures().size() > 0 ? "step failures: " + this.getStepFailures() : "") + (null != this.getNodeFailures() && this.getNodeFailures().size() > 0 ? ", Node failures: " + this.getNodeFailures() : "") + (null != this.getException() ? ": exception: " + this.getException() : "") + "]";
        }

        @Override
        public Map<Integer, StepExecutionResult> getStepFailures() {
            return this.stepFailures;
        }
    }
}

