/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.execution.workflow;

import com.dtolabs.rundeck.core.execution.ContextLoggerExecutionListener;
import com.dtolabs.rundeck.core.execution.ExecutionListenerOverride;
import com.dtolabs.rundeck.core.execution.ExecutionListenerOverrideBase;
import com.dtolabs.rundeck.core.execution.FailedNodesListener;
import com.dtolabs.rundeck.core.execution.workflow.ContextLogger;
import java.util.Map;

class ContextualExecutionListener
extends ExecutionListenerOverrideBase
implements ContextLoggerExecutionListener {
    private ContextLogger logger;
    private ContextualExecutionListener delegate;

    protected ContextualExecutionListener(ContextualExecutionListener delegate) {
        super(delegate);
        this.delegate = delegate;
    }

    public ContextualExecutionListener(FailedNodesListener failedNodesListener, ContextLogger logger, boolean terse, String logFormat) {
        super(failedNodesListener, terse, logFormat);
        this.logger = logger;
    }

    @Override
    public final void log(int level, String message) {
        if (null != this.delegate) {
            this.delegate.log(level, message);
        } else {
            this.log(level, message, this.getLoggingContext());
        }
    }

    public void log(int level, String message, Map<String, String> data) {
        if (null != this.delegate) {
            this.delegate.log(level, message, data);
            return;
        }
        if (level >= 4) {
            this.logger.verbose(message, data);
        } else if (level >= 3) {
            this.logger.verbose(message, data);
        } else if (level >= 2) {
            this.logger.log(message, data);
        } else if (level >= 1) {
            this.logger.warn(message, data);
        } else if (level >= 0) {
            this.logger.error(message, data);
        } else {
            this.logger.log(message, data);
        }
    }

    @Override
    public ExecutionListenerOverride createOverride() {
        return new ContextualExecutionListener(this);
    }

    @Override
    public Map<String, String> getContext() {
        return this.getLoggingContext();
    }
}

