/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.utils;

import com.dtolabs.rundeck.core.utils.Reformatter;
import java.util.HashMap;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.DefaultLogger;

public class ExecToolCommandLogger
extends DefaultLogger {
    private Reformatter formatter;

    public ExecToolCommandLogger(Reformatter formatter) {
        this.formatter = formatter;
    }

    public void messageLogged(BuildEvent event) {
        int priority = event.getPriority();
        if (priority <= this.msgOutputLevel) {
            String msg = this.expandMessage(event, event.getMessage());
            if (priority != 0) {
                this.printMessage(msg, this.out, priority);
            } else {
                this.printMessage(msg, this.err, priority);
            }
            this.log(msg);
        }
    }

    private String expandMessage(BuildEvent event, String message) {
        String node;
        HashMap<String, String> data = new HashMap<String, String>();
        String user = ExecToolCommandLogger.retrieveUserName(event);
        if (null != user) {
            data.put("user", user);
        }
        if (null != (node = ExecToolCommandLogger.retrieveNodeName(event))) {
            data.put("node", node);
        }
        data.put("level", ExecToolCommandLogger.logLevelToString(event.getPriority()));
        if (null != this.formatter) {
            return this.formatter.reformat(data, message);
        }
        return message;
    }

    public static String retrieveModuleName(BuildEvent event) {
        return event.getProject().getProperty("module.name");
    }

    public static String retrieveNodeName(BuildEvent event) {
        return event.getProject().getProperty("framework.node.name");
    }

    public static String retrieveUserName(BuildEvent event) {
        return event.getProject().getProperty("user.name");
    }

    public static String logLevelToString(int level) {
        String logLevel;
        switch (level) {
            case 4: {
                logLevel = "DEBUG";
                break;
            }
            case 3: {
                logLevel = "VERBOSE";
                break;
            }
            case 2: {
                logLevel = "INFO";
                break;
            }
            case 1: {
                logLevel = "WARN";
                break;
            }
            case 0: {
                logLevel = "ERROR";
                break;
            }
            default: {
                logLevel = "UNKNOWN";
            }
        }
        return logLevel;
    }

    public int getLevel() {
        return this.msgOutputLevel;
    }
}

