/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.utils;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;

public class PartialLineBuffer {
    private ArrayList<String> lines = new ArrayList();
    String partialLine = null;
    boolean newdata = false;
    char[] cbuf = new char[1024];

    private void appendString(String str, boolean linending) {
        if (linending) {
            if (null != this.partialLine) {
                if (this.partialLine.endsWith("\r") && str.equals("")) {
                    this.lines.add(this.partialLine.substring(0, this.partialLine.length() - 1));
                } else if (this.partialLine.endsWith("\r")) {
                    this.lines.add(this.partialLine.substring(0, this.partialLine.length() - 1));
                    this.lines.add(str);
                } else {
                    this.lines.add(this.partialLine + str);
                }
                this.partialLine = null;
                this.newdata = false;
            } else {
                this.lines.add(str);
            }
        } else if (null != this.partialLine) {
            if (this.partialLine.endsWith("\r")) {
                this.lines.add(this.partialLine.substring(0, this.partialLine.length() - 1));
                if ("".equals(str)) {
                    this.partialLine = null;
                    this.newdata = false;
                } else {
                    this.partialLine = str;
                    this.newdata = true;
                }
            } else {
                this.partialLine = this.partialLine + str;
                this.newdata = true;
            }
        } else {
            this.partialLine = str;
            this.newdata = true;
        }
    }

    public int read(Reader reader) throws IOException {
        int c = reader.read(this.cbuf);
        if (c > 0) {
            this.addData(this.cbuf, 0, c);
        }
        return c;
    }

    public void addData(char[] data, int off, int size) {
        if (size < 1) {
            return;
        }
        String str = new String(data, off, size);
        if (str.contains("\n")) {
            String last;
            String[] lines = str.split("\\r?\\n", -1);
            for (int i = 0; i < lines.length - 1; ++i) {
                this.appendString(lines[i], true);
            }
            if (lines.length > 0 && !"".equals(last = lines[lines.length - 1])) {
                this.appendString(last, false);
            }
        } else if (str.contains("\r")) {
            String[] lines = str.split("\\r", -1);
            for (int i = 0; i < lines.length - 2; ++i) {
                this.appendString(lines[i], true);
            }
            if (lines.length >= 2) {
                String last2 = lines[lines.length - 2];
                String last = lines[lines.length - 1];
                if (!"".equals(last)) {
                    this.appendString(last2, true);
                    this.appendString(last, false);
                } else {
                    this.appendString(last2 + "\r", false);
                }
            }
        } else {
            this.appendString(str, false);
        }
    }

    public String getPartialLine() {
        return this.getPartialLine(true);
    }

    public void unmarkPartial() {
        if (null != this.partialLine) {
            this.newdata = true;
        }
    }

    public void clearPartial() {
        this.partialLine = null;
        this.newdata = false;
    }

    public String getPartialLine(boolean mark) {
        if (mark && this.newdata) {
            this.newdata = false;
            if (this.partialLine.endsWith("\r")) {
                return this.partialLine.substring(0, this.partialLine.length() - 1);
            }
            return this.partialLine;
        }
        if (mark && !this.newdata) {
            return null;
        }
        if (null != this.partialLine && this.partialLine.endsWith("\r")) {
            return this.partialLine.substring(0, this.partialLine.length() - 1);
        }
        return this.partialLine;
    }

    public String readLine() {
        if (this.lines.size() > 0) {
            return this.lines.remove(0);
        }
        return null;
    }

    public List<String> getLines() {
        return this.lines;
    }
}

