/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.utils;

import com.dtolabs.rundeck.core.cli.CLIUtils;
import com.dtolabs.rundeck.core.common.INodeEntry;
import com.dtolabs.rundeck.core.dispatcher.DataContextUtils;
import com.dtolabs.rundeck.core.execution.ExecArgList;
import com.dtolabs.rundeck.core.utils.Converter;
import com.dtolabs.rundeck.core.utils.OptsUtil;
import com.dtolabs.utils.Streams;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.PredicateUtils;

public class ScriptExecUtil {
    static final Predicate needsQuoting = ScriptExecUtil.any(DataContextUtils.stringContainsPropertyReferencePredicate, CLIUtils.stringContainsWhitespacePredicate, CLIUtils.stringContainsQuotePredicate);

    public static int runLocalCommand(String[] command, Map<String, String> envMap, File workingdir, OutputStream outputStream, OutputStream errorStream) throws IOException, InterruptedException {
        String[] envarr = ScriptExecUtil.createEnvironmentArray(envMap);
        Runtime runtime = Runtime.getRuntime();
        Process exec = runtime.exec(command, envarr, workingdir);
        Streams.StreamCopyThread errthread = Streams.copyStreamThread(exec.getErrorStream(), errorStream);
        Streams.StreamCopyThread outthread = Streams.copyStreamThread(exec.getInputStream(), outputStream);
        errthread.start();
        outthread.start();
        exec.getOutputStream().close();
        int result = exec.waitFor();
        errthread.join();
        outthread.join();
        if (null != outthread.getException()) {
            throw outthread.getException();
        }
        if (null != errthread.getException()) {
            throw errthread.getException();
        }
        return result;
    }

    private static String[] createEnvironmentArray(Map<String, String> envMap) {
        ArrayList<String> envlist = new ArrayList<String>();
        for (Map.Entry<String, String> entry : envMap.entrySet()) {
            envlist.add(entry.getKey() + "=" + entry.getValue());
        }
        return envlist.toArray(new String[envlist.size()]);
    }

    public static String[] createScriptArgs(Map<String, Map<String, String>> localDataContext, String scriptargs, String[] scriptargsarr, String scriptinterpreter, boolean interpreterargsquoted, String filepath) {
        return ScriptExecUtil.createScriptArgs(localDataContext, null, scriptargs, scriptargsarr, scriptinterpreter, interpreterargsquoted, filepath);
    }

    public static ExecArgList createScriptArgList(String filepath, String scriptargs, String[] scriptargsarr, String scriptinterpreter, boolean interpreterargsquoted) {
        ExecArgList.Builder builder = ExecArgList.builder();
        if (null != scriptinterpreter) {
            builder.args(Arrays.asList(OptsUtil.burst(scriptinterpreter)), false);
        }
        if (null != scriptinterpreter && interpreterargsquoted) {
            ExecArgList.Builder sub = builder.subList(true);
            ScriptExecUtil.addScriptFileArgList(filepath, scriptargs, scriptargsarr, sub, needsQuoting);
            sub.parent();
        } else {
            ScriptExecUtil.addScriptFileArgList(filepath, scriptargs, scriptargsarr, builder, needsQuoting);
        }
        return builder.build();
    }

    static Predicate any(Predicate ... preds) {
        return PredicateUtils.anyPredicate((Predicate[])preds);
    }

    private static void addScriptFileArgList(String filepath, String scriptargs, String[] scriptargsarr, ExecArgList.Builder builder, Predicate quoted) {
        builder.arg(filepath, false);
        if (null != scriptargs) {
            builder.args(OptsUtil.burst(scriptargs), quoted);
        } else if (null != scriptargsarr) {
            builder.args(scriptargsarr, quoted);
        }
    }

    public static String[] createScriptArgs(Map<String, Map<String, String>> localDataContext, INodeEntry node, String scriptargs, String[] scriptargsarr, String scriptinterpreter, boolean interpreterargsquoted, String filepath) {
        ArrayList<String> arglist = new ArrayList<String>();
        if (null != scriptinterpreter) {
            arglist.addAll(Arrays.asList(OptsUtil.burst(scriptinterpreter)));
        }
        if (null != scriptinterpreter && interpreterargsquoted) {
            ArrayList<String> sublist = new ArrayList<String>();
            sublist.add(filepath);
            ScriptExecUtil.addQuotedArgs(localDataContext, node, scriptargs, scriptargsarr, sublist, true);
            arglist.add(DataContextUtils.join(sublist, " "));
        } else {
            arglist.add(filepath);
            ScriptExecUtil.addQuotedArgs(localDataContext, node, scriptargs, scriptargsarr, arglist, false);
        }
        return arglist.toArray(new String[arglist.size()]);
    }

    private static void addQuotedArgs(Map<String, Map<String, String>> localDataContext, INodeEntry node, String scriptargs, String[] scriptargsarr, ArrayList<String> arglist, boolean quoted) {
        if (null != scriptargs) {
            arglist.addAll(Arrays.asList(DataContextUtils.replaceDataReferences(scriptargs.split(" "), localDataContext)));
        } else if (null != scriptargsarr) {
            if (!quoted) {
                arglist.addAll(Arrays.asList(scriptargsarr));
            } else {
                String[] newargs = DataContextUtils.replaceDataReferences(scriptargsarr, localDataContext);
                Converter<String, String> quote = ScriptExecUtil.getQuoteConverterForNode(node);
                for (int i = 0; i < newargs.length; ++i) {
                    String replaced = newargs[i];
                    if (null != quote && (!replaced.equals(scriptargsarr[i]) || CLIUtils.containsSpace(replaced))) {
                        arglist.add(quote.convert(replaced));
                        continue;
                    }
                    arglist.add(replaced);
                }
            }
        }
    }

    private static Converter<String, String> getQuoteConverterForNode(INodeEntry node) {
        Converter<String, String> quote = null != node ? CLIUtils.argumentQuoteForOperatingSystem(node.getOsFamily()) : CLIUtils.argumentQuoteForOperatingSystem(null);
        return quote;
    }
}

