/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.launcher;

import com.dtolabs.launcher.Preferences;
import com.dtolabs.rundeck.core.Constants;
import com.dtolabs.rundeck.core.cli.CLIToolLogger;
import com.dtolabs.rundeck.core.cli.project.BaseAction;
import com.dtolabs.rundeck.core.cli.project.CreateAction;
import com.dtolabs.rundeck.core.common.Framework;
import com.dtolabs.utils.Streams;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.apache.tools.ant.types.FilterSet;
import org.apache.tools.ant.types.FilterSetCollection;
import org.apache.tools.ant.util.FileUtils;

public class Setup
implements CLIToolLogger {
    public static final Logger logger = Logger.getLogger(Setup.class);
    public static String RDECK_HOME = Constants.getSystemHomeDir();
    public static String RDECK_BASE = Constants.getSystemBaseDir();
    public static final String SETUP_USAGE = "rd-setup [-v] -n nodename [-N hostname] -s serverhostname [ --key=value ]";
    public static final boolean FORCE_FLAG = true;
    private Parameters parameters = new Parameters();
    public static final String TEMPLATE_RESOURCES_PATH = "com/dtolabs/launcher/setup/templates";
    static String[] templates = new String[]{"admin.aclpolicy", "apitoken.aclpolicy", "framework.properties", "log4j.properties", "console-log4j.properties", "profile.bat", "profile", "project.properties"};
    static final HashSet<String> restrictedPermTemplates = new HashSet();

    public static void main(String[] args) {
        int exitCode = 1;
        Setup setup = new Setup();
        try {
            setup.execute(args);
            exitCode = 0;
        }
        catch (Throwable exc) {
            System.err.println("ERROR: " + exc.getMessage());
        }
        System.exit(exitCode);
    }

    public void execute(String[] args) throws SetupException {
        this.parameters.parse(args);
        this.performSetup(args);
    }

    public void performSetup() throws SetupException {
        this.performSetup(new String[0]);
    }

    private void performSetup(String[] args) throws SetupException {
        this.parameters.validate();
        this.validateInstall();
        File homedir = new File(this.parameters.getHomeDir());
        File basedir = new File(this.parameters.getBaseDir());
        if (!basedir.exists() && !basedir.mkdirs()) {
            throw new SetupException("Unable to create RDECK_BASE directory: " + this.parameters.getBaseDir());
        }
        this.generatePreferences(args, this.parameters.getProperties());
        this.newImpl(homedir, basedir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void newImpl(File homedir, File basedir) throws SetupException {
        File etcdir = new File(Constants.getFrameworkConfigDir(basedir.getAbsolutePath()));
        if (!etcdir.exists() && !etcdir.mkdir()) {
            throw new SetupException("Unable to create directory: " + etcdir.getAbsolutePath());
        }
        boolean overwrite = this.parameters.forceFlag;
        File preferences = new File(etcdir, "preferences.properties");
        Properties prefs = new Properties();
        if (preferences.isFile()) {
            try {
                FileInputStream fileInputStream = new FileInputStream(preferences);
                try {
                    prefs.load(fileInputStream);
                }
                finally {
                    fileInputStream.close();
                }
            }
            catch (IOException e) {
                throw new SetupException("Error loading file: " + preferences.getAbsolutePath(), e);
            }
        }
        long time = System.currentTimeMillis();
        try {
            for (String filename : templates) {
                File destFile = new File(etcdir, filename);
                File templFile = this.getTemplateFile(homedir, filename + ".template");
                if (overwrite && destFile.isFile()) {
                    File backup = new File(etcdir, filename + ".backup-" + time);
                    FileUtils.getFileUtils().copyFile(destFile, backup);
                }
                if (!overwrite && destFile.isFile()) continue;
                FilterSetCollection filterset = new FilterSetCollection();
                FilterSet set = new FilterSet();
                set.setFiltersfile(preferences);
                filterset.addFilterSet(set);
                FileUtils.getFileUtils().copyFile(templFile, destFile, filterset, true);
                if (!restrictedPermTemplates.contains(filename) || destFile.setWritable(false, false)) continue;
                logger.warn((Object)("Failed to remove writable flag for file: " + destFile.getAbsolutePath()));
            }
        }
        catch (IOException e) {
            throw new SetupException("Error copying templates", e);
        }
        Properties frameworkProps = new Properties();
        try {
            FileInputStream fileInputStream = new FileInputStream(new File(etcdir, "framework.properties"));
            try {
                frameworkProps.load(fileInputStream);
            }
            finally {
                fileInputStream.close();
            }
        }
        catch (IOException e) {
            throw new SetupException("unable to load frameworkproperties", e);
        }
        for (String prop : new String[]{"framework.var.dir", "framework.tmp.dir", "framework.logs.dir", "framework.etc.dir", "framework.projects.dir"}) {
            String path = frameworkProps.getProperty(prop);
            String expandpath = path.replaceAll("\\$\\{framework\\.var\\.dir\\}", frameworkProps.getProperty("framework.var.dir"));
            File dir = new File(expandpath);
            if (dir.isDirectory() || dir.mkdirs()) continue;
            throw new SetupException("Unable to create dir: " + dir.getAbsolutePath());
        }
        if ("true".equals(prefs.getProperty("project.default.create")) && null != prefs.getProperty("project.default.name")) {
            CreateAction createAction = new CreateAction((CLIToolLogger)this, Framework.getInstance(basedir.getAbsolutePath()), BaseAction.createArgs(prefs.getProperty("project.default.name"), true), CreateAction.createArgs(false));
            try {
                createAction.exec();
            }
            catch (Throwable throwable) {
                throw new SetupException("Failed to run project create action: " + throwable.getMessage(), throwable);
            }
        }
    }

    private File getTemplateFile(File homedir, String filename) throws IOException {
        File templateFile = null;
        String resource = "com/dtolabs/launcher/setup/templates/" + filename;
        InputStream is = Setup.class.getClassLoader().getResourceAsStream(resource);
        if (null != is) {
            templateFile = File.createTempFile("temp", filename);
            Streams.copyStream(is, new FileOutputStream(templateFile));
            return templateFile;
        }
        throw new RuntimeException("Unable to load required resource: " + resource);
    }

    private void validateInstall() throws SetupException {
        if (null == this.parameters.getBaseDir() || this.parameters.getBaseDir().equals("")) {
            throw new SetupException("rdeck.base property not defined or is the empty string");
        }
        if (!this.checkIfDir("rdeck.home", this.parameters.getBaseDir())) {
            throw new SetupException(this.parameters.getBaseDir() + " is not a valid rdeck install");
        }
    }

    private boolean checkIfDir(String propName, String path) {
        if (null == path || path.equals("")) {
            throw new IllegalArgumentException(propName + "property had null or empty value");
        }
        return new File(path).exists();
    }

    private void generatePreferences(String[] args, Properties input) throws SetupException {
        File frameworkPreferences = new File(Constants.getFrameworkPreferences(this.parameters.getBaseDir()));
        try {
            Preferences.generate(args, frameworkPreferences.getAbsolutePath(), input);
        }
        catch (Exception e) {
            throw new SetupException("failed generating setup preferences: " + e.getMessage(), e);
        }
        if (!frameworkPreferences.exists()) {
            throw new SetupException("Unable to generate preferences file: " + frameworkPreferences);
        }
        if (!frameworkPreferences.isFile()) {
            throw new SetupException(frameworkPreferences + " preferences file is not a regular file");
        }
    }

    public static void printUsage() {
        System.out.println(SETUP_USAGE);
    }

    private static void usageError(String msg) {
        System.err.println("\nERROR: " + msg);
        Setup.printUsage();
    }

    @Override
    public void log(String message) {
        System.out.println(message);
    }

    @Override
    public void error(String message) {
        System.err.println(message);
    }

    @Override
    public void warn(String message) {
        System.err.println(message);
    }

    @Override
    public void verbose(String message) {
        System.out.println(message);
    }

    @Override
    public void debug(String message) {
        System.out.println(message);
    }

    public Parameters getParameters() {
        return this.parameters;
    }

    static {
        restrictedPermTemplates.addAll(Arrays.asList("admin.aclpolicy", "apitoken.aclpolicy"));
    }

    public static class SetupException
    extends Exception {
        public SetupException() {
        }

        public SetupException(String s) {
            super(s);
        }

        public SetupException(String s, Throwable throwable) {
            super(s, throwable);
        }

        public SetupException(Throwable throwable) {
            super(throwable);
        }
    }

    public static class Parameters {
        private boolean forceFlag = true;
        private boolean debugFlag;
        private String nodeArg;
        private String nodeHostnameArg;
        private String serverHostname;
        private String serverName;
        private String baseDir;
        private String homeDir;
        private Properties properties = new Properties();

        protected boolean getForceFlag() {
            return this.forceFlag;
        }

        protected boolean getDebugFlag() {
            return this.debugFlag;
        }

        protected String getNodeArg() {
            return this.nodeArg;
        }

        private String getOptParam(String[] args, int arg_i) throws SetupException {
            if (arg_i == args.length - 1) {
                throw new SetupException("option: " + args[arg_i] + " must take a parameter");
            }
            if (args[arg_i + 1].startsWith("-")) {
                throw new SetupException("arg: " + args[arg_i] + " does not have a parameter, instead was provided: " + args[arg_i + 1]);
            }
            return args[arg_i + 1];
        }

        private void parse(String[] args) throws SetupException {
            for (int i = 0; i < args.length; ++i) {
                if (args[i].equals("-v")) {
                    this.debugFlag = true;
                    continue;
                }
                if (args[i].equals("-f")) continue;
                if (args[i].equals("-n")) {
                    this.nodeArg = this.getOptParam(args, i);
                    ++i;
                    continue;
                }
                if (args[i].equals("-N")) {
                    this.nodeHostnameArg = this.getOptParam(args, i);
                    ++i;
                    continue;
                }
                if (args[i].equals("-s")) {
                    this.serverHostname = this.getOptParam(args, i);
                    ++i;
                    continue;
                }
                if (args[i].equals("-S")) {
                    this.serverName = this.getOptParam(args, i);
                    ++i;
                    continue;
                }
                if (args[i].equals("-d")) {
                    this.baseDir = this.getOptParam(args, i);
                    ++i;
                    continue;
                }
                if (args[i].equals("-H")) {
                    this.homeDir = this.getOptParam(args, i);
                    ++i;
                    continue;
                }
                if (args[i].startsWith("--")) continue;
                Setup.usageError("unrecognized argument: \"" + args[i] + "\"");
            }
        }

        public void validate() throws SetupException {
            if (null == this.nodeArg) {
                throw new SetupException("nodeName option not provided");
            }
            if (null == this.nodeHostnameArg) {
                System.out.println("Using nodename as hostname: " + this.nodeArg);
                this.nodeHostnameArg = this.nodeArg;
            }
            if (null == this.serverHostname) {
                this.serverHostname = this.nodeHostnameArg;
            }
            if (null == this.serverName) {
                this.serverName = this.nodeArg;
            }
            if (null != this.serverHostname) {
                System.out.println("Using server hostname: " + this.serverHostname);
            }
            if (null != this.serverName) {
                System.out.println("Using server hostname: " + this.serverName);
            }
            if (null == this.baseDir) {
                this.baseDir = Constants.getSystemBaseDir();
            }
            if (null == this.homeDir) {
                this.homeDir = Constants.getSystemHomeDir();
            }
            if (null == this.homeDir) {
                this.homeDir = this.baseDir;
            }
            System.out.println("Using basedir: " + Preferences.forwardSlashPath(this.baseDir));
            this.properties.setProperty("rdeck.base", Preferences.forwardSlashPath(this.baseDir));
            System.out.println("Using homedir: " + Preferences.forwardSlashPath(this.homeDir));
            this.properties.setProperty("rdeck.home", Preferences.forwardSlashPath(this.homeDir));
            this.properties.setProperty("framework.node.name", this.nodeArg);
            this.properties.setProperty("framework.node.hostname", this.nodeHostnameArg);
            if (null != this.serverHostname) {
                this.properties.setProperty("framework.server.hostname", this.serverHostname);
            }
            if (null != this.serverName) {
                this.properties.setProperty("framework.server.name", this.serverName);
            }
        }

        public String getNodeHostnameArg() {
            return this.nodeHostnameArg;
        }

        public String getServerHostname() {
            return this.serverHostname;
        }

        public Properties getProperties() {
            return this.properties;
        }

        public void setNodeArg(String nodeArg) {
            this.nodeArg = nodeArg;
        }

        public void setNodeHostnameArg(String nodeHostnameArg) {
            this.nodeHostnameArg = nodeHostnameArg;
        }

        public void setServerHostname(String serverHostname) {
            this.serverHostname = serverHostname;
        }

        public String getServerName() {
            return this.serverName;
        }

        public void setServerName(String serverName) {
            this.serverName = serverName;
        }

        public String getBaseDir() {
            return this.baseDir;
        }

        public void setBaseDir(String baseDir) {
            this.baseDir = baseDir;
        }

        public String getHomeDir() {
            return this.homeDir;
        }

        public void setHomeDir(String homeDir) {
            this.homeDir = homeDir;
        }

        public void setProperty(String name, String value) {
            this.properties.setProperty(name, value);
        }
    }
}

