/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.authentication;

import com.dtolabs.rundeck.core.authentication.Authenticator;
import com.dtolabs.rundeck.core.authorization.AuthorizationException;
import com.dtolabs.rundeck.core.common.Framework;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.log4j.Category;

public class AuthenticationMgrFactory {
    public static final Category logger = Category.getInstance(AuthenticationMgrFactory.class);
    private final Authenticator authenticator;

    private AuthenticationMgrFactory(String classname, Framework framework) {
        if (null == classname) {
            throw new IllegalArgumentException("A null java class name was specified.");
        }
        this.authenticator = this.createAuthenticationMgr(classname, framework);
    }

    public static AuthenticationMgrFactory create(String classname, Framework framework) {
        return new AuthenticationMgrFactory(classname, framework);
    }

    public Authenticator getAuthenticationMgr() {
        return this.authenticator;
    }

    private Authenticator createAuthenticationMgr(String classname, Framework framework) {
        Authenticator auth;
        if (null == classname) {
            throw new IllegalArgumentException("A null java class name was specified.");
        }
        logger.debug((Object)("using authentication class: " + classname));
        try {
            Class<?> cls = Class.forName(classname);
            Method method = cls.getDeclaredMethod("getAuthenticator", Framework.class);
            auth = (Authenticator)method.invoke(null, framework);
        }
        catch (ClassNotFoundException e) {
            throw new AuthorizationException("error instantiating authorization class: " + classname, e);
        }
        catch (IllegalAccessException e) {
            throw new AuthorizationException("error instantiating authorization class: " + classname, e);
        }
        catch (NoSuchMethodException e) {
            throw new AuthorizationException("error instantiating authorization class: " + classname, e);
        }
        catch (InvocationTargetException e) {
            throw new AuthorizationException("error instantiating authorization class: " + classname, e);
        }
        return auth;
    }
}

