/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.authorization;

import com.dtolabs.rundeck.core.authorization.AuthorizationException;
import com.dtolabs.rundeck.core.authorization.LegacyAuthorization;
import com.dtolabs.rundeck.core.common.Framework;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

public class AuthorizationMgrFactory {
    private final LegacyAuthorization authorization;

    private AuthorizationMgrFactory(String classname, Framework framework, File baseDir) {
        this.authorization = this.createAuthorization(classname, framework, baseDir);
    }

    public static AuthorizationMgrFactory create(String classname, Framework framework, File baseDir) {
        return new AuthorizationMgrFactory(classname, framework, baseDir);
    }

    public LegacyAuthorization getAuthorizationMgr() {
        return this.authorization;
    }

    private LegacyAuthorization createAuthorization(String classname, Framework framework, File baseDir) throws AuthorizationException {
        LegacyAuthorization authorizationImpl;
        if (!baseDir.isDirectory()) {
            throw new IllegalArgumentException("baseDir does not exist or is not a directory: " + baseDir);
        }
        if (null == classname) {
            throw new IllegalArgumentException("classname was null");
        }
        try {
            Class<?> cls = Class.forName(classname);
            Constructor<?> method = cls.getDeclaredConstructor(Framework.class, File.class);
            authorizationImpl = (LegacyAuthorization)method.newInstance(framework, baseDir);
        }
        catch (InstantiationException e) {
            throw new AuthorizationException("error instantiating authorization class: " + classname, e);
        }
        catch (IllegalAccessException e) {
            throw new AuthorizationException("error instantiating authorization class: " + classname, e);
        }
        catch (NoSuchMethodException e) {
            throw new AuthorizationException("error instantiating authorization class: " + classname, e);
        }
        catch (InvocationTargetException e) {
            throw new AuthorizationException("error instantiating authorization class: " + classname, e);
        }
        catch (ClassNotFoundException e) {
            throw new AuthorizationException("error instantiating authorization class: " + classname, e);
        }
        return authorizationImpl;
    }
}

