/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.authorization;

import org.apache.log4j.Category;

public class TimeanddayExp {
    static Category logger = Category.getInstance((String)TimeanddayExp.class.getName());
    private String dayExp;
    private String hourExp;
    private String minuteExp;

    private void setDayExp(String dayExp) throws NumberFormatException {
        TimeanddayExp.checkExp(dayExp, "day");
        this.dayExp = dayExp;
    }

    public String getDayExp() {
        return this.dayExp;
    }

    public void setHourExp(String hourExp) {
        TimeanddayExp.checkExp(this.dayExp, "hour");
        this.hourExp = hourExp;
    }

    public String getHourExp() {
        return this.hourExp;
    }

    public void setMinuteExp(String minuteExp) {
        TimeanddayExp.checkExp(this.dayExp, "minute");
        this.minuteExp = minuteExp;
    }

    public String getMinuteExp() {
        return this.minuteExp;
    }

    public static void checkExp(String exp, String type) throws NumberFormatException {
        if (exp.equals("*")) {
            return;
        }
        int comma = exp.indexOf(44);
        int hyphen = exp.indexOf(45);
        if (comma >= 0 && hyphen >= 0) {
            throw new NumberFormatException("day expression: " + exp + " is not valid");
        }
        int min = 0;
        int max = 6;
        if (type.equals("day")) {
            min = 0;
            max = 6;
        } else if (type.equals("hour")) {
            min = 0;
            max = 23;
        } else if (type.equals("minute")) {
            min = 0;
            max = 59;
        } else {
            throw new NumberFormatException("unexpected error, type: " + type);
        }
        if (comma == -1 && hyphen == -1) {
            int unit = Integer.parseInt(exp);
            if (!TimeanddayExp.checkInRange(unit, min, max)) {
                throw new NumberFormatException(type + ": " + Integer.toString(unit) + " cannot be greater than " + max + " or less than " + min);
            }
        } else if (comma > -1) {
            String[] expList = exp.split(",");
            for (int i = 0; i < expList.length; ++i) {
                int unit = Integer.parseInt(expList[i]);
                if (TimeanddayExp.checkInRange(unit, min, max)) continue;
                throw new NumberFormatException(type + ": " + Integer.toString(unit) + " cannot be greater than " + max + " or less than " + min);
            }
        } else if (hyphen > -1) {
            String[] expRange = exp.split("-");
            if (expRange.length > 2) {
                throw new NumberFormatException("expression: " + exp + " of type " + type + " is not valid");
            }
            int unit0 = Integer.parseInt(expRange[0]);
            int unit1 = Integer.parseInt(expRange[1]);
            if (!TimeanddayExp.checkInRange(unit0, min, max)) {
                throw new NumberFormatException(type + ": " + Integer.toString(unit0) + " cannot be greater than " + max + " or less than " + min);
            }
            if (!TimeanddayExp.checkInRange(unit1, min, max)) {
                throw new NumberFormatException(type + ": " + Integer.toString(unit1) + " cannot be greater than " + max + " or less than " + min);
            }
        } else {
            throw new NumberFormatException("unexpected error");
        }
    }

    public static boolean checkInRange(int unit, int min, int max) {
        return unit >= min && unit <= max;
    }

    public TimeanddayExp(String timeandday) throws NumberFormatException {
        this(TimeanddayExp.parseDayExp(timeandday), TimeanddayExp.parseHourExp(timeandday), TimeanddayExp.parseMinuteExp(timeandday));
    }

    public TimeanddayExp(String dayExp, String hourExp, String minuteExp) throws NumberFormatException {
        if (null == dayExp || "".equals(dayExp)) {
            throw new NumberFormatException("day expression is null or empty string");
        }
        this.setDayExp(dayExp);
        if (null == hourExp || "".equals(hourExp)) {
            throw new NumberFormatException("hour expression is null or empty string");
        }
        this.setHourExp(hourExp);
        if (null == minuteExp || "".equals(minuteExp)) {
            throw new NumberFormatException("minute expression is null or empty string");
        }
        this.setMinuteExp(minuteExp);
    }

    public String toString() {
        return this.getDayExp() + " " + this.getHourExp() + " " + this.getMinuteExp();
    }

    public static String parseDayExp(String timeandday) {
        return timeandday.split("\\s")[0];
    }

    public static String parseHourExp(String timeandday) {
        return timeandday.split("\\s")[1];
    }

    public static String parseMinuteExp(String timeandday) {
        return timeandday.split("\\s")[2];
    }

    public static boolean match(TimeanddayExp r, TimeanddayExp t) {
        logger.debug((Object)"match(), compare TimeanddayExp objects");
        String rDay = r.getDayExp();
        String rHour = r.getHourExp();
        String rMinute = r.getMinuteExp();
        String tDay = t.getDayExp();
        String tHour = t.getHourExp();
        String tMinute = t.getMinuteExp();
        logger.debug((Object)("rDay: " + rDay));
        logger.debug((Object)("tDay: " + tDay));
        logger.debug((Object)("rHour: " + rHour));
        logger.debug((Object)("tHour: " + tHour));
        logger.debug((Object)("rMinute: " + rMinute));
        logger.debug((Object)("tMinute: " + tMinute));
        if (!TimeanddayExp.matchTime(rDay, tDay)) {
            logger.debug((Object)"days do not match");
            return false;
        }
        if (!TimeanddayExp.matchTime(rHour, tHour)) {
            logger.debug((Object)"hours do not match");
            return false;
        }
        if (!TimeanddayExp.matchTime(rMinute, tMinute)) {
            logger.debug((Object)"minutes do not match");
            return false;
        }
        return true;
    }

    private static boolean matchTime(String rTime, String tTime) {
        boolean success = false;
        logger.debug((Object)("matchTime(), comparing time strings rTime: " + rTime + " tTime: " + tTime));
        if (rTime.equals("*")) {
            logger.debug((Object)"matchTime(), rTime contains wildcard, returning true");
            return true;
        }
        int rtime = Integer.parseInt(rTime);
        int comma = tTime.indexOf(44);
        int hyphen = tTime.indexOf(45);
        if (comma >= 0) {
            logger.debug((Object)"comparing against list of times");
            String[] timeList = tTime.split(",");
            for (int i = 0; i < timeList.length; ++i) {
                if (rtime != Integer.parseInt(timeList[i])) continue;
                return true;
            }
            success = false;
        } else if (hyphen == 0) {
            logger.debug((Object)"comparing against range of times");
            String[] timeRange = tTime.split("-");
            int min = Integer.parseInt(timeRange[0]);
            int max = Integer.parseInt(timeRange[1]);
            if (!TimeanddayExp.checkInRange(rtime, min, max)) {
                return false;
            }
            success = true;
        } else {
            logger.debug((Object)"comparing against exact time");
            int ttime = Integer.parseInt(tTime);
            if (rtime != ttime) {
                return false;
            }
            success = true;
        }
        logger.debug((Object)("returning: " + success));
        return success;
    }
}

