/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.authorization.providers;

import com.dtolabs.rundeck.core.authentication.Group;
import com.dtolabs.rundeck.core.authentication.LdapGroup;
import com.dtolabs.rundeck.core.authentication.Username;
import com.dtolabs.rundeck.core.authorization.Attribute;
import com.dtolabs.rundeck.core.authorization.Explanation;
import com.dtolabs.rundeck.core.authorization.providers.AclContext;
import com.dtolabs.rundeck.core.authorization.providers.ContextDecision;
import com.dtolabs.rundeck.core.authorization.providers.ContextEvaluation;
import com.dtolabs.rundeck.core.authorization.providers.InvalidCollection;
import com.dtolabs.rundeck.core.authorization.providers.Policy;
import com.dtolabs.rundeck.core.authorization.providers.PolicyCollection;
import com.dtolabs.rundeck.core.authorization.providers.PolicyNode;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;
import javax.security.auth.Subject;
import javax.xml.namespace.NamespaceContext;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PoliciesDocument
implements PolicyCollection {
    static final String NS_AD = "http://dtolabs.com/rundeck/activedirectory";
    static final String NS_LDAP = "http://dtolabs.com/rundeck/ldap";
    private Document document;
    private File file;
    private ArrayList<String> groupNames;
    private ArrayList<Policy> policies;
    private long count = Long.MIN_VALUE;
    private static final XPath xpath = XPathFactory.newInstance().newXPath();
    public static final XPathExpression countXpath;
    public static final XPathExpression allPolicies;
    public static final XPathExpression policyByUserName;
    public static final XPathExpression policyByGroup;
    public static final XPathExpression allGroups;
    private static final Map<String, XPathExpression> commandFilterCache;

    public PoliciesDocument(Document document, File file) {
        this.document = document;
        this.file = file;
    }

    @Override
    public Collection<String> groupNames() throws InvalidCollection {
        NodeList groups;
        if (null != this.groupNames) {
            return this.groupNames;
        }
        this.groupNames = new ArrayList();
        try {
            groups = (NodeList)allGroups.evaluate(this.document, XPathConstants.NODESET);
        }
        catch (XPathExpressionException e) {
            throw new InvalidCollection(e);
        }
        for (int i = 0; i < groups.getLength(); ++i) {
            String result = groups.item(i).getNodeValue();
            if (result == null || result.length() <= 0) continue;
            this.groupNames.add(result);
        }
        return this.groupNames;
    }

    @Override
    public long countPolicies() throws InvalidCollection {
        if (this.count != Long.MIN_VALUE) {
            return this.count;
        }
        try {
            Double xpathCount = (Double)countXpath.evaluate(this.document, XPathConstants.NUMBER);
            this.count = xpathCount.longValue();
            return this.count;
        }
        catch (XPathExpressionException e) {
            throw new InvalidCollection(e);
        }
    }

    private Collection<Policy> listPolicies() throws XPathExpressionException {
        if (null != this.policies) {
            return this.policies;
        }
        this.policies = new ArrayList();
        NodeList policiesToEvaluate = (NodeList)allPolicies.evaluate(this.document, XPathConstants.NODESET);
        for (int i = 0; i < policiesToEvaluate.getLength(); ++i) {
            Node policy = policiesToEvaluate.item(i);
            this.policies.add(new PolicyNode(policy));
        }
        return this.policies;
    }

    @Override
    public Collection<AclContext> matchedContexts(Subject subject, Set<Attribute> environment) throws InvalidCollection {
        try {
            return PoliciesDocument.policyMatcher(subject, this.listPolicies());
        }
        catch (Exception e) {
            throw new InvalidCollection(e);
        }
    }

    static Collection<AclContext> policyMatcher(Subject subject, Collection<? extends Policy> policyLister) throws InvalidCollection {
        ArrayList<AclContext> matchedContexts = new ArrayList<AclContext>();
        int i = 0;
        for (Policy policy : policyLister) {
            Set<Group> groupPrincipals;
            long userMatchStart = System.currentTimeMillis();
            Set<Username> userPrincipals = subject.getPrincipals(Username.class);
            if (userPrincipals.size() > 0) {
                Set<String> policyUsers = policy.getUsernames();
                HashSet<String> usernamePrincipals = new HashSet<String>();
                for (Username username : userPrincipals) {
                    usernamePrincipals.add(username.getName());
                }
                if (!Collections.disjoint(policyUsers, usernamePrincipals)) {
                    matchedContexts.add(policy.getContext());
                    continue;
                }
            }
            if ((groupPrincipals = subject.getPrincipals(Group.class)).size() > 0) {
                long groupCollectStart = System.currentTimeMillis();
                Set<Object> policyGroups = policy.getGroups();
                HashSet<Object> groupNames = new HashSet<Object>();
                for (Group groupPrincipal : groupPrincipals) {
                    if (groupPrincipal instanceof LdapGroup) {
                        try {
                            groupNames.add(new LdapName(groupPrincipal.getName()));
                        }
                        catch (InvalidNameException e) {
                            e.printStackTrace();
                        }
                        continue;
                    }
                    groupNames.add(groupPrincipal.getName());
                }
                long collectDuration = System.currentTimeMillis() - groupCollectStart;
                if (!Collections.disjoint(policyGroups, groupNames)) {
                    matchedContexts.add(policy.getContext());
                    continue;
                }
            }
            ++i;
        }
        return matchedContexts;
    }

    public String toString() {
        return "PoliciesDocument{file=" + this.file + '}';
    }

    static {
        xpath.setNamespaceContext(new NamespaceContext(){

            public Iterator getPrefixes(String namespaceURI) {
                return null;
            }

            @Override
            public String getPrefix(String namespaceURI) {
                return null;
            }

            @Override
            public String getNamespaceURI(String prefix) {
                if (prefix.equals("ldap")) {
                    return PoliciesDocument.NS_LDAP;
                }
                if (prefix.equals("ActiveDirectory")) {
                    return PoliciesDocument.NS_AD;
                }
                return "";
            }
        });
        try {
            countXpath = xpath.compile("count(//policy)");
            allPolicies = xpath.compile("//policy");
            policyByUserName = xpath.compile("by/user/@username");
            policyByGroup = xpath.compile("by/group/@name | by/group/@ldap:name");
            allGroups = xpath.compile("//by/group/@name | //by/group/@ldap:name");
        }
        catch (XPathExpressionException e) {
            throw new IllegalArgumentException(e);
        }
        commandFilterCache = new HashMap<String, XPathExpression>();
    }

    public static class Context
    implements AclContext {
        private final Node policy;

        public Context(Node policy) {
            this.policy = policy;
        }

        @Override
        public ContextDecision includes(Map<String, String> resource, String action) {
            ArrayList<ContextEvaluation> evaluations = new ArrayList<ContextEvaluation>();
            if (null != resource.get("type") && !"job".equals(resource.get("type"))) {
                evaluations.add(new ContextEvaluation(Explanation.Code.REJECTED, "Legacy format: Unsupported resource type " + resource.get("type")));
                return new ContextDecision(Explanation.Code.REJECTED, false, evaluations);
            }
            try {
                StringBuilder filter = new StringBuilder();
                for (String next : resource.keySet()) {
                    if ("type".equals(next)) continue;
                    if (filter.length() > 0) {
                        filter.append(" and ");
                    }
                    if (next == null || next.length() <= 0) continue;
                    filter.append('@').append(next);
                }
                String filterString = filter.toString();
                if (!commandFilterCache.containsKey(filterString)) {
                    commandFilterCache.put(filterString, xpath.compile("descendant-or-self::command[" + filterString + "]"));
                }
                NodeList commands = (NodeList)((XPathExpression)commandFilterCache.get(filterString)).evaluate(this.policy, XPathConstants.NODESET);
                for (int i = 0; i < commands.getLength(); ++i) {
                    List<String> actions;
                    Node command = commands.item(i);
                    NamedNodeMap attributes = command.getAttributes();
                    Node actionAttr = attributes.getNamedItem("actions");
                    if (actionAttr == null) {
                        evaluations.add(new ContextEvaluation(Explanation.Code.REJECTED_NO_ACTIONS_DECLARED, this.generateJobName(this.policy, command)));
                        continue;
                    }
                    String actionsNodeValue = actionAttr.getNodeValue();
                    if (actionsNodeValue.length() <= 0) {
                        evaluations.add(new ContextEvaluation(Explanation.Code.REJECTED_ACTIONS_DECLARED_EMPTY, this.generateJobName(this.policy, command)));
                        continue;
                    }
                    if (!"*".equals(actionsNodeValue) && !(actions = Arrays.asList(actionsNodeValue.split(","))).contains(action)) {
                        evaluations.add(new ContextEvaluation(Explanation.Code.REJECTED_NO_ACTIONS_MATCHED, this.generateJobName(this.policy, command)));
                        continue;
                    }
                    boolean matched = true;
                    for (String key : resource.keySet()) {
                        Node attr;
                        String matchField;
                        if ("type".equals(key) || (matchField = (attr = attributes.getNamedItem(key)).getNodeValue()).equals("*")) continue;
                        String input = resource.get(key);
                        if (input == null || input.length() <= 0) {
                            evaluations.add(new ContextEvaluation(Explanation.Code.REJECTED_NO_RESOURCE_PROPERTY_PROVIDED, this.generateJobName(this.policy, command)));
                            matched = false;
                            break;
                        }
                        if (Pattern.matches(matchField, input)) continue;
                        matched = false;
                        evaluations.add(new ContextEvaluation(Explanation.Code.REJECTED_RESOURCE_PROPERTY_NOT_MATCHED, this.generateJobName(this.policy, command)));
                        break;
                    }
                    if (!matched) continue;
                    evaluations.add(new ContextEvaluation(Explanation.Code.GRANTED_ACTIONS_AND_COMMANDS_MATCHED, this.generateJobName(this.policy, command)));
                    return new ContextDecision(Explanation.Code.GRANTED_ACTIONS_AND_COMMANDS_MATCHED, true, evaluations);
                }
            }
            catch (XPathExpressionException e) {
                e.printStackTrace();
                return new ContextDecision(Explanation.Code.REJECTED_CONTEXT_EVALUATION_ERROR, false);
            }
            evaluations.add(new ContextEvaluation(Explanation.Code.REJECTED_COMMAND_NOT_MATCHED, this.generatePolicyName(this.policy)));
            return new ContextDecision(Explanation.Code.REJECTED_COMMAND_NOT_MATCHED, false, evaluations);
        }

        private String generatePolicyName(Node policy2) {
            StringBuilder sb = new StringBuilder();
            this.buildNodeString(policy2, sb);
            return sb.toString();
        }

        private String generateJobName(Node policy2, Node command) {
            StringBuilder sb = new StringBuilder();
            Node parent = command.getParentNode();
            ArrayList<Node> hierarchy = new ArrayList<Node>();
            while (!"policies".equals(parent.getNodeName())) {
                hierarchy.add(parent);
                parent = parent.getParentNode();
            }
            Collections.reverse(hierarchy);
            for (Node node : hierarchy) {
                this.buildNodeString(node, sb);
                sb.append(" / ");
            }
            this.buildNodeString(command, sb);
            return sb.toString();
        }

        private void buildNodeString(Node node, StringBuilder sb) {
            sb.append(node.getNodeName());
            sb.append('[');
            NamedNodeMap nodeAttributes = node.getAttributes();
            for (int i = 0; i < nodeAttributes.getLength(); ++i) {
                Node item = nodeAttributes.item(i);
                sb.append(item.getNodeName());
                sb.append(':');
                sb.append(item.getNodeValue());
                if (i + 1 >= nodeAttributes.getLength()) continue;
                sb.append(' ');
            }
            sb.append("] ");
        }

        public String toString() {
            return "Context: " + this.generatePolicyName(this.policy);
        }
    }
}

