/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.common.impl;

import com.dtolabs.rundeck.core.common.FileUpdater;
import com.dtolabs.rundeck.core.common.FileUpdaterException;
import com.dtolabs.rundeck.core.common.URLFileUpdaterFactory;
import com.dtolabs.utils.Streams;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Properties;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.params.HttpClientParams;
import org.apache.log4j.Logger;

public class URLFileUpdater
implements FileUpdater {
    static final Logger logger = Logger.getLogger((String)URLFileUpdater.class.getName());
    public static final String CONTENT_TYPE = "Content-Type";
    public static final String E_TAG = "ETag";
    public static final String IF_NONE_MATCH = "If-None-Match";
    public static final String LAST_MODIFIED = "Last-Modified";
    public static final String IF_MODIFIED_SINCE = "If-Modified-Since";
    public static final int DEFAULT_TIMEOUT = 60;
    public static final Factory FACTORY = new Factory();
    URL url;
    File cacheMetadata;
    File cachedContent;
    private String reasonCode;
    private int resultCode = 0;
    private String acceptHeader;
    private String contentType;
    private boolean useCaching;
    private int timeout;
    private String username;
    private String password;
    private httpClientInteraction interaction = new normalInteraction();

    public void setInteraction(httpClientInteraction interaction) {
        this.interaction = interaction;
    }

    public URLFileUpdater(URL url, String acceptHeader, int timeout, File cacheMetadataFile, File cachedContent, boolean useCaching, String username, String password) {
        this.url = url;
        this.cacheMetadata = cacheMetadataFile;
        this.acceptHeader = acceptHeader;
        this.cachedContent = cachedContent;
        this.timeout = timeout >= 0 ? timeout : 60;
        this.useCaching = useCaching;
        this.username = username;
        this.password = password;
    }

    public static URLFileUpdaterFactory factory() {
        return FACTORY;
    }

    @Override
    public void updateFile(File destinationFile) throws FileUpdaterException {
        if ("http".equalsIgnoreCase(this.url.getProtocol()) || "https".equalsIgnoreCase(this.url.getProtocol())) {
            this.updateHTTPUrl(destinationFile);
        } else if ("file".equalsIgnoreCase(this.url.getProtocol())) {
            this.updateFileUrl(destinationFile);
        } else {
            throw new FileUpdaterException("Unsupported protocol: " + this.url);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateFileUrl(File destinationFile) throws FileUpdaterException {
        try {
            File srfile = new File(new URI(this.url.toExternalForm()));
            FileInputStream in = new FileInputStream(srfile);
            try {
                FileOutputStream out = new FileOutputStream(destinationFile);
                try {
                    Streams.copyStream(in, out);
                }
                finally {
                    out.close();
                }
            }
            finally {
                in.close();
            }
        }
        catch (URISyntaxException e) {
            throw new FileUpdaterException("Invalid URI: " + this.url);
        }
        catch (FileNotFoundException e) {
            throw new FileUpdaterException(e);
        }
        catch (IOException e) {
            throw new FileUpdaterException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateHTTPUrl(File destinationFile) throws FileUpdaterException {
        block26: {
            Properties cacheProperties;
            if (null == this.interaction) {
                this.interaction = new normalInteraction();
            }
            if (this.useCaching) {
                cacheProperties = this.loadCacheData(this.cacheMetadata);
                this.contentTypeFromCache(cacheProperties);
            } else {
                cacheProperties = null;
            }
            HttpClientParams params = new HttpClientParams();
            if (this.timeout > 0) {
                params.setConnectionManagerTimeout((long)(this.timeout * 1000));
                params.setSoTimeout(this.timeout * 1000);
            }
            HttpClient client = new HttpClient(params);
            AuthScope authscope = null;
            UsernamePasswordCredentials cred = null;
            boolean doauth = false;
            String cleanUrl = this.url.toExternalForm().replaceAll("^(https?://)([^:@/]+):[^@/]*@", "$1$2:****@");
            String urlToUse = this.url.toExternalForm();
            try {
                if (null != this.url.getUserInfo()) {
                    doauth = true;
                    authscope = new AuthScope(this.url.getHost(), this.url.getPort() > 0 ? this.url.getPort() : this.url.getDefaultPort(), AuthScope.ANY_REALM, "BASIC");
                    cred = new UsernamePasswordCredentials(this.url.getUserInfo());
                    urlToUse = new URL(this.url.getProtocol(), this.url.getHost(), this.url.getPort(), this.url.getFile()).toExternalForm();
                } else if (null != this.username && null != this.password) {
                    doauth = true;
                    authscope = new AuthScope(this.url.getHost(), this.url.getPort() > 0 ? this.url.getPort() : this.url.getDefaultPort(), AuthScope.ANY_REALM, "BASIC");
                    cred = new UsernamePasswordCredentials(this.username + ":" + this.password);
                    urlToUse = new URL(this.url.getProtocol(), this.url.getHost(), this.url.getPort(), this.url.getFile()).toExternalForm();
                }
            }
            catch (MalformedURLException e) {
                throw new FileUpdaterException("Failed to configure base URL for authentication: " + e.getMessage(), e);
            }
            if (doauth) {
                client.getParams().setAuthenticationPreemptive(true);
                client.getState().setCredentials(authscope, cred);
            }
            this.interaction.setClient(client);
            this.interaction.setMethod((HttpMethod)new GetMethod(urlToUse));
            this.interaction.setFollowRedirects(true);
            if (null != this.acceptHeader) {
                this.interaction.setRequestHeader("Accept", this.acceptHeader);
            } else {
                this.interaction.setRequestHeader("Accept", "*/*");
            }
            if (this.useCaching) {
                this.applyCacheHeaders(cacheProperties, this.interaction);
            }
            logger.debug((Object)("Making remote request: " + cleanUrl));
            try {
                this.resultCode = this.interaction.executeMethod();
                this.reasonCode = this.interaction.getStatusText();
                if (this.useCaching && 304 == this.resultCode) {
                    logger.debug((Object)"Content NOT MODIFIED: file up to date");
                    break block26;
                }
                if (200 == this.resultCode) {
                    this.determineContentType(this.interaction);
                    FileOutputStream output = new FileOutputStream(destinationFile);
                    try {
                        Streams.copyStream(this.interaction.getResponseBodyAsStream(), output);
                    }
                    finally {
                        output.close();
                    }
                    if (destinationFile.length() < 1L && !destinationFile.delete()) {
                        logger.warn((Object)("Failed to remove empty file: " + destinationFile.getAbsolutePath()));
                    }
                    if (this.useCaching) {
                        this.cacheResponseInfo(this.interaction, this.cacheMetadata);
                    }
                    break block26;
                }
                throw new FileUpdaterException("Unable to retrieve content: result code: " + this.resultCode + " " + this.reasonCode);
            }
            catch (HttpException e) {
                throw new FileUpdaterException((Exception)((Object)e));
            }
            catch (IOException e) {
                throw new FileUpdaterException(e);
            }
            finally {
                this.interaction.releaseConnection();
            }
        }
    }

    private void applyCacheHeaders(Properties cacheProperties, httpClientInteraction method) {
        if (this.isCachedContentPresent() && null != this.contentType) {
            if (cacheProperties.containsKey(E_TAG)) {
                method.setRequestHeader(IF_NONE_MATCH, cacheProperties.getProperty(E_TAG));
            }
            if (cacheProperties.containsKey(LAST_MODIFIED)) {
                method.setRequestHeader(IF_MODIFIED_SINCE, cacheProperties.getProperty(LAST_MODIFIED));
            }
        }
    }

    private boolean isCachedContentPresent() {
        return this.cachedContent.isFile() && this.cachedContent.length() > 0L;
    }

    private void contentTypeFromCache(Properties cacheProperties) {
        if (cacheProperties.containsKey(CONTENT_TYPE)) {
            this.contentType = cacheProperties.getProperty(CONTENT_TYPE);
            this.cleanContentType();
        }
    }

    private void determineContentType(httpClientInteraction method) {
        if (null != method.getResponseHeader(CONTENT_TYPE)) {
            this.contentType = method.getResponseHeader(CONTENT_TYPE).getValue();
            this.cleanContentType();
        }
    }

    private void cleanContentType() {
        if (null != this.contentType && this.contentType.indexOf(";") > 0) {
            this.contentType = this.contentType.substring(0, this.contentType.indexOf(";")).trim();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties loadCacheData(File cacheFile) {
        Properties cacheProperties = new Properties();
        if (cacheFile.isFile()) {
            try {
                FileInputStream fileInputStream = new FileInputStream(cacheFile);
                try {
                    cacheProperties.load(fileInputStream);
                }
                finally {
                    fileInputStream.close();
                }
            }
            catch (IOException e) {
                logger.debug((Object)("failed to load cache data from file: " + cacheFile));
            }
        }
        return cacheProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cacheResponseInfo(httpClientInteraction method, File cacheFile) {
        Properties newprops = new Properties();
        if (null != method.getResponseHeader(LAST_MODIFIED)) {
            newprops.setProperty(LAST_MODIFIED, method.getResponseHeader(LAST_MODIFIED).getValue());
        }
        if (null != method.getResponseHeader(E_TAG)) {
            newprops.setProperty(E_TAG, method.getResponseHeader(E_TAG).getValue());
        }
        if (null != method.getResponseHeader(CONTENT_TYPE)) {
            newprops.setProperty(CONTENT_TYPE, method.getResponseHeader(CONTENT_TYPE).getValue());
        }
        if (newprops.size() > 0) {
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(cacheFile);
                try {
                    newprops.store(fileOutputStream, "URLFileUpdater cache data for URL: " + this.url);
                }
                finally {
                    fileOutputStream.close();
                }
            }
            catch (IOException e) {
                logger.debug((Object)("Failed to write cache header info to file: " + cacheFile + ", " + e.getMessage()), (Throwable)e);
            }
        } else if (cacheFile.exists() && !cacheFile.delete()) {
            logger.warn((Object)("Unable to delete cachefile: " + cacheFile.getAbsolutePath()));
        }
    }

    public String getContentType() {
        return this.contentType;
    }

    public int getResultCode() {
        return this.resultCode;
    }

    public String getReasonCode() {
        return this.reasonCode;
    }

    public static class Factory
    implements URLFileUpdaterFactory {
        @Override
        public FileUpdater fileUpdaterFromURL(URL url, String username, String password) {
            return new URLFileUpdater(url, null, -1, null, null, false, username, password);
        }
    }

    static final class normalInteraction
    implements httpClientInteraction {
        private HttpMethod method;
        private HttpClient client;

        normalInteraction() {
        }

        @Override
        public void setMethod(HttpMethod method) {
            this.method = method;
        }

        @Override
        public void setClient(HttpClient client) {
            this.client = client;
        }

        @Override
        public int executeMethod() throws IOException {
            return this.client.executeMethod(this.method);
        }

        @Override
        public String getStatusText() {
            return this.method.getStatusText();
        }

        @Override
        public InputStream getResponseBodyAsStream() throws IOException {
            return this.method.getResponseBodyAsStream();
        }

        @Override
        public void releaseConnection() {
            this.method.releaseConnection();
        }

        @Override
        public void setRequestHeader(String name, String value) {
            this.method.setRequestHeader(name, value);
        }

        @Override
        public Header getResponseHeader(String name) {
            return this.method.getResponseHeader(name);
        }

        @Override
        public void setFollowRedirects(boolean follow) {
            this.method.setFollowRedirects(follow);
        }
    }

    public static interface httpClientInteraction {
        public void setMethod(HttpMethod var1);

        public void setClient(HttpClient var1);

        public int executeMethod() throws IOException;

        public String getStatusText();

        public InputStream getResponseBodyAsStream() throws IOException;

        public void releaseConnection();

        public void setRequestHeader(String var1, String var2);

        public Header getResponseHeader(String var1);

        public void setFollowRedirects(boolean var1);
    }
}

