/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.dispatcher;

import com.dtolabs.rundeck.core.common.Framework;
import com.dtolabs.rundeck.core.dispatcher.CentralDispatcher;
import com.dtolabs.rundeck.core.dispatcher.CentralDispatcherException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.apache.log4j.Logger;

public class CentralDispatcherMgrFactory {
    public static final Logger logger = Logger.getLogger(CentralDispatcherMgrFactory.class);
    private final CentralDispatcher centralDispatcher;

    private CentralDispatcherMgrFactory(String classname, Framework framework) throws CentralDispatcherException {
        if (null == classname) {
            throw new IllegalArgumentException("A null java class name was specified.");
        }
        this.centralDispatcher = this.createCentralDispatcher(classname, framework);
    }

    public static CentralDispatcherMgrFactory create(String classname, Framework framework) throws CentralDispatcherException {
        return new CentralDispatcherMgrFactory(classname, framework);
    }

    public CentralDispatcher getCentralDispatcher() {
        return this.centralDispatcher;
    }

    private CentralDispatcher createCentralDispatcher(String classname, Framework framework) throws CentralDispatcherException {
        CentralDispatcher centralDispatcher;
        if (null == classname) {
            throw new IllegalArgumentException("A null java class name was specified.");
        }
        logger.debug((Object)("using centralDispatcher class: " + classname));
        try {
            Class<?> cls = Class.forName(classname);
            Constructor<?> method = cls.getDeclaredConstructor(Framework.class);
            centralDispatcher = (CentralDispatcher)method.newInstance(framework);
        }
        catch (ClassNotFoundException e) {
            throw new CentralDispatcherException("error instantiating centralDispatcher class: " + classname, e);
        }
        catch (IllegalAccessException e) {
            throw new CentralDispatcherException("error instantiating centralDispatcher class: " + classname, e);
        }
        catch (NoSuchMethodException e) {
            throw new CentralDispatcherException("error instantiating centralDispatcher class: " + classname, e);
        }
        catch (InvocationTargetException e) {
            throw new CentralDispatcherException("error instantiating centralDispatcher class: " + classname, e);
        }
        catch (InstantiationException e) {
            throw new CentralDispatcherException("error instantiating centralDispatcher class: " + classname, e);
        }
        return centralDispatcher;
    }
}

