/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.execution.impl.common;

import com.dtolabs.rundeck.core.common.Framework;
import com.dtolabs.rundeck.core.common.INodeEntry;
import com.dtolabs.rundeck.core.dispatcher.DataContextUtils;
import com.dtolabs.rundeck.core.execution.ExecutionContext;
import com.dtolabs.rundeck.core.execution.script.ScriptfileUtils;
import com.dtolabs.rundeck.core.execution.service.FileCopierException;
import com.dtolabs.rundeck.core.execution.workflow.steps.StepFailureReason;
import com.dtolabs.utils.Streams;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.io.Writer;
import java.util.Map;

public class BaseFileCopier {
    public static final String FILE_COPY_DESTINATION_DIR = "file-copy-destination-dir";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File writeScriptTempFile(ExecutionContext context, File original, InputStream input, String script, INodeEntry node) throws FileCopierException {
        File tempfile;
        block13: {
            Framework framework = context.getFramework();
            Map<String, Map<String, String>> origContext = context.getDataContext();
            Map<String, Map<String, String>> dataContext = DataContextUtils.addContext("node", DataContextUtils.nodeData(node), origContext);
            tempfile = null;
            try {
                if (null != original) {
                    tempfile = ScriptfileUtils.createTempFile(framework);
                    FileInputStream in = new FileInputStream(original);
                    try {
                        FileOutputStream out = new FileOutputStream(tempfile);
                        try {
                            Streams.copyStream(in, out);
                            break block13;
                        }
                        finally {
                            out.close();
                        }
                    }
                    finally {
                        in.close();
                    }
                }
                if (null != script) {
                    tempfile = DataContextUtils.replaceTokensInScript(script, dataContext, framework);
                    break block13;
                }
                if (null != input) {
                    tempfile = DataContextUtils.replaceTokensInStream(input, dataContext, framework);
                    break block13;
                }
                return null;
            }
            catch (IOException e) {
                throw new FileCopierException("error writing script to tempfile: " + e.getMessage(), StepFailureReason.IOFailure, e);
            }
        }
        try {
            ScriptfileUtils.setExecutePermissions(tempfile);
        }
        catch (IOException e) {
            System.err.println("Failed to set execute permissions on tempfile, execution may fail: " + tempfile.getAbsolutePath());
        }
        return tempfile;
    }

    public static String appendRemoteFileExtensionForNode(INodeEntry node, String filepath) {
        String result = filepath;
        result = null != node.getOsFamily() && "windows".equalsIgnoreCase(node.getOsFamily().trim()) ? result + (filepath.endsWith(".bat") ? "" : ".bat") : result + (filepath.endsWith(".sh") ? "" : ".sh");
        return result;
    }

    public static String getRemoteDirForNode(INodeEntry node) {
        if (null != node.getAttributes() && null != node.getAttributes().get(FILE_COPY_DESTINATION_DIR)) {
            String s = node.getAttributes().get(FILE_COPY_DESTINATION_DIR);
            return s.endsWith("/") ? s : s + "/";
        }
        String remotedir = "/tmp/";
        if (null != node.getOsFamily() && "windows".equalsIgnoreCase(node.getOsFamily().trim())) {
            remotedir = "C:/WINDOWS/TEMP/";
        }
        return remotedir;
    }

    public static String generateRemoteFilepathForNode(INodeEntry node, String scriptfileName) {
        String remoteFilename = BaseFileCopier.appendRemoteFileExtensionForNode(node, BaseFileCopier.cleanFileName(System.currentTimeMillis() + "-" + node.getNodename() + "-" + scriptfileName));
        String remotedir = BaseFileCopier.getRemoteDirForNode(node);
        return remotedir + remoteFilename;
    }

    private static String cleanFileName(String nodename) {
        return nodename.replaceAll("[^a-zA-Z0-9_.-]", "_");
    }

    protected static File writeTempFile(ExecutionContext context, File original, InputStream input, String script) throws FileCopierException {
        File tempfile = null;
        try {
            tempfile = ScriptfileUtils.createTempFile(context.getFramework());
        }
        catch (IOException e) {
            throw new FileCopierException("error writing to tempfile: " + e.getMessage(), StepFailureReason.IOFailure, e);
        }
        return BaseFileCopier.writeLocalFile(original, input, script, tempfile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static File writeLocalFile(File original, InputStream input, String script, File destinationFile) throws FileCopierException {
        try {
            block17: {
                if (null != original) {
                    FileInputStream in = new FileInputStream(original);
                    try {
                        FileOutputStream out = new FileOutputStream(destinationFile);
                        try {
                            Streams.copyStream(in, out);
                            break block17;
                        }
                        finally {
                            out.close();
                        }
                    }
                    finally {
                        ((InputStream)in).close();
                    }
                }
                if (null != input) {
                    InputStream in = input;
                    FileOutputStream out = new FileOutputStream(destinationFile);
                    try {
                        Streams.copyStream(in, out);
                    }
                    finally {
                        out.close();
                    }
                }
                if (null != script) {
                    StringReader in = new StringReader(script);
                    FileOutputStream out = new FileOutputStream(destinationFile);
                    OutputStreamWriter write = new OutputStreamWriter(out);
                    try {
                        Streams.copyWriterCount(in, write);
                        ((Writer)write).flush();
                    }
                    finally {
                        out.close();
                    }
                }
            }
            return destinationFile;
        }
        catch (IOException e) {
            throw new FileCopierException("error writing to tempfile: " + e.getMessage(), StepFailureReason.IOFailure, e);
        }
    }
}

