/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.execution.service;

import com.dtolabs.rundeck.core.common.Framework;
import com.dtolabs.rundeck.core.common.INodeEntry;
import com.dtolabs.rundeck.core.dispatcher.DataContextUtils;
import com.dtolabs.rundeck.core.execution.ExecutionContext;
import com.dtolabs.rundeck.core.execution.service.NodeExecutor;
import com.dtolabs.rundeck.core.execution.service.NodeExecutorResult;
import com.dtolabs.rundeck.core.execution.service.NodeExecutorResultImpl;
import com.dtolabs.rundeck.core.execution.workflow.steps.StepFailureReason;
import com.dtolabs.rundeck.core.execution.workflow.steps.node.NodeStepFailureReason;
import com.dtolabs.rundeck.core.plugins.BaseScriptPlugin;
import com.dtolabs.rundeck.core.plugins.PluginException;
import com.dtolabs.rundeck.core.plugins.ScriptPluginProvider;
import com.dtolabs.rundeck.core.utils.ScriptExecUtil;
import com.dtolabs.rundeck.core.utils.StringArrayUtil;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

class ScriptPluginNodeExecutor
extends BaseScriptPlugin
implements NodeExecutor {
    ScriptPluginNodeExecutor(ScriptPluginProvider provider, Framework framework) {
        super(provider, framework);
    }

    @Override
    public boolean isAllowCustomProperties() {
        return false;
    }

    static void validateScriptPlugin(ScriptPluginProvider plugin) throws PluginException {
    }

    @Override
    public NodeExecutorResult executeCommand(ExecutionContext executionContext, String[] command, INodeEntry node) {
        ScriptPluginProvider plugin = this.getProvider();
        String pluginname = plugin.getName();
        executionContext.getExecutionListener().log(3, "[" + pluginname + "] execCommand started, command: " + StringArrayUtil.asString(command, " "));
        Map<String, Map<String, String>> localDataContext = this.createScriptDataContext(executionContext.getFramework(), executionContext.getFrameworkProject(), executionContext.getDataContext());
        HashMap<String, String> scptexec = new HashMap<String, String>();
        scptexec.put("command", StringArrayUtil.asString(command, " "));
        localDataContext.put("exec", scptexec);
        String[] finalargs = this.createScriptArgs(localDataContext);
        executionContext.getExecutionListener().log(3, "[" + this.getProvider().getName() + "] executing: " + Arrays.asList(finalargs));
        int result = -1;
        try {
            result = ScriptExecUtil.runLocalCommand(finalargs, DataContextUtils.generateEnvVarsFromContext(localDataContext), null, System.out, System.err);
            executionContext.getExecutionListener().log(3, "[" + pluginname + "]: result code: " + result + ", success: " + (0 == result));
            if (0 != result) {
                return NodeExecutorResultImpl.createFailure(NodeStepFailureReason.NonZeroResultCode, "Result code: " + result, node, result);
            }
            return NodeExecutorResultImpl.createSuccess(node);
        }
        catch (IOException e) {
            return NodeExecutorResultImpl.createFailure(StepFailureReason.IOFailure, e.getMessage(), e, node, result);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return NodeExecutorResultImpl.createFailure(StepFailureReason.Interrupted, e.getMessage(), e, node, result);
        }
    }
}

