/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.execution.workflow.steps;

import com.dtolabs.rundeck.core.execution.HasSourceResult;
import com.dtolabs.rundeck.core.execution.StatusResult;
import com.dtolabs.rundeck.core.execution.workflow.steps.FailureReason;
import com.dtolabs.rundeck.core.execution.workflow.steps.StepException;
import com.dtolabs.rundeck.core.execution.workflow.steps.StepExecutionResult;
import java.util.HashMap;
import java.util.Map;

public class StepExecutionResultImpl
implements StepExecutionResult,
HasSourceResult {
    private boolean success = true;
    private Exception exception;
    private StatusResult sourceResult;
    private Map<String, Object> resultData = new HashMap<String, Object>();
    private Map<String, Object> failureData = new HashMap<String, Object>();
    private FailureReason failureReason;
    private String failureMessage;

    public StepExecutionResultImpl() {
    }

    public StepExecutionResultImpl(Exception exception, FailureReason failureReason, String failureMessage) {
        this();
        this.success = false;
        this.exception = exception;
        this.failureReason = failureReason;
        this.failureMessage = failureMessage;
    }

    public static StepExecutionResultImpl wrapStepException(StepException e) {
        return new StepExecutionResultImpl(e, e.getFailureReason(), e.getMessage());
    }

    @Override
    public boolean isSuccess() {
        return this.success;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    @Override
    public Exception getException() {
        return this.exception;
    }

    public void setException(Exception exception) {
        this.exception = exception;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof StepExecutionResultImpl)) {
            return false;
        }
        StepExecutionResultImpl result = (StepExecutionResultImpl)o;
        if (this.success != result.success) {
            return false;
        }
        if (this.exception != null ? !this.exception.equals(result.exception) : result.exception != null) {
            return false;
        }
        if (this.failureData != null ? !((Object)this.failureData).equals(result.failureData) : result.failureData != null) {
            return false;
        }
        return !(this.resultData != null ? !((Object)this.resultData).equals(result.resultData) : result.resultData != null);
    }

    public int hashCode() {
        int result = this.success ? 1 : 0;
        result = 31 * result + (this.exception != null ? this.exception.hashCode() : 0);
        result = 31 * result + (this.resultData != null ? ((Object)this.resultData).hashCode() : 0);
        result = 31 * result + (this.failureData != null ? ((Object)this.failureData).hashCode() : 0);
        return result;
    }

    public String toString() {
        if (this.success) {
            return null != this.sourceResult ? this.sourceResult.toString() : "Step successful";
        }
        return this.failureReason + ": " + this.failureMessage;
    }

    @Override
    public StatusResult getSourceResult() {
        return this.sourceResult;
    }

    public void setSourceResult(StatusResult sourceResult) {
        this.sourceResult = sourceResult;
    }

    @Override
    public Map<String, Object> getResultData() {
        return this.resultData;
    }

    public void setResultData(Map<String, Object> resultData) {
        this.resultData = resultData;
    }

    @Override
    public Map<String, Object> getFailureData() {
        return this.failureData;
    }

    public void setFailureData(Map<String, Object> failureData) {
        this.failureData = failureData;
    }

    @Override
    public FailureReason getFailureReason() {
        return this.failureReason;
    }

    @Override
    public String getFailureMessage() {
        return this.failureMessage;
    }
}

