/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.resources;

import com.dtolabs.rundeck.core.common.Framework;
import com.dtolabs.rundeck.core.common.INodeSet;
import com.dtolabs.rundeck.core.common.NodeEntryImpl;
import com.dtolabs.rundeck.core.common.NodeSetImpl;
import com.dtolabs.rundeck.core.plugins.configuration.Configurable;
import com.dtolabs.rundeck.core.plugins.configuration.ConfigurationException;
import com.dtolabs.rundeck.core.plugins.configuration.Description;
import com.dtolabs.rundeck.core.resources.ResourceModelSource;
import com.dtolabs.rundeck.core.resources.ResourceModelSourceException;
import com.dtolabs.rundeck.core.resources.format.ResourceFormatGenerator;
import com.dtolabs.rundeck.core.resources.format.ResourceFormatGeneratorException;
import com.dtolabs.rundeck.core.resources.format.ResourceFormatParser;
import com.dtolabs.rundeck.core.resources.format.ResourceFormatParserException;
import com.dtolabs.rundeck.core.resources.format.UnsupportedFormatException;
import com.dtolabs.rundeck.plugins.util.DescriptionBuilder;
import com.dtolabs.rundeck.plugins.util.PropertyBuilder;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.Properties;

public class FileResourceModelSource
implements ResourceModelSource,
Configurable {
    private Framework framework;
    private NodeSetImpl nodeSet;
    private Configuration configuration;
    long lastModTime = 0L;

    FileResourceModelSource(Framework framework) {
        this.framework = framework;
        this.nodeSet = new NodeSetImpl();
    }

    static Description createDescription(List<String> formats) {
        return DescriptionBuilder.builder().name("file").title("File").description("Reads a file containing node definitions in a supported format").property(PropertyBuilder.builder().freeSelect("format").title("Format").description("Format of the file").values(formats).build()).property(PropertyBuilder.builder().string("file").title("File Path").description("Path of the file").required(true).build()).property(PropertyBuilder.builder().booleanType("generateFileAutomatically").title("Generate").description("Automatically generate the file if it is missing?").required(true).defaultValue("false").build()).property(PropertyBuilder.builder().booleanType("includeServerNode").title("Include Server Node").description("Automatically include the server node in the generated file?").required(true).defaultValue("false").build()).property(PropertyBuilder.builder().booleanType("requireFileExists").title("Require File Exists").description("Require that the file exists").required(true).defaultValue("false").build()).build();
    }

    @Override
    public void configure(Properties configs) throws ConfigurationException {
        Configuration configuration1 = Configuration.fromProperties(configs);
        this.configure(configuration1);
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        this.configuration = new Configuration(configuration);
        this.configuration.validate();
    }

    @Override
    public INodeSet getNodes() throws ResourceModelSourceException {
        return this.getNodes(this.configuration.nodesFile, this.configuration.format);
    }

    public synchronized INodeSet getNodes(File nodesFile, String format) throws ResourceModelSourceException {
        Long modtime = nodesFile.lastModified();
        if (0 == this.nodeSet.getNodes().size() || !modtime.equals(this.lastModTime)) {
            this.nodeSet = new NodeSetImpl();
            this.loadNodes(nodesFile, format);
            this.lastModTime = modtime;
        }
        return this.nodeSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateResourcesFile(File resfile, String format) throws ResourceModelSourceException {
        ResourceFormatGenerator generator;
        NodeEntryImpl node = this.framework.createFrameworkNode();
        node.setFrameworkProject(this.configuration.project);
        if (null != format) {
            try {
                generator = this.framework.getResourceFormatGeneratorService().getGeneratorForFormat(format);
            }
            catch (UnsupportedFormatException e) {
                throw new ResourceModelSourceException(e);
            }
        }
        try {
            generator = this.framework.getResourceFormatGeneratorService().getGeneratorForFileExtension(resfile);
        }
        catch (UnsupportedFormatException e) {
            throw new ResourceModelSourceException(e);
        }
        if (this.configuration.includeServerNode) {
            NodeSetImpl nodes = new NodeSetImpl();
            nodes.putNode(node);
            try {
                FileOutputStream stream = new FileOutputStream(resfile);
                try {
                    generator.generateDocument(nodes, stream);
                }
                finally {
                    stream.close();
                }
            }
            catch (IOException e) {
                throw new ResourceModelSourceException(e);
            }
            catch (ResourceFormatGeneratorException e) {
                throw new ResourceModelSourceException(e);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void loadNodes(File nodesFile, String format) throws ResourceModelSourceException {
        if (!nodesFile.isFile() && this.configuration.generateFileAutomatically) {
            this.generateResourcesFile(nodesFile, format);
        } else if (this.configuration.includeServerNode) {
            NodeEntryImpl node = this.framework.createFrameworkNode();
            this.nodeSet.putNode(node);
        }
        if (nodesFile.isFile()) {
            ResourceFormatParser parser = this.createParser(nodesFile, format);
            try {
                INodeSet set = parser.parseDocument(nodesFile);
                if (null == set) return;
                this.nodeSet.putNodes(set);
                return;
            }
            catch (ResourceFormatParserException e) {
                throw new ResourceModelSourceException(e);
            }
        } else {
            if (!this.configuration.requireFileExists) return;
            throw new ResourceModelSourceException("File does not exist: " + nodesFile);
        }
    }

    protected ResourceFormatParser createParser(File file, String format) throws ResourceModelSourceException {
        try {
            if (null != format) {
                return this.framework.getResourceFormatParserService().getParserForFormat(format);
            }
            return this.framework.getResourceFormatParserService().getParserForFileExtension(file);
        }
        catch (UnsupportedFormatException e) {
            throw new ResourceModelSourceException(e);
        }
    }

    public static INodeSet parseFile(String file, Framework framework, String project) throws ResourceModelSourceException, ConfigurationException {
        return FileResourceModelSource.parseFile(new File(file), framework, project);
    }

    public static INodeSet parseFile(File file, Framework framework, String project) throws ResourceModelSourceException, ConfigurationException {
        FileResourceModelSource prov = new FileResourceModelSource(framework);
        prov.configure(Configuration.build().file(file).includeServerNode(false).generateFileAutomatically(false).project(project).requireFileExists(true));
        return prov.getNodes();
    }

    public static INodeSet parseFile(File file, String format, Framework framework, String project) throws ResourceModelSourceException, ConfigurationException {
        FileResourceModelSource prov = new FileResourceModelSource(framework);
        prov.configure(Configuration.build().file(file).includeServerNode(false).generateFileAutomatically(false).project(project).format(format).requireFileExists(true));
        return prov.getNodes();
    }

    public String toString() {
        return "FileResourceModelSource{file=" + this.configuration.nodesFile + ", format=" + this.configuration.format + '}';
    }

    public static class Configuration {
        public static final String GENERATE_FILE_AUTOMATICALLY = "generateFileAutomatically";
        public static final String INCLUDE_SERVER_NODE = "includeServerNode";
        public static final String FILE = "file";
        public static final String PROJECT = "project";
        public static final String FORMAT = "format";
        public static final String REQUIRE_FILE_EXISTS = "requireFileExists";
        String format;
        File nodesFile;
        String project;
        boolean generateFileAutomatically;
        boolean includeServerNode;
        boolean requireFileExists;
        final Properties configuration;

        Configuration() {
            this.configuration = new Properties();
        }

        Configuration(Properties configuration) {
            if (null == configuration) {
                throw new NullPointerException("configuration");
            }
            this.configuration = configuration;
            this.configure();
        }

        Configuration(Configuration configuration) {
            this(configuration.getProperties());
        }

        public static Configuration fromProperties(Properties configuration) {
            return new Configuration(configuration);
        }

        public static Configuration clone(Configuration configuration) {
            return Configuration.fromProperties(configuration.getProperties());
        }

        public static Configuration build() {
            return new Configuration();
        }

        public Configuration format(String format) {
            this.format = format;
            this.configuration.put(FORMAT, format);
            return this;
        }

        public Configuration file(File file) {
            this.nodesFile = file;
            this.configuration.put(FILE, file.getAbsolutePath());
            return this;
        }

        public Configuration file(String file) {
            this.nodesFile = new File(file);
            this.configuration.put(FILE, file);
            return this;
        }

        public Configuration project(String project) {
            this.project = project;
            this.configuration.put(PROJECT, project);
            return this;
        }

        public Configuration includeServerNode(boolean include) {
            this.includeServerNode = include;
            this.configuration.put(INCLUDE_SERVER_NODE, Boolean.toString(include));
            return this;
        }

        public Configuration generateFileAutomatically(boolean generate) {
            this.generateFileAutomatically = generate;
            this.configuration.put(GENERATE_FILE_AUTOMATICALLY, Boolean.toString(generate));
            return this;
        }

        public Configuration requireFileExists(boolean require) {
            this.requireFileExists = require;
            this.configuration.put(REQUIRE_FILE_EXISTS, Boolean.toString(this.requireFileExists));
            return this;
        }

        public Properties getProperties() {
            return this.configuration;
        }

        void configure() {
            if (this.configuration.containsKey(PROJECT)) {
                this.project = this.configuration.getProperty(PROJECT);
            }
            if (this.configuration.containsKey(FILE)) {
                this.nodesFile = new File(this.configuration.getProperty(FILE));
            }
            if (this.configuration.containsKey(FORMAT)) {
                this.format = this.configuration.getProperty(FORMAT);
            }
            if (this.configuration.containsKey(GENERATE_FILE_AUTOMATICALLY)) {
                this.generateFileAutomatically = Boolean.parseBoolean(this.configuration.getProperty(GENERATE_FILE_AUTOMATICALLY));
            }
            if (this.configuration.containsKey(INCLUDE_SERVER_NODE)) {
                this.includeServerNode = Boolean.parseBoolean(this.configuration.getProperty(INCLUDE_SERVER_NODE));
            }
            if (this.configuration.containsKey(REQUIRE_FILE_EXISTS)) {
                this.requireFileExists = Boolean.parseBoolean(this.configuration.getProperty(REQUIRE_FILE_EXISTS));
            }
        }

        void validate() throws ConfigurationException {
            if (null == this.project) {
                throw new ConfigurationException("project is required");
            }
            if (null == this.nodesFile) {
                throw new ConfigurationException("file is required");
            }
        }

        public String toString() {
            return "Configuration{format=" + this.format + ", nodesFile=" + this.nodesFile + ", project='" + this.project + '\'' + ", generateFileAutomatically=" + this.generateFileAutomatically + ", includeServerNode=" + this.includeServerNode + ", requireFileExists=" + this.requireFileExists + ", configuration=" + this.configuration + '}';
        }
    }
}

