/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.resources.format;

import com.dtolabs.rundeck.core.common.Framework;
import com.dtolabs.rundeck.core.execution.service.ExecutionServiceException;
import com.dtolabs.rundeck.core.execution.service.ProviderCreationException;
import com.dtolabs.rundeck.core.plugins.PluggableProviderRegistryService;
import com.dtolabs.rundeck.core.plugins.PluginException;
import com.dtolabs.rundeck.core.plugins.ProviderIdent;
import com.dtolabs.rundeck.core.plugins.ScriptPluginProvider;
import com.dtolabs.rundeck.core.plugins.configuration.Describable;
import com.dtolabs.rundeck.core.plugins.configuration.DescribableService;
import com.dtolabs.rundeck.core.plugins.configuration.Description;
import com.dtolabs.rundeck.core.resources.format.ResourceFormatGenerator;
import com.dtolabs.rundeck.core.resources.format.ResourceFormatParserService;
import com.dtolabs.rundeck.core.resources.format.ResourceXMLFormatGenerator;
import com.dtolabs.rundeck.core.resources.format.ResourceYamlFormatGenerator;
import com.dtolabs.rundeck.core.resources.format.UnsupportedFormatException;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class ResourceFormatGeneratorService
extends PluggableProviderRegistryService<ResourceFormatGenerator>
implements DescribableService {
    public static final String SERVICE_NAME = "ResourceFormatGenerator";

    public ResourceFormatGeneratorService(Framework framework) {
        super(framework);
        this.registry.put("resourcexml", ResourceXMLFormatGenerator.class);
        this.registry.put("resourceyaml", ResourceYamlFormatGenerator.class);
    }

    @Override
    public String getName() {
        return SERVICE_NAME;
    }

    public List<String> listFormats() {
        ArrayList<String> list = new ArrayList<String>();
        for (ProviderIdent providerIdent : this.listProviders()) {
            list.add(providerIdent.getProviderName());
        }
        return list;
    }

    public ResourceFormatGenerator getGeneratorForFileExtension(File file) throws UnsupportedFormatException {
        String extension;
        String string = extension = file.getName().lastIndexOf(".") > 0 ? file.getName().substring(file.getName().lastIndexOf(".") + 1) : null;
        if (null != extension) {
            return this.getGeneratorForFileExtension(extension);
        }
        throw new UnsupportedFormatException("Could not determine format for file: " + file.getAbsolutePath());
    }

    public ResourceFormatGenerator getGeneratorForFileExtension(String extension) throws UnsupportedFormatException {
        for (ResourceFormatGenerator generator : this.listGenerators()) {
            if (!generator.getFileExtensions().contains(extension)) continue;
            return generator;
        }
        throw new UnsupportedFormatException("No provider available to parse file extension: " + extension);
    }

    public ResourceFormatGenerator getGeneratorForFormat(String format) throws UnsupportedFormatException {
        try {
            return (ResourceFormatGenerator)this.providerOfType(format);
        }
        catch (ExecutionServiceException e) {
            throw new UnsupportedFormatException("No provider available to parse format: " + format, e);
        }
    }

    public ResourceFormatGenerator getGeneratorForMIMEType(String mimeType) throws UnsupportedFormatException {
        String cleanMime = mimeType.indexOf(";") > 0 ? mimeType.substring(0, mimeType.indexOf(";")) : mimeType;
        if (!ResourceFormatParserService.validMimeType(cleanMime)) {
            throw new IllegalArgumentException("Invalid MIME type: " + mimeType);
        }
        for (ResourceFormatGenerator generator : this.listGenerators()) {
            if (null == generator.getMIMETypes()) continue;
            if (generator.getMIMETypes().contains(cleanMime)) {
                return generator;
            }
            for (String s : generator.getMIMETypes()) {
                String t2;
                String t1;
                if (!ResourceFormatParserService.validMimeType(s) || !cleanMime.startsWith("*/") || !(t1 = cleanMime.substring(2)).equals(t2 = s.substring(s.indexOf("/") + 1))) continue;
                return generator;
            }
        }
        throw new UnsupportedFormatException("No provider available to parse MIME type: " + mimeType);
    }

    @Override
    public boolean isValidProviderClass(Class clazz) {
        return ResourceFormatGenerator.class.isAssignableFrom(clazz) && this.hasValidProviderSignature(clazz);
    }

    @Override
    public ResourceFormatGenerator createProviderInstance(Class<ResourceFormatGenerator> clazz, String name) throws PluginException, ProviderCreationException {
        return this.createProviderInstanceFromType(clazz, name);
    }

    @Override
    public boolean isScriptPluggable() {
        return false;
    }

    @Override
    public ResourceFormatGenerator createScriptProviderInstance(ScriptPluginProvider provider) throws PluginException {
        return null;
    }

    @Override
    public List<ProviderIdent> listDescribableProviders() {
        return this.listProviders();
    }

    @Override
    public List<Description> listDescriptions() {
        ArrayList<Description> list = new ArrayList<Description>();
        for (ResourceFormatGenerator provider : this.listGenerators()) {
            if (!(provider instanceof Describable)) continue;
            Describable desc = (Describable)((Object)provider);
            list.add(desc.getDescription());
        }
        return list;
    }

    private List<ResourceFormatGenerator> listGenerators() {
        ArrayList<ResourceFormatGenerator> list = new ArrayList<ResourceFormatGenerator>();
        for (ProviderIdent providerIdent : this.listProviders()) {
            try {
                ResourceFormatGenerator providerForType = (ResourceFormatGenerator)this.providerOfType(providerIdent.getProviderName());
                list.add(providerForType);
            }
            catch (ExecutionServiceException e) {
                e.printStackTrace();
            }
        }
        return list;
    }

    public static ResourceFormatGeneratorService getInstanceForFramework(Framework framework) {
        if (null == framework.getService(SERVICE_NAME)) {
            ResourceFormatGeneratorService service = new ResourceFormatGeneratorService(framework);
            framework.setService(SERVICE_NAME, service);
            return service;
        }
        return (ResourceFormatGeneratorService)framework.getService(SERVICE_NAME);
    }
}

