/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.resources.format;

import com.dtolabs.rundeck.core.common.INodeSet;
import com.dtolabs.rundeck.core.plugins.Plugin;
import com.dtolabs.rundeck.core.resources.format.ResourceFormatGenerator;
import com.dtolabs.rundeck.core.resources.format.ResourceFormatGeneratorException;
import com.dtolabs.shared.resources.ResourceXMLGenerator;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

@Plugin(name="resourcexml", service="ResourceFormatGenerator")
public class ResourceXMLFormatGenerator
implements ResourceFormatGenerator {
    public static final String SERVICE_PROVIDER_TYPE = "resourcexml";
    public static final Set<String> EXTENSIONS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("xml")));
    public static final List<String> MIME_TYPES = Collections.unmodifiableList(Arrays.asList("text/xml"));

    @Override
    public Set<String> getFileExtensions() {
        return EXTENSIONS;
    }

    @Override
    public List<String> getMIMETypes() {
        return MIME_TYPES;
    }

    @Override
    public void generateDocument(INodeSet nodeset, OutputStream stream) throws ResourceFormatGeneratorException, IOException {
        ResourceXMLGenerator resourceXMLGenerator = new ResourceXMLGenerator(stream);
        resourceXMLGenerator.addNodes(nodeset.getNodes());
        resourceXMLGenerator.generate();
    }
}

