/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.utils;

import com.dtolabs.rundeck.core.utils.QuotedStringTokenizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class OptsUtil {
    private static final char DBL_QUOTE = '\"';
    private static final char SINGLE_QUOTE = '\'';
    private static final char[] CSV_SEARCH_CHARS = new char[]{' ', '\"', '\'', '\r', '\n'};

    public static String[] burst(String argLine) {
        return QuotedStringTokenizer.tokenizeToArray(argLine);
    }

    public static String join(String first, String[] args) {
        return OptsUtil.join(first, Arrays.asList(args));
    }

    public static String join(String[] args) {
        return OptsUtil.join(Arrays.asList(args));
    }

    public static String join(String first, List<String> args) {
        ArrayList<String> strings = new ArrayList<String>(args.size() + 1);
        strings.add(first);
        strings.addAll(args);
        return OptsUtil.join(strings);
    }

    public static String join(List<String> args) {
        StringBuilder sb = new StringBuilder();
        for (String str : args) {
            if (sb.length() > 0) {
                sb.append(" ");
            }
            sb.append(OptsUtil.escapeChars(str));
        }
        return sb.toString();
    }

    public static String escapeChars(String str) {
        StringBuilder stringBuilder = new StringBuilder();
        OptsUtil.escapeChars(stringBuilder, str);
        return stringBuilder.toString();
    }

    public static void escapeChars(StringBuilder out, String str) {
        if (StringUtils.containsNone((String)str, (char[])CSV_SEARCH_CHARS) && !"".equals(str)) {
            if (str != null) {
                out.append(str);
            }
            return;
        }
        out.append('\"');
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c == '\"') {
                out.append('\"');
            }
            out.append(c);
        }
        out.append('\"');
    }
}

