/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.utils;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Queue;
import org.apache.commons.lang.text.StrMatcher;

public class QuotedStringTokenizer
implements Iterator<String>,
Iterable<String> {
    private char[] string;
    private int pos;
    private Queue<String> buffer;
    private StrMatcher delimiterMatcher;
    private StrMatcher quoteMatcher;
    private StrMatcher whitespaceMatcher;
    private boolean quashDelimiters;

    public QuotedStringTokenizer(String string) {
        this(string.toCharArray(), 0);
    }

    public QuotedStringTokenizer(char[] chars, int pos) {
        this.string = chars;
        this.pos = pos;
        this.buffer = new ArrayDeque<String>();
        this.delimiterMatcher = StrMatcher.spaceMatcher();
        this.quoteMatcher = StrMatcher.quoteMatcher();
        this.whitespaceMatcher = StrMatcher.trimMatcher();
        this.quashDelimiters = true;
        this.readNext();
    }

    public static String[] tokenizeToArray(String string) {
        List<String> strings = QuotedStringTokenizer.collectTokens(string);
        return strings.toArray(new String[strings.size()]);
    }

    public static List<String> tokenizeToList(String string) {
        return QuotedStringTokenizer.collectTokens(string);
    }

    public static Iterable<String> tokenize(String string) {
        return new QuotedStringTokenizer(string);
    }

    private static List<String> collectTokens(String string) {
        ArrayList<String> strings = new ArrayList<String>();
        for (String s : new QuotedStringTokenizer(string)) {
            strings.add(s);
        }
        return strings;
    }

    @Override
    public boolean hasNext() {
        return !this.buffer.isEmpty();
    }

    @Override
    public String next() {
        String remove = this.buffer.remove();
        this.readNext();
        return remove;
    }

    private void readNext() {
        this.pos = this.readNextToken(this.string, this.pos, this.buffer);
    }

    private int readNextToken(char[] chars, int pos, Collection<String> tokens) {
        if (pos >= chars.length) {
            return -1;
        }
        int ws = this.whitespaceMatcher.isMatch(chars, pos);
        if (ws > 0) {
            pos += ws;
        }
        if (pos >= chars.length) {
            return -1;
        }
        int delim = this.delimiterMatcher.isMatch(chars, pos);
        if (delim > 0) {
            if (this.quashDelimiters) {
                pos = this.consumeDelimiters(chars, pos, delim);
            } else {
                this.addToken(this.buffer, "");
                return pos + delim;
            }
        }
        int quote = this.quoteMatcher.isMatch(chars, pos);
        return this.readQuotedToken(chars, pos, tokens, quote);
    }

    private int consumeDelimiters(char[] chars, int start, int delim) {
        while (delim > 0 && start < chars.length - delim) {
            delim = this.delimiterMatcher.isMatch(chars, start += delim);
        }
        return start;
    }

    private int readQuotedToken(char[] chars, int start, Collection<String> tokens, int quotesize) {
        boolean quoting;
        int pos = start;
        StringBuilder tchars = new StringBuilder();
        boolean bl = quoting = quotesize > 0;
        if (quoting) {
            pos += quotesize;
        }
        while (pos < chars.length) {
            if (quoting) {
                if (this.charsMatch(chars, start, pos, quotesize)) {
                    if (this.charsMatch(chars, start, pos + quotesize, quotesize)) {
                        tchars.append(new String(chars, pos, quotesize));
                        pos += 2 * quotesize;
                        continue;
                    }
                    quoting = false;
                    pos += quotesize;
                    continue;
                }
                tchars.append(chars[pos++]);
                continue;
            }
            int delim = this.delimiterMatcher.isMatch(chars, pos);
            if (delim > 0) {
                if (this.quashDelimiters) {
                    pos = this.consumeDelimiters(chars, pos, delim);
                    this.addToken(tokens, tchars.toString());
                    return pos;
                }
                this.addToken(tokens, tchars.toString());
                return pos + delim;
            }
            if (quotesize > 0 && this.charsMatch(chars, start, pos, quotesize)) {
                quoting = true;
                pos += quotesize;
                continue;
            }
            tchars.append(chars[pos++]);
        }
        this.addToken(tokens, tchars.toString());
        return pos;
    }

    private boolean charsMatch(char[] chars, int pos1, int pos2, int len2) {
        return this.charsMatch(chars, pos1, len2, pos2, len2);
    }

    private boolean charsMatch(char[] chars, int pos1, int len1, int pos2, int len2) {
        if (len1 != len2) {
            return false;
        }
        if (pos1 + len1 > chars.length || pos2 + len2 > chars.length) {
            return false;
        }
        for (int i = 0; i < len1; ++i) {
            if (chars[pos1 + i] == chars[pos2 + i]) continue;
            return false;
        }
        return true;
    }

    private void addToken(Collection<String> buffer, String token) {
        buffer.add(token);
    }

    @Override
    public void remove() {
    }

    @Override
    public Iterator<String> iterator() {
        return this;
    }
}

