/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.cli.project;

import com.dtolabs.rundeck.core.Constants;
import com.dtolabs.rundeck.core.cli.Action;
import com.dtolabs.rundeck.core.cli.ActionMaker;
import com.dtolabs.rundeck.core.cli.CLITool;
import com.dtolabs.rundeck.core.cli.CLIToolLogger;
import com.dtolabs.rundeck.core.cli.project.CreateAction;
import com.dtolabs.rundeck.core.cli.project.InvalidArgumentsException;
import com.dtolabs.rundeck.core.cli.project.ProjectToolException;
import com.dtolabs.rundeck.core.cli.project.RemoveAction;
import com.dtolabs.rundeck.core.common.Framework;
import java.io.File;
import java.util.ArrayList;
import java.util.Properties;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.log4j.PropertyConfigurator;

public class ProjectTool
implements ActionMaker,
CLITool {
    public static final String ACTION_CREATE = "create";
    public static final String ACTION_REMOVE = "remove";
    boolean overwrite;
    boolean verbose;
    protected CommandLine cli;
    Properties extraProperties;
    protected static final Options options = new Options();
    private final Framework framework;

    public ProjectTool() {
        PropertyConfigurator.configure((String)Constants.getLog4jPropertiesFile().getAbsolutePath());
        this.framework = Framework.getInstanceWithoutProjectsDir(Constants.getSystemBaseDir());
        this.extraProperties = new Properties();
    }

    public ProjectTool(File baseDir) {
        PropertyConfigurator.configure((String)new File(Constants.getLog4jProperties(baseDir.getAbsolutePath())).getAbsolutePath());
        this.framework = Framework.getInstanceWithoutProjectsDir(baseDir.getAbsolutePath());
        this.extraProperties = new Properties();
    }

    public static void main(String[] args) throws Exception {
        ProjectTool c = new ProjectTool();
        c.run(args);
    }

    @Override
    public final void run(String[] args) {
        int exitCode = 1;
        try {
            this.parseArgs(args);
            this.executeAction();
            exitCode = 0;
        }
        catch (Throwable t) {
            if (null == t.getMessage() || this.verbose || "true".equals(System.getProperty("rdeck.traceExceptions"))) {
                t.printStackTrace();
            }
            this.error(t);
        }
        this.exit(exitCode);
    }

    @Override
    public void exit(int code) {
        System.exit(code);
    }

    @Override
    public void help() {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp(80, "rd-project [options] [ --property=value ... ]", "options:", options, "Examples:\n\trd-project -p project --action create; # Initialize project\n\n");
    }

    public void executeAction() throws ProjectToolException {
        String optAction;
        String actionName = this.cli.hasOption('a') ? (optAction = this.cli.getOptionValue('a')) : ACTION_CREATE;
        Action action = this.createAction(actionName);
        try {
            action.exec();
        }
        catch (Throwable t) {
            throw new ProjectToolException(t);
        }
    }

    @Override
    public CommandLine parseArgs(String[] args) throws ProjectToolException {
        ProjectTool.parseExtendedProperties(args, this.extraProperties);
        String[] cleaned = ProjectTool.removeExtendedProperties(args);
        PosixParser parser = new PosixParser();
        try {
            this.cli = parser.parse(options, cleaned);
        }
        catch (ParseException e) {
            this.help();
            throw new ProjectToolException(e);
        }
        this.initArgs();
        return this.cli;
    }

    static String[] removeExtendedProperties(String[] args) {
        ArrayList<String> list = new ArrayList<String>();
        for (String s : args) {
            if (ProjectTool.isExtendedPropertyArg(s)) continue;
            list.add(s);
        }
        return list.toArray(new String[list.size()]);
    }

    static boolean isExtendedPropertyArg(String s) {
        return s.startsWith("--") && s.indexOf("=") > 2;
    }

    static void parseExtendedProperties(String[] args, Properties properties) {
        for (String s : args) {
            ProjectTool.parsePropertyArg(properties, s);
        }
    }

    static void parsePropertyArg(Properties props, String s) {
        if (ProjectTool.isExtendedPropertyArg(s)) {
            int ei = s.indexOf("=");
            String key = s.substring(2, ei);
            String val = s.substring(ei + 1);
            props.setProperty(key, val);
        }
    }

    @Override
    public void initArgs() {
        if (null == this.cli) {
            throw new IllegalStateException("parseArgs must be called to instantiate the cli");
        }
        if (this.cli.hasOption("h")) {
            this.help();
            this.exit(1);
        }
        if (this.cli.hasOption('v')) {
            this.verbose = true;
        }
        if (this.cli.hasOption("S")) {
            this.verbose("strict flag set. will use registration info from resources.properties file");
        }
        if (this.cli.hasOption('n')) {
            try {
                Pattern.compile(this.cli.getOptionValue('n'));
            }
            catch (PatternSyntaxException e) {
                throw new ProjectToolException("--name argument is not a valid name or expression: \"" + this.cli.getOptionValue('n') + "\"", e);
            }
        }
    }

    @Override
    public boolean isOverwrite() {
        return this.overwrite;
    }

    @Override
    public Action createAction(String actionName) {
        try {
            if (ACTION_CREATE.equals(actionName)) {
                return new CreateAction((CLIToolLogger)this, this.framework, this.cli, this.extraProperties);
            }
            if (ACTION_REMOVE.equals(actionName)) {
                return new RemoveAction((CLIToolLogger)this, this.framework, this.cli);
            }
            throw new IllegalArgumentException("unknown action name: " + actionName);
        }
        catch (InvalidArgumentsException e) {
            this.help();
            throw e;
        }
    }

    @Override
    public void error(String output) {
        System.err.println("error: " + output);
    }

    @Override
    public void warn(String output) {
        System.err.println("warn: " + output);
    }

    private void error(Throwable t) {
        this.log(t.getMessage());
    }

    @Override
    public void log(String message) {
        System.out.println(message);
    }

    @Override
    public void verbose(String message) {
        if (this.verbose) {
            this.log(message);
        }
    }

    @Override
    public void debug(String message) {
        this.verbose(message);
    }

    static {
        options.addOption("h", "help", false, "print this message");
        options.addOption("p", "project", true, "project name");
        options.addOption("a", "action", true, "action to run {create}");
        options.addOption("v", "verbose", false, "verbose messages");
    }
}

