/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.cli.queue;

import com.dtolabs.rundeck.core.Constants;
import com.dtolabs.rundeck.core.cli.BaseTool;
import com.dtolabs.rundeck.core.cli.CLIToolLogger;
import com.dtolabs.rundeck.core.cli.CLIToolOptions;
import com.dtolabs.rundeck.core.cli.CLIToolOptionsException;
import com.dtolabs.rundeck.core.cli.DefaultCLIToolLogger;
import com.dtolabs.rundeck.core.cli.FrameworkSingleProjectResolver;
import com.dtolabs.rundeck.core.cli.Log4JCLIToolLogger;
import com.dtolabs.rundeck.core.cli.LoglevelOptions;
import com.dtolabs.rundeck.core.cli.SingleProjectResolver;
import com.dtolabs.rundeck.core.cli.queue.ConsoleExecutionFollowReceiver;
import com.dtolabs.rundeck.core.cli.queue.QueueToolException;
import com.dtolabs.rundeck.core.common.Framework;
import com.dtolabs.rundeck.core.dispatcher.CentralDispatcherException;
import com.dtolabs.rundeck.core.dispatcher.DispatcherResult;
import com.dtolabs.rundeck.core.dispatcher.ExecutionDetail;
import com.dtolabs.rundeck.core.dispatcher.ExecutionFollowRequest;
import com.dtolabs.rundeck.core.dispatcher.ExecutionFollowResult;
import com.dtolabs.rundeck.core.dispatcher.QueuedItem;
import com.dtolabs.rundeck.core.execution.BaseLogger;
import java.io.PrintStream;
import java.util.Collection;
import org.apache.commons.cli.CommandLine;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;

public class QueueTool
extends BaseTool
implements CLIToolLogger {
    public static final Logger log4j = Logger.getLogger(QueueTool.class);
    public static final String ACTION_LIST = "list";
    public static final String ACTION_KILL = "kill";
    public static final String ACTION_FOLLOW = "follow";
    private Actions action = Actions.list;
    private String execid;
    private boolean argVerbose;
    private boolean argQuiet;
    private boolean argProgress;
    private boolean argRestart;
    private CLIToolLogger clilogger;
    String argProject;
    private final Framework framework;
    SingleProjectResolver internalResolver;
    private LoglevelOptions loglevelOptions;
    private Options toolOptions;

    public Actions getAction() {
        return this.action;
    }

    public void setAction(Actions action) {
        this.action = action;
    }

    public String getExecid() {
        return this.execid;
    }

    public void setExecid(String execid) {
        this.execid = execid;
    }

    public boolean isArgVerbose() {
        return this.argVerbose;
    }

    public void setArgVerbose(boolean argVerbose) {
        this.argVerbose = argVerbose;
    }

    public static void main(String[] args) throws Exception {
        PropertyConfigurator.configure((String)Constants.getLog4jPropertiesFile().getAbsolutePath());
        QueueTool tool = new QueueTool(new DefaultCLIToolLogger());
        tool.setShouldExit(true);
        int exitCode = 1;
        try {
            tool.run(args);
            exitCode = 0;
        }
        catch (CLIToolOptionsException e) {
            exitCode = 2;
            tool.error(e.getMessage());
            tool.help();
        }
        catch (Throwable e) {
            if (e.getMessage() == null || tool.argVerbose) {
                e.printStackTrace();
            }
            tool.error("Error: " + e.getMessage());
        }
        tool.exit(exitCode);
    }

    public QueueTool() {
        this(Framework.getInstanceWithoutProjectsDir(Constants.getSystemBaseDir()), new Log4JCLIToolLogger(log4j));
    }

    @Override
    protected boolean isUseHelpOption() {
        return true;
    }

    @Override
    public String getHelpString() {
        return "rd-queue <action> : list the executions running in the queue or kill a running execution\nrd-queue [list] : list the executions running in the queue [default]\nrd-queue follow --eid <id> [--restart] : follow the output of an execution\nrd-queue kill --eid <id> : kill an execution running in the queue\n";
    }

    public QueueTool(CLIToolLogger logger) {
        this(Framework.getInstanceWithoutProjectsDir(Constants.getSystemBaseDir()), logger);
    }

    public QueueTool(Framework framework) {
        this(framework, null);
    }

    public QueueTool(Framework framework, CLIToolLogger logger) {
        this.framework = framework;
        this.internalResolver = new FrameworkSingleProjectResolver(framework);
        this.clilogger = logger;
        if (null == this.clilogger) {
            this.clilogger = new Log4JCLIToolLogger(log4j);
        }
        this.toolOptions = new Options();
        this.addToolOptions(this.toolOptions);
    }

    @Override
    public CommandLine parseArgs(String[] args) throws CLIToolOptionsException {
        CommandLine line = super.parseArgs(args);
        if (args.length > 0 && !args[0].startsWith("-")) {
            try {
                this.action = Actions.valueOf(args[0]);
            }
            catch (IllegalArgumentException e) {
                throw new CLIToolOptionsException("Invalid action: " + args[0]);
            }
        }
        return line;
    }

    @Override
    protected void go() throws QueueToolException, CLIToolOptionsException {
        switch (this.action) {
            case list: {
                this.listAction();
                break;
            }
            case kill: {
                this.killAction(this.execid);
                break;
            }
            case follow: {
                this.followAction(this.execid);
                break;
            }
            default: {
                throw new CLIToolOptionsException("Unrecognized action: " + (Object)((Object)this.action));
            }
        }
    }

    private void killAction(String execid) throws QueueToolException {
        DispatcherResult result;
        try {
            result = this.framework.getCentralDispatcherMgr().killDispatcherExecution(execid);
        }
        catch (CentralDispatcherException e) {
            String msg = "Failed request to kill the execution: " + e.getMessage();
            throw new QueueToolException(msg, e);
        }
        if (result.isSuccessful()) {
            this.log("rd-queue kill: success. [" + execid + "] " + result.getMessage());
        } else {
            this.error("rd-queue kill: failed. [" + execid + "] " + result.getMessage());
        }
    }

    private void listAction() throws QueueToolException {
        Collection<QueuedItem> result;
        try {
            result = this.framework.getCentralDispatcherMgr().listDispatcherQueue(this.argProject);
        }
        catch (CentralDispatcherException e) {
            String msg = "Failed request to list the queue: " + e.getMessage();
            throw new QueueToolException(msg, e);
        }
        if (null != result) {
            this.log("Queue: " + result.size() + " items");
            for (QueuedItem item : result) {
                String url = item.getUrl();
                this.log("[" + item.getId() + "] " + item.getName() + " <" + url + ">");
            }
        } else {
            throw new QueueToolException("List request returned null");
        }
    }

    private void followAction(String execid) throws QueueToolException {
        ConsoleExecutionFollowReceiver.Mode mode = ConsoleExecutionFollowReceiver.Mode.output;
        if (this.argQuiet) {
            mode = ConsoleExecutionFollowReceiver.Mode.quiet;
        } else if (this.argProgress) {
            mode = ConsoleExecutionFollowReceiver.Mode.progress;
        }
        try {
            QueueTool.followAction(execid, this.argRestart, mode, this.framework, System.out, this);
        }
        catch (CentralDispatcherException e) {
            String msg = "Failed request to follow the execution: " + e.getMessage();
            throw new QueueToolException(msg, e);
        }
    }

    public static boolean followAction(String execid, final boolean restart, ConsoleExecutionFollowReceiver.Mode mode, Framework framework, PrintStream out, BaseLogger logger) throws CentralDispatcherException {
        ExecutionDetail execution = framework.getCentralDispatcherMgr().getExecution(execid);
        long averageDuration = null != execution.getExecutionJob() ? execution.getExecutionJob().getAverageDuration() : -1L;
        ExecutionFollowRequest request = new ExecutionFollowRequest(){

            @Override
            public boolean isResume() {
                return !restart;
            }
        };
        ConsoleExecutionFollowReceiver receiver = new ConsoleExecutionFollowReceiver(averageDuration, mode, out, logger);
        ExecutionFollowResult result = framework.getCentralDispatcherMgr().followDispatcherExecution(execid, request, receiver);
        if (mode != ConsoleExecutionFollowReceiver.Mode.output) {
            out.println();
        }
        if (null != result.getState()) {
            String message = "[" + execid + "] execution status: " + (Object)((Object)result.getState());
            switch (result.getState()) {
                case failed: 
                case aborted: {
                    if (mode != ConsoleExecutionFollowReceiver.Mode.quiet) {
                        logger.warn(message);
                    }
                    return false;
                }
            }
            if (mode != ConsoleExecutionFollowReceiver.Mode.quiet) {
                logger.verbose(message);
            }
        }
        return true;
    }

    @Override
    public void log(String output) {
        if (null != this.clilogger) {
            this.clilogger.log(output);
        }
    }

    @Override
    public void error(String output) {
        if (null != this.clilogger) {
            this.clilogger.error(output);
        }
    }

    @Override
    public void warn(String output) {
        if (null != this.clilogger) {
            this.clilogger.warn(output);
        }
    }

    @Override
    public void verbose(String message) {
        if (null != this.clilogger && this.argVerbose) {
            this.clilogger.verbose(message);
        }
    }

    @Override
    public void debug(String message) {
        if (null != this.clilogger) {
            this.clilogger.debug(message);
        }
    }

    private class Options
    implements CLIToolOptions {
        public static final String RESTART_OPTION = "t";
        public static final String RESTART_OPTION_LONG = "restart";
        public static final String QUIET_OPTION = "q";
        public static final String QUIET_OPTION_LONG = "quiet";
        public static final String PROGRESS_OPTION = "r";
        public static final String PROGRESS_OPTION_LONG = "progress";
        public static final String EXECID_OPTION = "e";
        public static final String EXECID_OPTION_LONG = "eid";
        public static final String VERBOSE_OPTION = "v";
        public static final String VERBOSE_OPTION_LONG = "verbose";
        public static final String PROJECT_OPTION = "p";

        private Options() {
        }

        @Override
        public void addOptions(org.apache.commons.cli.Options options) {
            options.addOption(EXECID_OPTION, EXECID_OPTION_LONG, true, "Execution ID");
            options.addOption(VERBOSE_OPTION, VERBOSE_OPTION_LONG, false, "Enable verbose output");
            options.addOption(QUIET_OPTION, QUIET_OPTION_LONG, false, "Just wait until execution ends (follow only)");
            options.addOption(PROGRESS_OPTION, PROGRESS_OPTION_LONG, false, "Progress mark output (follow only)");
            options.addOption(PROJECT_OPTION, null, true, "Project name (list action only)");
            options.addOption(RESTART_OPTION, RESTART_OPTION_LONG, false, "Restart log output from beginning (follow action only)");
        }

        @Override
        public void parseArgs(CommandLine cli, String[] original) throws CLIToolOptionsException {
            if (cli.hasOption(EXECID_OPTION)) {
                QueueTool.this.execid = cli.getOptionValue(EXECID_OPTION);
            }
            if (cli.hasOption(VERBOSE_OPTION)) {
                QueueTool.this.argVerbose = true;
            }
            if (cli.hasOption(PROJECT_OPTION)) {
                QueueTool.this.argProject = cli.getOptionValue(PROJECT_OPTION);
            }
            if (cli.hasOption(RESTART_OPTION)) {
                QueueTool.this.argRestart = true;
            }
            if (cli.hasOption(QUIET_OPTION)) {
                QueueTool.this.argQuiet = true;
            }
            if (cli.hasOption(PROGRESS_OPTION)) {
                QueueTool.this.argProgress = true;
            }
        }

        @Override
        public void validate(CommandLine cli, String[] original) throws CLIToolOptionsException {
            if (Actions.list == QueueTool.this.action) {
                this.validateListAction();
            } else if (Actions.kill == QueueTool.this.action) {
                this.validateKillAction();
            } else if (Actions.follow == QueueTool.this.action) {
                this.validateFollowAction();
            }
        }

        private void validateListAction() throws CLIToolOptionsException {
            if (null != QueueTool.this.execid) {
                QueueTool.this.warn("-e/--eid argument only valid with kill/follow actions");
            }
            if (null == QueueTool.this.argProject) {
                if (QueueTool.this.internalResolver.hasSingleProject()) {
                    QueueTool.this.argProject = QueueTool.this.internalResolver.getSingleProjectName();
                    QueueTool.this.debug("# No project specified, defaulting to: " + QueueTool.this.argProject);
                } else {
                    throw new CLIToolOptionsException("-p argument is required with list action");
                }
            }
        }

        private void validateKillAction() throws CLIToolOptionsException {
            if (null == QueueTool.this.execid) {
                throw new CLIToolOptionsException("-e/--eid argument required");
            }
            if (null != QueueTool.this.argProject) {
                QueueTool.this.warn("-p argument only valid with list action");
            }
        }

        private void validateFollowAction() throws CLIToolOptionsException {
            if (null == QueueTool.this.execid) {
                throw new CLIToolOptionsException("-e/--eid argument required");
            }
            if (null != QueueTool.this.argProject) {
                QueueTool.this.warn("-p argument only valid with list action");
            }
        }

        public String getJobid() {
            return QueueTool.this.execid;
        }
    }

    public static enum Actions {
        list("list"),
        kill("kill"),
        follow("follow");

        private String name;

        private Actions(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

