/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.execution.workflow;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;

class ContextStack<T> {
    private List<T> stack;

    private ContextStack() {
        this.stack = new ArrayList<T>();
    }

    private ContextStack(List<T> stack) {
        this.stack = new ArrayList<T>(stack);
    }

    private ContextStack(T item) {
        this.stack = new ArrayList<T>(1);
        this.push(item);
    }

    public void push(T value) {
        if (null != value) {
            this.stack.add(value);
        }
    }

    public T pop() {
        if (this.stack.isEmpty()) {
            throw new IllegalStateException("stack is empty");
        }
        return this.stack.remove(this.stack.size() - 1);
    }

    public T peek() {
        if (this.stack.isEmpty()) {
            throw new IllegalStateException("stack is empty");
        }
        return this.stack.get(this.stack.size() - 1);
    }

    public ContextStack<T> copy() {
        return new ContextStack<List<T>>(this.stack);
    }

    public ContextStack<T> copyPush(T value) {
        ContextStack<T> stack1 = this.copy();
        stack1.push(value);
        return stack1;
    }

    public ContextStack<T> copyPop() {
        ContextStack<T> stack1 = this.copy();
        stack1.pop();
        return stack1;
    }

    public int size() {
        return this.stack.size();
    }

    public static <T> ContextStack<T> create(T value) {
        return new ContextStack<T>(value);
    }

    public List<T> stack() {
        return new ArrayList<T>(this.stack);
    }

    public String toString() {
        return StringUtils.join(this.stack, (String)":");
    }
}

