/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.execution.workflow;

import com.dtolabs.rundeck.core.NodesetEmptyException;
import com.dtolabs.rundeck.core.common.Framework;
import com.dtolabs.rundeck.core.common.INodeEntry;
import com.dtolabs.rundeck.core.common.NodesSelector;
import com.dtolabs.rundeck.core.execution.ExecutionContext;
import com.dtolabs.rundeck.core.execution.ExecutionContextImpl;
import com.dtolabs.rundeck.core.execution.HasSourceResult;
import com.dtolabs.rundeck.core.execution.StatusResult;
import com.dtolabs.rundeck.core.execution.StepExecutionItem;
import com.dtolabs.rundeck.core.execution.dispatch.Dispatchable;
import com.dtolabs.rundeck.core.execution.dispatch.DispatcherException;
import com.dtolabs.rundeck.core.execution.dispatch.DispatcherResult;
import com.dtolabs.rundeck.core.execution.dispatch.DispatcherResultImpl;
import com.dtolabs.rundeck.core.execution.service.ExecutionServiceException;
import com.dtolabs.rundeck.core.execution.workflow.BaseWorkflowStrategy;
import com.dtolabs.rundeck.core.execution.workflow.IWorkflow;
import com.dtolabs.rundeck.core.execution.workflow.StepExecutionContext;
import com.dtolabs.rundeck.core.execution.workflow.StepFirstWorkflowStrategy;
import com.dtolabs.rundeck.core.execution.workflow.WorkflowExecutionItem;
import com.dtolabs.rundeck.core.execution.workflow.WorkflowExecutionItemImpl;
import com.dtolabs.rundeck.core.execution.workflow.WorkflowExecutionResult;
import com.dtolabs.rundeck.core.execution.workflow.WorkflowExecutor;
import com.dtolabs.rundeck.core.execution.workflow.WorkflowImpl;
import com.dtolabs.rundeck.core.execution.workflow.steps.FailureReason;
import com.dtolabs.rundeck.core.execution.workflow.steps.NodeDispatchStepExecutor;
import com.dtolabs.rundeck.core.execution.workflow.steps.StepExecutionResult;
import com.dtolabs.rundeck.core.execution.workflow.steps.StepExecutor;
import com.dtolabs.rundeck.core.execution.workflow.steps.node.NodeStepResult;
import com.dtolabs.rundeck.core.execution.workflow.steps.node.NodeStepResultImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class NodeFirstWorkflowStrategy
extends BaseWorkflowStrategy {
    static final Logger logger = Logger.getLogger((String)NodeFirstWorkflowStrategy.class.getName());

    public NodeFirstWorkflowStrategy(Framework framework) {
        super(framework);
    }

    @Override
    public WorkflowExecutionResult executeWorkflowImpl(StepExecutionContext executionContext, WorkflowExecutionItem item) {
        Exception exception = null;
        IWorkflow workflow = item.getWorkflow();
        boolean wfsuccess = true;
        ArrayList<StepExecutionResult> results = new ArrayList<StepExecutionResult>();
        HashMap<String, Collection<StepExecutionResult>> failures = new HashMap<String, Collection<StepExecutionResult>>();
        HashMap<Integer, StepExecutionResult> stepFailures = new HashMap<Integer, StepExecutionResult>();
        try {
            NodesSelector nodeSelector = executionContext.getNodeSelector();
            if (workflow.getCommands().size() < 1) {
                executionContext.getExecutionListener().log(1, "Workflow has 0 items");
            }
            this.validateNodeSet(executionContext, nodeSelector);
            logger.debug((Object)"Begin loop");
            List<IWorkflow> sections = this.splitWorkflowDispatchedSections(workflow);
            int stepCount = 1;
            if (sections.size() > 1) {
                logger.debug((Object)("Split workflow into " + sections.size() + " sections"));
            }
            assert (sections.size() >= 1);
            if (sections.size() < 1) {
                throw new IllegalStateException();
            }
            for (IWorkflow flowsection : sections) {
                boolean sectionSuccess = true;
                StepExecutor stepExecutor = this.framework.getStepExecutionService().getExecutorForItem(flowsection.getCommands().get(0));
                sectionSuccess = stepExecutor.isNodeDispatchStep(flowsection.getCommands().get(0)) ? this.executeWFSectionNodeDispatch(executionContext, stepCount, results, failures, stepFailures, flowsection) : this.executeWFSection(executionContext, results, failures, stepFailures, stepCount, flowsection.getCommands(), flowsection.isKeepgoing());
                if (!sectionSuccess && !item.getWorkflow().isKeepgoing()) {
                    wfsuccess = false;
                    break;
                }
                if (!sectionSuccess) {
                    wfsuccess = false;
                }
                stepCount += flowsection.getCommands().size();
            }
        }
        catch (RuntimeException e) {
            exception = e;
            e.printStackTrace();
            executionContext.getExecutionListener().log(0, "Exception: " + e.getClass() + ": " + e.getMessage());
            wfsuccess = false;
        }
        catch (DispatcherException e) {
            exception = e;
            executionContext.getExecutionListener().log(0, "Exception: " + e.getClass() + ": " + e.getMessage());
            wfsuccess = false;
        }
        catch (ExecutionServiceException e) {
            exception = e;
            executionContext.getExecutionListener().log(0, "Exception: " + e.getClass() + ": " + e.getMessage());
            wfsuccess = false;
        }
        boolean success = wfsuccess;
        Exception fexception = exception;
        return new BaseWorkflowStrategy.BaseWorkflowExecutionResult(results, failures, stepFailures, success, fexception);
    }

    private boolean executeWFSectionNodeDispatch(StepExecutionContext executionContext, int stepCount, List<StepExecutionResult> results, Map<String, Collection<StepExecutionResult>> failures, Map<Integer, StepExecutionResult> stepFailures, IWorkflow flowsection) throws ExecutionServiceException, DispatcherException {
        logger.debug((Object)("Node dispatch for " + flowsection.getCommands().size() + " steps"));
        WorkflowExecutionItem innerLoopItem = NodeFirstWorkflowStrategy.createInnerLoopItem(flowsection);
        WorkflowExecutor executor = this.framework.getWorkflowExecutionService().getExecutorForItem(innerLoopItem);
        DispatchedWorkflow dispatchedWorkflow = new DispatchedWorkflow(executor, innerLoopItem, stepCount, executionContext.getStepContext());
        DispatcherResult dispatch = this.framework.getExecutionService().dispatchToNodes((StepExecutionContext)ExecutionContextImpl.builder(executionContext).stepNumber(stepCount).build(), dispatchedWorkflow);
        logger.debug((Object)("Node dispatch result: " + dispatch));
        this.extractWFDispatcherResult(dispatch, results, failures, stepFailures, flowsection.getCommands().size(), stepCount);
        return dispatch.isSuccess();
    }

    private void extractWFDispatcherResult(DispatcherResult dispatcherResult, List<StepExecutionResult> results, Map<String, Collection<StepExecutionResult>> failures, Map<Integer, StepExecutionResult> stepFailures, int index, int max) {
        DispatcherResultImpl r;
        ArrayList mergedStepResults = new ArrayList(max);
        ArrayList<Boolean> successes = new ArrayList<Boolean>(max);
        HashMap mergedStepFailures = new HashMap();
        for (String nodeName : dispatcherResult.getResults().keySet()) {
            Collection<StepExecutionResult> thisNodeFailures;
            NodeStepResult nodeStepResult = dispatcherResult.getResults().get(nodeName);
            WorkflowExecutionResult result = DispatchedWorkflow.extractWorkflowResult(nodeStepResult);
            if (null == failures.get(nodeName)) {
                failures.put(nodeName, new ArrayList());
            }
            if (null != (thisNodeFailures = result.getNodeFailures().get(nodeName)) && thisNodeFailures.size() > 0) {
                failures.get(nodeName).addAll(thisNodeFailures);
            }
            Map<Integer, NodeStepResult> perStepFailures = DispatchedWorkflow.extractStepFailures(result, nodeStepResult.getNode());
            for (Map.Entry<Integer, NodeStepResult> entry : perStepFailures.entrySet()) {
                Integer stepNum = entry.getKey();
                NodeStepResult value = entry.getValue();
                if (null == mergedStepFailures.get(stepNum)) {
                    mergedStepFailures.put(stepNum, new HashMap());
                }
                ((Map)mergedStepFailures.get(stepNum)).put(nodeName, value);
            }
            if (result.getResultSet().size() < 1 && result.getNodeFailures().size() < 1 && result.getStepFailures().size() < 1 && !result.isSuccess()) {
                if (null == mergedStepFailures.get(0)) {
                    mergedStepFailures.put(0, new HashMap());
                }
                ((Map)mergedStepFailures.get(0)).put(nodeName, nodeStepResult);
            }
            List<NodeStepResult> results1 = DispatchedWorkflow.extractNodeStepResults(result, nodeStepResult.getNode());
            int i = 0;
            for (NodeStepResult nodeStepResult2 : results1) {
                while (mergedStepResults.size() <= i) {
                    mergedStepResults.add(new HashMap());
                }
                while (successes.size() <= i) {
                    successes.add(Boolean.TRUE);
                }
                HashMap map = (HashMap)mergedStepResults.get(i);
                map.put(nodeName, nodeStepResult2);
                if (!nodeStepResult2.isSuccess()) {
                    successes.set(i, false);
                }
                ++i;
            }
        }
        int x = 0;
        for (HashMap hashMap : mergedStepResults) {
            Boolean success = (Boolean)successes.get(x);
            r = new DispatcherResultImpl(hashMap, null != success ? success : false);
            results.add(NodeDispatchStepExecutor.wrapDispatcherResult(r));
            ++x;
        }
        for (Integer n : mergedStepFailures.keySet()) {
            Map map = (Map)mergedStepFailures.get(n);
            r = new DispatcherResultImpl(map, false);
            stepFailures.put(n, NodeDispatchStepExecutor.wrapDispatcherResult(r));
        }
    }

    private boolean executeWFSection(StepExecutionContext executionContext, List<StepExecutionResult> results, Map<String, Collection<StepExecutionResult>> failures, Map<Integer, StepExecutionResult> stepFailures, int stepCount, List<StepExecutionItem> commands, boolean keepgoing) {
        boolean workflowsuccess = this.executeWorkflowItemsForNodeSet(executionContext, stepFailures, results, commands, keepgoing, stepCount);
        logger.debug((Object)("Aggregate results: " + workflowsuccess + " " + results + ", " + stepFailures));
        Map<String, Collection<StepExecutionResult>> localFailure = this.convertFailures(stepFailures);
        this.mergeFailure(failures, localFailure);
        return workflowsuccess;
    }

    private void mergeFailure(Map<String, Collection<StepExecutionResult>> destination, Map<String, Collection<StepExecutionResult>> source) {
        for (String s : source.keySet()) {
            if (null == destination.get(s)) {
                destination.put(s, new ArrayList());
            }
            destination.get(s).addAll(source.get(s));
        }
    }

    private void mergeResult(HashMap<String, List<StatusResult>> destination, HashMap<String, List<StatusResult>> source) {
        for (String s : source.keySet()) {
            if (null == destination.get(s)) {
                destination.put(s, new ArrayList());
            }
            destination.get(s).addAll((Collection<StatusResult>)source.get(s));
        }
    }

    private void validateNodeSet(ExecutionContext executionContext, NodesSelector nodeSelector) {
        if (0 == executionContext.getNodes().getNodes().size()) {
            throw new NodesetEmptyException(nodeSelector);
        }
    }

    private List<IWorkflow> splitWorkflowDispatchedSections(IWorkflow workflow) throws ExecutionServiceException {
        ArrayList<StepExecutionItem> dispatchItems = new ArrayList<StepExecutionItem>();
        ArrayList<IWorkflow> sections = new ArrayList<IWorkflow>();
        for (StepExecutionItem item : workflow.getCommands()) {
            StepExecutor executor = this.framework.getStepExecutionService().getExecutorForItem(item);
            if (executor.isNodeDispatchStep(item)) {
                dispatchItems.add(item);
                continue;
            }
            if (dispatchItems.size() > 0) {
                sections.add(new WorkflowImpl(dispatchItems, workflow.getThreadcount(), workflow.isKeepgoing(), workflow.getStrategy()));
                dispatchItems = new ArrayList();
            }
            sections.add(new WorkflowImpl(Collections.singletonList(item), workflow.getThreadcount(), workflow.isKeepgoing(), workflow.getStrategy()));
        }
        if (null != dispatchItems && dispatchItems.size() > 0) {
            sections.add(new WorkflowImpl(dispatchItems, workflow.getThreadcount(), workflow.isKeepgoing(), workflow.getStrategy()));
        }
        return sections;
    }

    public static WorkflowExecutionItem createInnerLoopItem(WorkflowExecutionItem item) {
        return NodeFirstWorkflowStrategy.createInnerLoopItem(item.getWorkflow());
    }

    public static WorkflowExecutionItem createInnerLoopItem(IWorkflow item) {
        WorkflowExecutionItemImpl workflowExecutionItem = new WorkflowExecutionItemImpl(new StepFirstWorkflowStrategy.stepFirstWrapper(item));
        return workflowExecutionItem;
    }

    static class DispatchedWorkflow
    implements Dispatchable {
        WorkflowExecutor executor;
        WorkflowExecutionItem workflowItem;
        int beginStep;
        List<Integer> stack;

        DispatchedWorkflow(WorkflowExecutor executor, WorkflowExecutionItem workflowItem, int beginStep, List<Integer> stack) {
            this.executor = executor;
            this.workflowItem = workflowItem;
            this.beginStep = beginStep;
            this.stack = stack;
        }

        @Override
        public NodeStepResult dispatch(ExecutionContext context, INodeEntry node) {
            ExecutionContextImpl newcontext = new ExecutionContextImpl.Builder(context).singleNodeContext(node, true).stepNumber(this.beginStep).stepContext(this.stack).build();
            WorkflowExecutionResult result = this.executor.executeWorkflow(newcontext, this.workflowItem);
            NodeStepResultImpl result1 = result.isSuccess() ? new NodeStepResultImpl(node) : new NodeStepResultImpl(result.getException(), Reason.WorkflowSequenceFailures, null == result.getException() ? "Sequence failed" : "Exception: " + result.getException().getClass() + ": " + result.getException().getMessage(), node);
            result1.setSourceResult(result);
            return result1;
        }

        static WorkflowExecutionResult extractWorkflowResult(NodeStepResult dispatcherResult) {
            assert (dispatcherResult instanceof HasSourceResult);
            if (!(dispatcherResult instanceof HasSourceResult)) {
                throw new IllegalArgumentException("Cannot extract source result from dispatcher result");
            }
            HasSourceResult sourced = (HasSourceResult)((Object)dispatcherResult);
            StatusResult sourceResult = sourced.getSourceResult();
            assert (sourceResult instanceof WorkflowExecutionResult);
            if (!(sourceResult instanceof WorkflowExecutionResult)) {
                throw new IllegalArgumentException("Cannot extract workflow result from dispatcher result");
            }
            WorkflowExecutionResult wfresult = (WorkflowExecutionResult)sourceResult;
            return wfresult;
        }

        static List<NodeStepResult> extractNodeStepResults(NodeStepResult dispatcherResult, INodeEntry node) {
            return DispatchedWorkflow.extractNodeStepResults(DispatchedWorkflow.extractWorkflowResult(dispatcherResult), node);
        }

        static List<NodeStepResult> extractNodeStepResults(WorkflowExecutionResult result, INodeEntry node) {
            ArrayList<NodeStepResult> results = new ArrayList<NodeStepResult>();
            for (StepExecutionResult executionResult : result.getResultSet()) {
                DispatcherException exception;
                Map<String, NodeStepResult> resultMap;
                if (NodeDispatchStepExecutor.isWrappedDispatcherResult(executionResult)) {
                    DispatcherResult dispatcherResult = NodeDispatchStepExecutor.extractDispatcherResult(executionResult);
                    NodeStepResult stepResult = dispatcherResult.getResults().get(node.getNodename());
                    if (null == stepResult) continue;
                    results.add(stepResult);
                    continue;
                }
                if (!NodeDispatchStepExecutor.isWrappedDispatcherException(executionResult) || null == (resultMap = (exception = NodeDispatchStepExecutor.extractDispatcherException(executionResult)).getResultMap()) || null == resultMap.get(node.getNodename())) continue;
                NodeStepResult stepResult = resultMap.get(node.getNodename());
                results.add(stepResult);
            }
            return results;
        }

        static Map<Integer, NodeStepResult> extractStepFailures(NodeStepResult dispatcherResult, INodeEntry node) {
            return DispatchedWorkflow.extractStepFailures(DispatchedWorkflow.extractWorkflowResult(dispatcherResult), node);
        }

        static Map<Integer, NodeStepResult> extractStepFailures(WorkflowExecutionResult result, INodeEntry node) {
            HashMap<Integer, NodeStepResult> results = new HashMap<Integer, NodeStepResult>();
            for (Map.Entry<Integer, StepExecutionResult> entry : result.getStepFailures().entrySet()) {
                DispatcherException exception;
                Map<String, NodeStepResult> resultMap;
                int num = entry.getKey();
                StepExecutionResult executionResult = entry.getValue();
                if (NodeDispatchStepExecutor.isWrappedDispatcherResult(executionResult)) {
                    DispatcherResult dispatcherResult = NodeDispatchStepExecutor.extractDispatcherResult(executionResult);
                    NodeStepResult stepResult = dispatcherResult.getResults().get(node.getNodename());
                    if (null == stepResult) continue;
                    results.put(num, stepResult);
                    continue;
                }
                if (!NodeDispatchStepExecutor.isWrappedDispatcherException(executionResult) || null == (resultMap = (exception = NodeDispatchStepExecutor.extractDispatcherException(executionResult)).getResultMap()) || null == resultMap.get(node.getNodename())) continue;
                NodeStepResult stepResult = resultMap.get(node.getNodename());
                results.put(num, stepResult);
            }
            return results;
        }
    }

    static enum Reason implements FailureReason
    {
        WorkflowSequenceFailures;

    }
}

