/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.execution.workflow;

import com.dtolabs.rundeck.core.common.INodeEntry;
import com.dtolabs.rundeck.core.execution.ExecutionContext;
import com.dtolabs.rundeck.core.execution.ExecutionListener;
import com.dtolabs.rundeck.core.execution.StatusResult;
import com.dtolabs.rundeck.core.execution.StepExecutionItem;
import com.dtolabs.rundeck.core.execution.workflow.StepExecutionContext;
import com.dtolabs.rundeck.core.execution.workflow.WorkflowExecutionItem;
import com.dtolabs.rundeck.core.execution.workflow.WorkflowExecutionListener;
import com.dtolabs.rundeck.core.execution.workflow.WorkflowExecutionResult;
import com.dtolabs.rundeck.core.execution.workflow.state.ExecutionState;
import com.dtolabs.rundeck.core.execution.workflow.steps.StepExecutionResult;
import com.dtolabs.rundeck.core.execution.workflow.steps.StepExecutor;
import com.dtolabs.rundeck.core.execution.workflow.steps.node.NodeStepExecutionItem;
import com.dtolabs.rundeck.core.execution.workflow.steps.node.NodeStepResult;
import java.util.HashMap;
import java.util.Map;

public class WorkflowEventLoggerListener
implements WorkflowExecutionListener {
    private static final String STEP_START = "stepbegin";
    private static final String STEP_HANDLER = "handlerbegin";
    private static final String HANDLER_FINISH = "handlerend";
    private static final String STEP_FINISH = "stepend";
    private static final String NODE_START = "nodebegin";
    private static final String NODE_FINISH = "nodeend";
    ExecutionListener logger;

    public WorkflowEventLoggerListener(ExecutionListener logger) {
        this.logger = logger;
    }

    @Override
    public void beginWorkflowExecution(StepExecutionContext executionContext, WorkflowExecutionItem item) {
    }

    @Override
    public void finishWorkflowExecution(WorkflowExecutionResult result, StepExecutionContext executionContext, WorkflowExecutionItem item) {
    }

    @Override
    public void beginWorkflowItem(int step, StepExecutionItem item) {
        this.logger.event(STEP_START, null, null);
    }

    @Override
    public void beginWorkflowItemErrorHandler(int step, StepExecutionItem item) {
        this.logger.event(STEP_HANDLER, null, null);
    }

    private static Map resultMap(StepExecutionResult result) {
        if (result.isSuccess()) {
            return null;
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        if (null != result.getFailureData()) {
            hashMap.putAll(result.getFailureData());
        }
        hashMap.put("failureReason", result.getFailureReason().toString());
        hashMap.put("executionState", result.isSuccess() ? ExecutionState.SUCCEEDED.toString() : ExecutionState.FAILED.toString());
        return hashMap;
    }

    @Override
    public void finishWorkflowItem(int step, StepExecutionItem item, StepExecutionResult result) {
        this.logger.event(STEP_FINISH, null != result.getFailureMessage() ? result.getFailureMessage() : null, WorkflowEventLoggerListener.resultMap(result));
    }

    @Override
    public void finishWorkflowItemErrorHandler(int step, StepExecutionItem item, StepExecutionResult result) {
        this.logger.event(HANDLER_FINISH, null != result.getFailureMessage() ? result.getFailureMessage() : null, WorkflowEventLoggerListener.resultMap(result));
    }

    @Override
    public void beginStepExecution(StepExecutor executor, StepExecutionContext context, StepExecutionItem item) {
    }

    @Override
    public void finishStepExecution(StepExecutor executor, StatusResult result, StepExecutionContext context, StepExecutionItem item) {
    }

    @Override
    public void beginExecuteNodeStep(ExecutionContext context, NodeStepExecutionItem item, INodeEntry node) {
        this.logger.event(NODE_START, null, null);
    }

    @Override
    public void finishExecuteNodeStep(NodeStepResult result, ExecutionContext context, StepExecutionItem item, INodeEntry node) {
        this.logger.event(NODE_FINISH, null != result.getFailureMessage() ? result.getFailureMessage() : null, WorkflowEventLoggerListener.resultMap(result));
    }
}

