/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.plugins.configuration;

import com.dtolabs.rundeck.core.common.ProviderService;
import com.dtolabs.rundeck.core.execution.service.ExecutionServiceException;
import com.dtolabs.rundeck.core.plugins.ProviderIdent;
import com.dtolabs.rundeck.core.plugins.configuration.Describable;
import com.dtolabs.rundeck.core.plugins.configuration.Description;
import com.dtolabs.rundeck.core.plugins.configuration.PluginAdapterUtility;
import com.dtolabs.rundeck.plugins.util.DescriptionBuilder;
import java.util.ArrayList;
import java.util.List;

public class DescribableServiceUtil {
    public static <T> List<Description> listDescriptions(ProviderService<T> service) {
        return DescribableServiceUtil.listDescriptions(service, true);
    }

    public static <T> List<Description> listDescriptions(ProviderService<T> service, boolean includeFieldProperties) {
        ArrayList<Description> list = new ArrayList<Description>();
        for (ProviderIdent providerIdent : service.listProviders()) {
            try {
                T providerForType = service.providerOfType(providerIdent.getProviderName());
                if (providerForType instanceof Describable) {
                    Describable desc = (Describable)providerForType;
                    Description description = desc.getDescription();
                    if (null == description) continue;
                    list.add(description);
                    continue;
                }
                if (!PluginAdapterUtility.canBuildDescription(providerForType)) continue;
                list.add(PluginAdapterUtility.buildDescription(providerForType, DescriptionBuilder.builder(), includeFieldProperties));
            }
            catch (ExecutionServiceException e) {
                e.printStackTrace();
            }
        }
        return list;
    }

    public static <T> List<ProviderIdent> listDescribableProviders(ProviderService<T> service) {
        ArrayList<ProviderIdent> list = new ArrayList<ProviderIdent>();
        for (ProviderIdent providerIdent : service.listProviders()) {
            try {
                T providerForType = service.providerOfType(providerIdent.getProviderName());
                if (providerForType instanceof Describable) {
                    Describable desc = (Describable)providerForType;
                    Description description = desc.getDescription();
                    if (null == description) continue;
                    list.add(providerIdent);
                    continue;
                }
                if (!PluginAdapterUtility.canBuildDescription(providerForType)) continue;
                list.add(providerIdent);
            }
            catch (ExecutionServiceException e) {
                e.printStackTrace();
            }
        }
        return list;
    }
}

