/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.cli.project;

import com.dtolabs.rundeck.core.Constants;
import com.dtolabs.rundeck.core.cli.Action;
import com.dtolabs.rundeck.core.cli.CLIToolLogger;
import com.dtolabs.rundeck.core.cli.project.InvalidArgumentsException;
import com.dtolabs.rundeck.core.cli.project.ProjectToolException;
import com.dtolabs.rundeck.core.common.Framework;
import com.dtolabs.rundeck.core.common.FrameworkProject;
import java.io.File;
import org.apache.commons.cli.CommandLine;

public class BaseAction
implements Action {
    final File FWK_PROP_FILE;
    protected final CLIToolLogger main;
    protected final Framework framework;
    private boolean verbose = false;
    protected String project;

    public BaseAction(CLIToolLogger main, Framework framework, CommandLine cli) {
        this(main, framework, BaseAction.parseBaseActionArgs(cli));
    }

    public BaseAction(CLIToolLogger main, Framework framework, BaseActionArgs args) {
        if (null == main) {
            throw new NullPointerException("main parameter was null");
        }
        if (null == args) {
            throw new NullPointerException("args parameter was null");
        }
        this.main = main;
        this.framework = framework;
        this.FWK_PROP_FILE = new File(Constants.getFrameworkConfigDir(framework.getBaseDir().getAbsolutePath()), "framework.properties");
        this.initArgs(args);
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    protected static BaseActionArgs parseBaseActionArgs(CommandLine cli) {
        String project = cli.getOptionValue('p');
        if (null != project && !project.matches("^[-_a-zA-Z0-9+][-\\._a-zA-Z0-9+]*$")) {
            throw new ProjectToolException("Error: CreateAction: project names can only contain these characters: ^[-_a-zA-Z0-9+][-\\._a-zA-Z0-9+]*$");
        }
        return BaseAction.createArgs(project, cli.hasOption('v'));
    }

    public static BaseActionArgs createArgs(final String project, final boolean verbose) {
        return new BaseActionArgs(){

            @Override
            public String getProject() {
                return project;
            }

            @Override
            public boolean isVerbose() {
                return verbose;
            }
        };
    }

    private void initArgs(BaseActionArgs args) {
        if (null != args.getProject()) {
            this.project = args.getProject();
        } else if (null == args.getProject() && this.framework.getFrameworkProjectMgr().listFrameworkProjects().size() == 1) {
            FrameworkProject d = (FrameworkProject)this.framework.getFrameworkProjectMgr().listFrameworkProjects().iterator().next();
            this.project = d.getName();
            this.main.log("defaulting to project: " + d.getName());
        } else {
            throw new InvalidArgumentsException("-p option not specified");
        }
        this.verbose = args.isVerbose();
    }

    protected void validateInstall() {
        File baseDir = this.framework.getBaseDir();
        if (null == baseDir || !baseDir.exists()) {
            throw new ProjectToolException("RDECK_BASE dir not found: " + (null == baseDir ? "(null)" : baseDir.getAbsolutePath()));
        }
        if (!this.FWK_PROP_FILE.exists()) {
            throw new ProjectToolException("framework configuration not found: " + this.FWK_PROP_FILE.getAbsolutePath());
        }
    }

    @Override
    public void exec() throws Throwable {
        this.validateInstall();
    }

    public static interface BaseActionArgs {
        public String getProject();

        public boolean isVerbose();
    }
}

