/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.common;

import com.dtolabs.rundeck.core.common.AdditiveListNodeSet;
import com.dtolabs.rundeck.core.common.Framework;
import com.dtolabs.rundeck.core.common.FrameworkResourceException;
import com.dtolabs.rundeck.core.common.FrameworkResourceParent;
import com.dtolabs.rundeck.core.common.IFrameworkProjectMgr;
import com.dtolabs.rundeck.core.common.IFrameworkResource;
import com.dtolabs.rundeck.core.common.INodeSet;
import com.dtolabs.rundeck.core.common.MergedAttributesNodeSet;
import com.dtolabs.rundeck.core.common.NodeFileParserException;
import com.dtolabs.rundeck.core.common.NodeSetMerge;
import com.dtolabs.rundeck.core.common.PropertyRetriever;
import com.dtolabs.rundeck.core.common.UpdateUtils;
import com.dtolabs.rundeck.core.common.impl.URLFileUpdater;
import com.dtolabs.rundeck.core.execution.service.ExecutionServiceException;
import com.dtolabs.rundeck.core.plugins.configuration.Describable;
import com.dtolabs.rundeck.core.plugins.configuration.Description;
import com.dtolabs.rundeck.core.resources.CachingResourceModelSource;
import com.dtolabs.rundeck.core.resources.FileResourceModelSource;
import com.dtolabs.rundeck.core.resources.FileResourceModelSourceCache;
import com.dtolabs.rundeck.core.resources.LoggingResourceModelSourceCache;
import com.dtolabs.rundeck.core.resources.ResourceModelSource;
import com.dtolabs.rundeck.core.resources.ResourceModelSourceException;
import com.dtolabs.rundeck.core.resources.ResourceModelSourceFactory;
import com.dtolabs.rundeck.core.resources.ResourceModelSourceService;
import com.dtolabs.rundeck.core.resources.URLResourceModelSource;
import com.dtolabs.rundeck.core.resources.format.ResourceFormatGenerator;
import com.dtolabs.rundeck.core.resources.format.ResourceFormatGeneratorException;
import com.dtolabs.rundeck.core.resources.format.ResourceFormatGeneratorService;
import com.dtolabs.rundeck.core.resources.format.UnsupportedFormatException;
import com.dtolabs.rundeck.core.utils.PropertyLookup;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FrameworkProject
extends FrameworkResourceParent {
    public static final String PROP_FILENAME = "project.properties";
    public static final String ETC_DIR_NAME = "etc";
    public static final String NODES_XML = "resources.xml";
    public static final String PROJECT_RESOURCES_URL_PROPERTY = "project.resources.url";
    public static final String PROJECT_RESOURCES_FILE_PROPERTY = "project.resources.file";
    public static final String PROJECT_RESOURCES_FILEFORMAT_PROPERTY = "project.resources.file.format";
    public static final String PROJECT_RESOURCES_ALLOWED_URL_PREFIX = "project.resources.allowedURL.";
    public static final String FRAMEWORK_RESOURCES_ALLOWED_URL_PREFIX = "framework.resources.allowedURL.";
    public static final String RESOURCES_SOURCE_PROP_PREFIX = "resources.source";
    public static final String PROJECT_RESOURCES_MERGE_NODE_ATTRIBUTES = "project.resources.mergeNodeAttributes";
    private final File resourcesBaseDir;
    private final File etcDir;
    private final IFrameworkProjectMgr projectResourceMgr;
    private final File propertyFile;
    private PropertyLookup lookup;
    private List<ResourceModelSource> nodesSourceList;
    private long propertiesLastReload = 0L;
    private ArrayList<Exception> nodesSourceExceptions;
    private long nodesSourcesLastReload = 0L;
    static Set<String> uncachedResourceTypes = new HashSet<String>();

    public FrameworkProject(String name, File basedir, IFrameworkProjectMgr resourceMgr) {
        this(name, basedir, resourceMgr, null);
    }

    public FrameworkProject(String name, File basedir, IFrameworkProjectMgr resourceMgr, Properties properties) {
        super(name, basedir, resourceMgr);
        this.projectResourceMgr = resourceMgr;
        this.resourcesBaseDir = new File(this.getBaseDir(), "resources");
        this.etcDir = FrameworkProject.getProjectEtcDir(this.getBaseDir());
        if (!this.etcDir.exists() && !this.etcDir.mkdirs()) {
            throw new FrameworkResourceException("error while creating project structure. failed creating directory: " + this.etcDir.getAbsolutePath(), this);
        }
        this.propertyFile = FrameworkProject.getProjectPropertyFile(this.getBaseDir());
        if (!this.propertyFile.exists()) {
            this.generateProjectPropertiesFile(false, properties);
        }
        this.loadProperties();
        this.nodesSourceList = new ArrayList<ResourceModelSource>();
        this.initialize();
    }

    private static File getProjectEtcDir(File baseDir) {
        return new File(baseDir, ETC_DIR_NAME);
    }

    private static File getProjectPropertyFile(File baseDir) {
        return new File(FrameworkProject.getProjectEtcDir(baseDir), PROP_FILENAME);
    }

    private synchronized void checkReloadProperties() {
        if (this.needsPropertiesReload()) {
            this.loadProperties();
        }
    }

    private boolean needsPropertiesReload() {
        File fwkProjectPropertyFile = new File(this.projectResourceMgr.getFramework().getConfigDir(), PROP_FILENAME);
        long fwkPropsLastModified = fwkProjectPropertyFile.lastModified();
        if (this.propertyFile.exists()) {
            return this.propertyFile.lastModified() > this.propertiesLastReload || fwkPropsLastModified > this.propertiesLastReload;
        }
        return fwkPropsLastModified > this.propertiesLastReload;
    }

    private synchronized void loadProperties() {
        File fwkProjectPropertyFile = new File(this.projectResourceMgr.getFramework().getConfigDir(), PROP_FILENAME);
        this.lookup = FrameworkProject.createProjectPropertyLookup(this.projectResourceMgr.getFramework().getBaseDir(), this.projectResourceMgr.getFramework().getFrameworkProjectsBaseDir(), this.getName());
        if (this.propertyFile.exists()) {
            this.getLogger().debug((Object)("loading existing project.properties: " + this.propertyFile.getAbsolutePath()));
            long fwkPropsLastModified = fwkProjectPropertyFile.lastModified();
            long propsLastMod = this.propertyFile.lastModified();
            this.propertiesLastReload = propsLastMod > fwkPropsLastModified ? propsLastMod : fwkPropsLastModified;
        } else {
            this.getLogger().debug((Object)("loading instance-level project.properties: " + this.propertyFile.getAbsolutePath()));
            this.propertiesLastReload = fwkProjectPropertyFile.lastModified();
        }
    }

    private static PropertyLookup createProjectPropertyLookup(File baseDir, File projectsBaseDir, String projectName) {
        Properties ownProps = new Properties();
        ownProps.setProperty("project.name", projectName);
        File fwkProjectPropertyFile = Framework.getPropertyFile(Framework.getConfigDir(baseDir));
        Properties nodeWideDepotProps = PropertyLookup.fetchProperties(fwkProjectPropertyFile);
        nodeWideDepotProps.putAll((Map<?, ?>)ownProps);
        File propertyFile = FrameworkProject.getProjectPropertyFile(new File(projectsBaseDir, projectName));
        PropertyLookup lookup = propertyFile.exists() ? PropertyLookup.create(propertyFile, nodeWideDepotProps, Framework.createPropertyLookupFromBasedir(baseDir)) : PropertyLookup.create(fwkProjectPropertyFile, ownProps, Framework.createPropertyLookupFromBasedir(baseDir));
        lookup.expand();
        return lookup;
    }

    public static PropertyRetriever createProjectPropertyRetriever(File baseDir, File projectsBaseDir, String projectName) {
        return FrameworkProject.createProjectPropertyLookup(baseDir, projectsBaseDir, projectName).safe();
    }

    private void loadResourceModelSources() {
        Properties config;
        this.nodesSourceExceptions = new ArrayList();
        if (this.hasProperty(PROJECT_RESOURCES_FILE_PROPERTY)) {
            try {
                config = this.createFileSourceConfiguration();
                this.logger.info((Object)("Source (project.resources.file): loading with properties: " + config));
                this.nodesSourceList.add(this.loadResourceModelSource("file", config, this.shouldCacheForType("file"), "file.file"));
            }
            catch (ExecutionServiceException e) {
                this.logger.error((Object)("Failed to load file resource model source: " + e.getMessage()), (Throwable)e);
                this.nodesSourceExceptions.add(e);
            }
        }
        if (this.hasProperty(PROJECT_RESOURCES_URL_PROPERTY)) {
            try {
                config = this.createURLSourceConfiguration();
                this.logger.info((Object)("Source (project.resources.url): loading with properties: " + config));
                this.nodesSourceList.add(this.loadResourceModelSource("url", config, this.shouldCacheForType("url"), "file.url"));
            }
            catch (ExecutionServiceException e) {
                this.logger.error((Object)("Failed to load file resource model source: " + e.getMessage()), (Throwable)e);
                this.nodesSourceExceptions.add(e);
            }
        }
        List<Map> list = this.listResourceModelConfigurations();
        int i = 1;
        for (Map map : list) {
            String providerType = (String)map.get("type");
            Properties props = (Properties)map.get("props");
            this.logger.info((Object)("Source #" + i + " (" + providerType + "): loading with properties: " + props));
            try {
                this.nodesSourceList.add(this.loadResourceModelSource(providerType, props, this.shouldCacheForType(providerType), i + "." + providerType));
            }
            catch (ExecutionServiceException e) {
                this.logger.error((Object)("Failed loading resource model source #" + i + ", skipping: " + e.getMessage()), (Throwable)e);
                this.nodesSourceExceptions.add(e);
            }
            ++i;
        }
        this.nodesSourcesLastReload = this.getPropertyFile().lastModified();
    }

    private boolean shouldCacheForType(String type) {
        return !uncachedResourceTypes.contains(type);
    }

    public synchronized List<Map> listResourceModelConfigurations() {
        ArrayList<Map> list = new ArrayList<Map>();
        int i = 1;
        boolean done = false;
        while (!done) {
            String prefix = "resources.source." + i;
            if (this.hasProperty(prefix + ".type")) {
                String providerType = this.getProperty(prefix + ".type");
                Properties props = new Properties();
                props.setProperty("project", this.getName());
                int len = (prefix + ".config.").length();
                for (Object o : this.lookup.getPropertiesMap().keySet()) {
                    String key = (String)o;
                    if (!key.startsWith(prefix + ".config.")) continue;
                    props.setProperty(key.substring(len), this.getProperty(key));
                }
                this.logger.info((Object)("Source #" + i + " (" + providerType + "): loading with properties: " + props));
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("type", providerType);
                map.put("props", props);
                list.add(map);
            } else {
                done = true;
            }
            ++i;
        }
        return list;
    }

    private Properties createURLSourceConfiguration() {
        URLResourceModelSource.Configuration build = URLResourceModelSource.Configuration.build();
        build.url(this.getProperty(PROJECT_RESOURCES_URL_PROPERTY));
        build.project(this.getName());
        return build.getProperties();
    }

    private synchronized Collection<ResourceModelSource> getResourceModelSources() {
        long lastMod = this.getPropertyFile().lastModified();
        if (lastMod > this.nodesSourcesLastReload) {
            this.nodesSourceList = new ArrayList<ResourceModelSource>();
            this.loadResourceModelSources();
        }
        return this.nodesSourceList;
    }

    private ResourceModelSource loadResourceModelSource(String type, Properties configuration, boolean useCache, String ident) throws ExecutionServiceException {
        ResourceModelSourceService nodesSourceService = this.getFrameworkProjectMgr().getFramework().getResourceModelSourceService();
        ResourceModelSource sourceForConfiguration = nodesSourceService.getSourceForConfiguration(type, configuration);
        if (useCache) {
            ResourceModelSourceFactory provider = (ResourceModelSourceFactory)nodesSourceService.providerOfType(type);
            String name = ident;
            if (provider instanceof Describable) {
                Describable desc = (Describable)((Object)provider);
                Description description = desc.getDescription();
                name = ident + " (" + description.getTitle() + ")";
            }
            return this.createCachingSource(sourceForConfiguration, ident, name);
        }
        return sourceForConfiguration;
    }

    private ResourceModelSource createCachingSource(ResourceModelSource sourceForConfiguration, String ident, String descr) {
        File file = this.getResourceModelSourceFileCacheForType(ident);
        Framework framework = this.getFrameworkProjectMgr().getFramework();
        ResourceModelSourceService nodesSourceService = framework.getResourceModelSourceService();
        ResourceFormatGeneratorService resourceFormatGeneratorService = framework.getResourceFormatGeneratorService();
        Properties fileSourceConfig = this.generateFileSourceConfigurationProperties(file.getAbsolutePath(), "resourcexml", true, false);
        try {
            ResourceModelSource fileSource = nodesSourceService.getSourceForConfiguration("file", fileSourceConfig);
            ResourceFormatGenerator generatorForFormat = resourceFormatGeneratorService.getGeneratorForFormat("resourcexml");
            String ident1 = "[ResourceModelSource: " + descr + ", project: " + this.getName() + "]";
            return new CachingResourceModelSource(sourceForConfiguration, ident1, new LoggingResourceModelSourceCache(new FileResourceModelSourceCache(file, generatorForFormat, fileSource), ident1));
        }
        catch (UnsupportedFormatException e) {
            e.printStackTrace();
        }
        catch (ExecutionServiceException e) {
            e.printStackTrace();
        }
        return null;
    }

    private File getResourceModelSourceFileCacheForType(String ident) {
        String varDir = this.getProperty("framework.var.dir");
        File file = new File(varDir, "resourceModelSourceCache/" + this.getName() + "/" + ident + ".xml");
        if (!file.getParentFile().exists() && !file.getParentFile().mkdirs()) {
            this.logger.warn((Object)"Failed to create cache dirs for source file cache");
        }
        return file;
    }

    private Properties createFileSourceConfiguration() {
        String format = null;
        if (this.hasProperty(PROJECT_RESOURCES_FILEFORMAT_PROPERTY)) {
            format = this.getProperty(PROJECT_RESOURCES_FILEFORMAT_PROPERTY);
        }
        return this.generateFileSourceConfigurationProperties(this.getProperty(PROJECT_RESOURCES_FILE_PROPERTY), format, true, true);
    }

    private Properties generateFileSourceConfigurationProperties(String filepath, String format, boolean generate, boolean includeServerNode) {
        FileResourceModelSource.Configuration build = FileResourceModelSource.Configuration.build();
        build.file(filepath);
        if (null != format) {
            build.format(format);
        }
        build.project(this.getName());
        build.generateFileAutomatically(generate);
        build.includeServerNode(includeServerNode);
        return build.getProperties();
    }

    public static FrameworkProject create(String name, File projectsDir, IFrameworkProjectMgr resourceMgr) {
        return new FrameworkProject(name, new File(projectsDir, name), resourceMgr);
    }

    public static FrameworkProject create(String name, File projectsDir, IFrameworkProjectMgr resourceMgr, Properties properties) {
        return new FrameworkProject(name, new File(projectsDir, name), resourceMgr, properties);
    }

    @Override
    public IFrameworkResource loadChild(String name) {
        throw new FrameworkResourceParent.NoSuchResourceException("project named " + name + " doesn't exist", this);
    }

    @Override
    public boolean childCouldBeLoaded(String name) {
        File file = new File(this.resourcesBaseDir, name);
        return file.exists() && file.isDirectory();
    }

    @Override
    public Collection listChildNames() {
        String[] list;
        HashSet<String> childnames = new HashSet<String>();
        if (this.resourcesBaseDir.isDirectory() && null != (list = this.resourcesBaseDir.list())) {
            for (int i = 0; i < list.length; ++i) {
                File dir = new File(this.resourcesBaseDir, list[i]);
                if (!dir.isDirectory()) continue;
                childnames.add(dir.getName());
            }
        }
        return childnames;
    }

    @Override
    public IFrameworkResource createChild(String resourceType) {
        throw new UnsupportedOperationException("createChild");
    }

    public File getPropertyFile() {
        return this.propertyFile;
    }

    public IFrameworkProjectMgr getFrameworkProjectMgr() {
        return this.projectResourceMgr;
    }

    public static boolean exists(String project, IFrameworkProjectMgr projectResourceMgr) {
        return projectResourceMgr.existsFrameworkProject(project);
    }

    public boolean existsFrameworkType(String name) {
        return this.existsChild(name);
    }

    public File getEtcDir() {
        return this.etcDir;
    }

    public String getNodesResourceFilePath() {
        if (this.hasProperty(PROJECT_RESOURCES_FILE_PROPERTY)) {
            return new File(this.getProperty(PROJECT_RESOURCES_FILE_PROPERTY)).getAbsolutePath();
        }
        Framework framework = this.projectResourceMgr.getFramework();
        if (framework.hasProperty("framework.nodes.file.name")) {
            return new File(this.getEtcDir(), framework.getProperty("framework.nodes.file.name")).getAbsolutePath();
        }
        return new File(this.getEtcDir(), NODES_XML).getAbsolutePath();
    }

    public INodeSet getNodeSet() throws NodeFileParserException {
        NodeSetMerge list = this.getNodeSetMerge();
        this.nodesSourceExceptions = new ArrayList();
        for (ResourceModelSource nodesSource : this.getResourceModelSources()) {
            try {
                INodeSet nodes = nodesSource.getNodes();
                if (null == nodes) {
                    this.logger.warn((Object)("Empty nodes result from [" + nodesSource.toString() + "]"));
                    continue;
                }
                list.addNodeSet(nodes);
            }
            catch (ResourceModelSourceException e) {
                this.logger.error((Object)("Cannot get nodes from [" + nodesSource.toString() + "]: " + e.getMessage()), (Throwable)e);
                this.nodesSourceExceptions.add(new ResourceModelSourceException("Cannot get nodes from [" + nodesSource.toString() + "]: " + e.getMessage(), e));
            }
            catch (RuntimeException e) {
                this.logger.error((Object)("Cannot get nodes from [" + nodesSource.toString() + "]: " + e.getMessage()), (Throwable)e);
                this.nodesSourceExceptions.add(new ResourceModelSourceException("Cannot get nodes from [" + nodesSource.toString() + "]: " + e.getMessage(), e));
            }
            catch (Throwable e) {
                this.logger.error((Object)("Cannot get nodes from [" + nodesSource.toString() + "]: " + e.getMessage()), e);
                this.nodesSourceExceptions.add(new ResourceModelSourceException("Cannot get nodes from [" + nodesSource.toString() + "]: " + e.getMessage()));
            }
        }
        return list;
    }

    private NodeSetMerge getNodeSetMerge() {
        if (this.hasProperty(PROJECT_RESOURCES_MERGE_NODE_ATTRIBUTES) && "false".equals(this.getProperty(PROJECT_RESOURCES_MERGE_NODE_ATTRIBUTES))) {
            return new AdditiveListNodeSet();
        }
        return new MergedAttributesNodeSet();
    }

    public boolean updateNodesResourceFile() throws UpdateUtils.UpdateException {
        if (this.shouldUpdateNodesResourceFile()) {
            this.updateNodesResourceFileFromUrl(this.getProperty(PROJECT_RESOURCES_URL_PROPERTY), null, null);
            return true;
        }
        return false;
    }

    public void updateNodesResourceFileFromUrl(String providerURL, String username, String password) throws UpdateUtils.UpdateException {
        if (!this.validateResourceProviderURL(providerURL)) {
            throw new UpdateUtils.UpdateException("providerURL is not allowed: " + providerURL);
        }
        UpdateUtils.updateFileFromUrl(providerURL, this.getNodesResourceFilePath(), username, password, URLFileUpdater.factory());
        this.logger.debug((Object)("Updated nodes resources file: " + this.getNodesResourceFilePath()));
    }

    boolean validateResourceProviderURL(String providerURL) throws UpdateUtils.UpdateException {
        URL url;
        try {
            url = new URL(providerURL);
        }
        catch (MalformedURLException e) {
            throw new UpdateUtils.UpdateException("Invalid URL: " + providerURL, e);
        }
        if (!("file".equals(url.getProtocol()) || "http".equals(url.getProtocol()) || "https".equals(url.getProtocol()))) {
            throw new UpdateUtils.UpdateException("URL protocol not allowed: " + url.getProtocol());
        }
        return this.isAllowedProviderURL(providerURL);
    }

    boolean isAllowedProviderURL(String providerURL) {
        this.checkReloadProperties();
        if (this.hasProperty(PROJECT_RESOURCES_URL_PROPERTY) && this.getProperty(PROJECT_RESOURCES_URL_PROPERTY).equals(providerURL)) {
            return true;
        }
        int i = 0;
        boolean projpass = false;
        boolean setproj = false;
        while (this.hasProperty(PROJECT_RESOURCES_ALLOWED_URL_PREFIX + i)) {
            setproj = true;
            String regex = this.getProperty(PROJECT_RESOURCES_ALLOWED_URL_PREFIX + i);
            Pattern pat = Pattern.compile(regex, 2);
            Matcher matcher = pat.matcher(providerURL);
            if (matcher.matches()) {
                this.logger.debug((Object)("ProviderURL allowed by project property \"project.resources.allowedURL." + i + "\": " + regex));
                projpass = true;
                break;
            }
            ++i;
        }
        if (!projpass && setproj) {
            return false;
        }
        assert (projpass ^ !setproj);
        i = 0;
        Framework framework = this.getFrameworkProjectMgr().getFramework();
        boolean setframework = framework.hasProperty(FRAMEWORK_RESOURCES_ALLOWED_URL_PREFIX + i);
        if (!setframework && projpass) {
            return true;
        }
        if (!setframework && !setproj) {
            return false;
        }
        while (framework.hasProperty(FRAMEWORK_RESOURCES_ALLOWED_URL_PREFIX + i)) {
            String regex = framework.getProperty(FRAMEWORK_RESOURCES_ALLOWED_URL_PREFIX + i);
            Pattern pat = Pattern.compile(regex, 2);
            Matcher matcher = pat.matcher(providerURL);
            if (matcher.matches()) {
                this.logger.debug((Object)("ProviderURL allowed by framework property \"framework.resources.allowedURL." + i + "\": " + regex));
                return true;
            }
            ++i;
        }
        if (projpass) {
            this.logger.warn((Object)("providerURL was allowed by project.properties, but is not allowed by framework.properties: " + providerURL));
        }
        return false;
    }

    public void updateNodesResourceFile(File source) throws UpdateUtils.UpdateException {
        UpdateUtils.updateFileFromFile(source, this.getNodesResourceFilePath());
        this.logger.debug((Object)("Updated nodes resources file: " + this.getNodesResourceFilePath()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateNodesResourceFile(INodeSet nodeset) throws UpdateUtils.UpdateException {
        ResourceFormatGenerator generator;
        String nodesResourceFilePath = this.getNodesResourceFilePath();
        File destfile = new File(this.getNodesResourceFilePath());
        try {
            generator = this.getFrameworkProjectMgr().getFramework().getResourceFormatGeneratorService().getGeneratorForFileExtension(destfile);
        }
        catch (UnsupportedFormatException e) {
            throw new UpdateUtils.UpdateException("Unable to determine file format for file: " + nodesResourceFilePath, e);
        }
        File resfile = null;
        try {
            resfile = File.createTempFile("resource-temp", destfile.getName());
            resfile.deleteOnExit();
        }
        catch (IOException e) {
            throw new UpdateUtils.UpdateException("Unable to create temp file: " + e.getMessage(), e);
        }
        try {
            FileOutputStream stream = new FileOutputStream(resfile);
            try {
                generator.generateDocument(nodeset, stream);
            }
            finally {
                stream.close();
            }
        }
        catch (IOException e) {
            throw new UpdateUtils.UpdateException("Unable to generate resources file: " + e.getMessage(), e);
        }
        catch (ResourceFormatGeneratorException e) {
            throw new UpdateUtils.UpdateException("Unable to generate resources file: " + e.getMessage(), e);
        }
        this.updateNodesResourceFile(resfile);
        if (!resfile.delete()) {
            this.getLogger().warn((Object)("failed to remove temp file: " + resfile));
        }
        this.getLogger().debug((Object)("generated resources file: " + resfile.getAbsolutePath()));
    }

    private boolean shouldUpdateNodesResourceFile() {
        return this.hasProperty(PROJECT_RESOURCES_URL_PROPERTY);
    }

    public synchronized String getProperty(String name) {
        this.checkReloadProperties();
        return this.lookup.getProperty(name);
    }

    public synchronized boolean hasProperty(String key) {
        this.checkReloadProperties();
        return this.lookup.hasProperty(key);
    }

    public Map getProperties() {
        return this.lookup.getPropertiesMap();
    }

    public synchronized PropertyRetriever getPropertyRetriever() {
        this.checkReloadProperties();
        return this.lookup.safe();
    }

    public static void createFileStructure(File projectDir) throws IOException {
        if (!projectDir.exists() && !projectDir.mkdirs()) {
            throw new IOException("failed creating project base dir: " + projectDir.getAbsolutePath());
        }
        File etcDir = new File(projectDir, ETC_DIR_NAME);
        if (!etcDir.exists() && !etcDir.mkdirs()) {
            throw new IOException("failed creating project etc dir: " + etcDir.getAbsolutePath());
        }
    }

    protected void generateProjectPropertiesFile(boolean overwrite) {
        this.generateProjectPropertiesFile(overwrite, null);
    }

    protected void generateProjectPropertiesFile(boolean overwrite, Properties properties) {
        this.generateProjectPropertiesFile(overwrite, properties, false, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void generateProjectPropertiesFile(boolean overwrite, Properties properties, boolean merge, Set<String> removePrefixes) {
        File destfile = this.getPropertyFile();
        if (destfile.exists() && !overwrite) {
            return;
        }
        Properties newProps = new Properties();
        newProps.setProperty("project.name", this.getName());
        if (null == properties || !properties.containsKey("resources.source.1.type")) {
            newProps.setProperty("resources.source.1.type", "file");
            newProps.setProperty("resources.source.1.config.file", new File(this.getEtcDir(), NODES_XML).getAbsolutePath());
            newProps.setProperty("resources.source.1.config.includeServerNode", "true");
            newProps.setProperty("resources.source.1.config.generateFileAutomatically", "true");
        }
        if (null == properties || !properties.containsKey("service.NodeExecutor.default.provider")) {
            newProps.setProperty("service.NodeExecutor.default.provider", "jsch-ssh");
        }
        if (null == properties || !properties.containsKey("service.FileCopier.default.provider")) {
            newProps.setProperty("service.FileCopier.default.provider", "jsch-scp");
        }
        if (null == properties || !properties.containsKey("project.ssh-keypath")) {
            newProps.setProperty("project.ssh-keypath", new File(System.getProperty("user.home"), ".ssh/id_rsa").getAbsolutePath());
        }
        if (null == properties || !properties.containsKey("project.ssh-authentication")) {
            newProps.setProperty("project.ssh-authentication", "privateKey");
        }
        if (merge) {
            Properties orig = new Properties();
            if (destfile.exists()) {
                try {
                    FileInputStream fileInputStream = new FileInputStream(destfile);
                    try {
                        orig.load(fileInputStream);
                    }
                    finally {
                        fileInputStream.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            Iterator<Map.Entry<Object, Object>> i$ = orig.entrySet().iterator();
            block10: while (i$.hasNext()) {
                Map.Entry<Object, Object> o;
                Map.Entry<Object, Object> entry = o = i$.next();
                String key = (String)entry.getKey();
                for (String replacePrefix : removePrefixes) {
                    if (!key.startsWith(replacePrefix)) continue;
                    continue block10;
                }
                newProps.put(entry.getKey(), entry.getValue());
            }
        }
        if (null != properties) {
            newProps.putAll((Map<?, ?>)properties);
        }
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(destfile);
            try {
                newProps.store(fileOutputStream, "Project " + this.getName() + " configuration, generated");
            }
            finally {
                fileOutputStream.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.getLogger().debug((Object)("generated project.properties: " + destfile.getAbsolutePath()));
    }

    public void mergeProjectProperties(Properties properties, Set<String> removePrefixes) {
        this.generateProjectPropertiesFile(true, properties, true, removePrefixes);
    }

    public static boolean isInstalled(FrameworkProject d) {
        return d.getBaseDir().exists();
    }

    public ArrayList<Exception> getResourceModelSourceExceptions() {
        return this.nodesSourceExceptions;
    }

    static {
        uncachedResourceTypes.add("file");
        uncachedResourceTypes.add("directory");
    }
}

