/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.execution.impl.jsch;

import com.dtolabs.rundeck.core.cli.CLIUtils;
import com.dtolabs.rundeck.core.common.Framework;
import com.dtolabs.rundeck.core.common.FrameworkProject;
import com.dtolabs.rundeck.core.common.INodeEntry;
import com.dtolabs.rundeck.core.dispatcher.DataContextUtils;
import com.dtolabs.rundeck.core.execution.ExecutionContext;
import com.dtolabs.rundeck.core.execution.ExecutionListener;
import com.dtolabs.rundeck.core.execution.impl.common.AntSupport;
import com.dtolabs.rundeck.core.execution.service.NodeExecutor;
import com.dtolabs.rundeck.core.execution.service.NodeExecutorResult;
import com.dtolabs.rundeck.core.execution.service.NodeExecutorResultImpl;
import com.dtolabs.rundeck.core.execution.utils.LeadPipeOutputStream;
import com.dtolabs.rundeck.core.execution.utils.Responder;
import com.dtolabs.rundeck.core.execution.utils.ResponderTask;
import com.dtolabs.rundeck.core.execution.workflow.steps.FailureReason;
import com.dtolabs.rundeck.core.execution.workflow.steps.StepFailureReason;
import com.dtolabs.rundeck.core.execution.workflow.steps.node.NodeStepFailureReason;
import com.dtolabs.rundeck.core.plugins.configuration.Describable;
import com.dtolabs.rundeck.core.plugins.configuration.Description;
import com.dtolabs.rundeck.core.plugins.configuration.Property;
import com.dtolabs.rundeck.core.plugins.configuration.PropertyUtil;
import com.dtolabs.rundeck.core.tasks.net.ExtSSHExec;
import com.dtolabs.rundeck.core.tasks.net.SSHTaskBuilder;
import com.dtolabs.rundeck.plugins.util.DescriptionBuilder;
import com.jcraft.jsch.JSchException;
import java.io.IOException;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.net.NoRouteToHostException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.regex.Pattern;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.log4j.Logger;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;

public class JschNodeExecutor
implements NodeExecutor,
Describable {
    public static final Logger logger = Logger.getLogger((String)JschNodeExecutor.class.getName());
    public static final String SERVICE_PROVIDER_TYPE = "jsch-ssh";
    public static final String FWK_PROP_AUTH_CANCEL_MSG = "framework.messages.error.ssh.authcancel";
    public static final String FWK_PROP_AUTH_CANCEL_MSG_DEFAULT = "Authentication failure connecting to node: \"{0}\". Make sure your resource definitions and credentials are up to date.";
    public static final String FWK_PROP_AUTH_FAIL_MSG = "framework.messages.error.ssh.authfail";
    public static final String FWK_PROP_AUTH_FAIL_MSG_DEFAULT = "Authentication failure connecting to node: \"{0}\". Password incorrect.";
    public static final String NODE_ATTR_SSH_KEYPATH = "ssh-keypath";
    public static final String PROJ_PROP_PREFIX = "project.";
    public static final String FWK_PROP_PREFIX = "framework.";
    public static final String FWK_PROP_SSH_KEYPATH = "framework.ssh-keypath";
    public static final String PROJ_PROP_SSH_KEYPATH = "project.ssh-keypath";
    public static final String NODE_ATTR_SSH_AUTHENTICATION = "ssh-authentication";
    public static final String NODE_ATTR_SSH_PASSWORD_OPTION = "ssh-password-option";
    public static final String DEFAULT_SSH_PASSWORD_OPTION = "option.sshPassword";
    public static final String SUDO_OPT_PREFIX = "sudo-";
    public static final String SUDO2_OPT_PREFIX = "sudo2-";
    public static final String NODE_ATTR_SUDO_PASSWORD_OPTION = "password-option";
    public static final String DEFAULT_SUDO_PASSWORD_OPTION = "option.sudoPassword";
    public static final String DEFAULT_SUDO2_PASSWORD_OPTION = "option.sudo2Password";
    public static final String NODE_ATTR_SSH_KEY_PASSPHRASE_OPTION = "ssh-key-passphrase-option";
    public static final String DEFAULT_SSH_KEY_PASSPHRASE_OPTION = "option.sshKeyPassphrase";
    public static final String FWK_PROP_SSH_AUTHENTICATION = "framework.ssh-authentication";
    public static final String PROJ_PROP_SSH_AUTHENTICATION = "project.ssh-authentication";
    public static final String NODE_ATTR_SUDO_COMMAND_ENABLED = "command-enabled";
    public static final String NODE_ATTR_SUDO_PROMPT_PATTERN = "prompt-pattern";
    public static final String DEFAULT_SUDO_PROMPT_PATTERN = "^\\[sudo\\] password for .+: .*";
    public static final String NODE_ATTR_SUDO_FAILURE_PATTERN = "failure-pattern";
    public static final String DEFAULT_SUDO_FAILURE_PATTERN = "^.*try again.*";
    public static final String NODE_ATTR_SUDO_COMMAND_PATTERN = "command-pattern";
    public static final String DEFAULT_SUDO_COMMAND_PATTERN = "^sudo$";
    public static final String DEFAULT_SUDO2_COMMAND_PATTERN = "^sudo .+? sudo .*$";
    public static final String NODE_ATTR_SUDO_PROMPT_MAX_LINES = "prompt-max-lines";
    public static final int DEFAULT_SUDO_PROMPT_MAX_LINES = 12;
    public static final String NODE_ATTR_SUDO_RESPONSE_MAX_LINES = "response-max-lines";
    public static final int DEFAULT_SUDO_RESPONSE_MAX_LINES = 2;
    public static final String NODE_ATTR_SUDO_PROMPT_MAX_TIMEOUT = "prompt-max-timeout";
    public static final long DEFAULT_SUDO_PROMPT_MAX_TIMEOUT = 5000L;
    public static final String NODE_ATTR_SUDO_RESPONSE_MAX_TIMEOUT = "response-max-timeout";
    public static final long DEFAULT_SUDO_RESPONSE_MAX_TIMEOUT = 5000L;
    public static final String NODE_ATTR_SUDO_FAIL_ON_PROMPT_MAX_LINES = "fail-on-prompt-max-lines";
    public static final boolean DEFAULT_SUDO_FAIL_ON_PROMPT_MAX_LINES = false;
    public static final String NODE_ATTR_SUDO_FAIL_ON_PROMPT_TIMEOUT = "fail-on-prompt-timeout";
    public static final boolean DEFAULT_SUDO_FAIL_ON_PROMPT_TIMEOUT = true;
    public static final String NODE_ATTR_SUDO_FAIL_ON_RESPONSE_TIMEOUT = "fail-on-response-timeout";
    public static final boolean DEFAULT_SUDO_FAIL_ON_RESPONSE_TIMEOUT = false;
    public static final String NODE_ATTR_SUDO_SUCCESS_ON_PROMPT_THRESHOLD = "success-on-prompt-threshold";
    public static final boolean DEFAULT_SUDO_SUCCESS_ON_PROMPT_THRESHOLD = true;
    public static final String PROJECT_SSH_USER = "project.ssh.user";
    private Framework framework;
    public static final String CONFIG_KEYPATH = "keypath";
    public static final String CONFIG_AUTHENTICATION = "authentication";
    static final List<Property> properties = new ArrayList<Property>();
    static final Description DESC;

    public JschNodeExecutor(Framework framework) {
        this.framework = framework;
    }

    @Override
    public Description getDescription() {
        return DESC;
    }

    @Override
    public NodeExecutorResult executeCommand(ExecutionContext context, String[] command, final INodeEntry node) {
        Future<ResponderTask.ResponderResult> responderFuture;
        ExtSSHExec sshexec;
        if (null == node.getHostname() || null == node.extractHostname()) {
            return NodeExecutorResultImpl.createFailure(StepFailureReason.ConfigurationFailure, "Hostname must be set to connect to remote node '" + node.getNodename() + "'", node);
        }
        ExecutionListener listener = context.getExecutionListener();
        Project project = new Project();
        AntSupport.addAntBuildListener(listener, project);
        boolean success = false;
        NodeSSHConnectionInfo nodeAuthentication = new NodeSSHConnectionInfo(node, this.framework, context);
        int timeout = nodeAuthentication.getSSHTimeout();
        try {
            sshexec = SSHTaskBuilder.build(node, command, project, context.getDataContext(), nodeAuthentication, context.getLoglevel(), listener);
        }
        catch (SSHTaskBuilder.BuilderException e) {
            return NodeExecutorResultImpl.createFailure(StepFailureReason.ConfigurationFailure, e.getMessage(), node);
        }
        final ExecutorService executor = Executors.newSingleThreadExecutor(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(null, r, "SudoResponder " + node.getNodename() + ": " + System.currentTimeMillis());
            }
        });
        SudoResponder sudoResponder = SudoResponder.create(node, this.framework, context);
        Runnable responderCleanup = null;
        if (sudoResponder.isSudoEnabled() && sudoResponder.matchesCommandPattern(command[0])) {
            Callable<ResponderTask.ResponderResult> responderResultCallable;
            DisconnectResultHandler resultHandler = new DisconnectResultHandler();
            final PipedInputStream responderInput = new PipedInputStream();
            final PipedOutputStream responderOutput = new PipedOutputStream();
            PipedInputStream jschInput = new PipedInputStream();
            LeadPipeOutputStream jschOutput = new LeadPipeOutputStream();
            try {
                responderInput.connect(jschOutput);
                jschInput.connect(responderOutput);
            }
            catch (IOException e) {
                return NodeExecutorResultImpl.createFailure(StepFailureReason.IOFailure, e.getMessage(), node);
            }
            ResponderTask responder = new ResponderTask(sudoResponder, responderInput, responderOutput, resultHandler);
            SudoResponder sudoResponder2 = SudoResponder.create(node, this.framework, context, SUDO2_OPT_PREFIX, DEFAULT_SUDO2_PASSWORD_OPTION, DEFAULT_SUDO2_COMMAND_PATTERN);
            if (sudoResponder2.isSudoEnabled() && sudoResponder2.matchesCommandPattern(CLIUtils.generateArgline(null, command, false))) {
                logger.debug((Object)"Enable second sudo responder");
                sudoResponder2.setDescription("Second Sudo execution password response");
                sudoResponder.setDescription("First Sudo execution password response");
                responderResultCallable = responder.createSequence(sudoResponder2);
            } else {
                responderResultCallable = responder;
            }
            sshexec.setAllocatePty(true);
            sshexec.setInputStream(jschInput);
            sshexec.setSecondaryStream(jschOutput);
            sshexec.setDisconnectHolder(resultHandler);
            responderFuture = executor.submit(responderResultCallable);
            responderCleanup = new Runnable(){

                @Override
                public void run() {
                    logger.debug((Object)"SudoResponder shutting down...");
                    try {
                        responderInput.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    try {
                        responderOutput.flush();
                        responderOutput.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    executor.shutdownNow();
                }
            };
            executor.submit(responderCleanup);
        } else {
            responderFuture = null;
        }
        if (null != context.getExecutionListener()) {
            context.getExecutionListener().log(3, "Starting SSH Connection: " + nodeAuthentication.getUsername() + "@" + node.getHostname() + " (" + node.getNodename() + ")");
        }
        String errormsg = null;
        FailureReason failureReason = null;
        try {
            sshexec.execute();
            success = true;
        }
        catch (BuildException e) {
            ExtractFailure extractJschFailure = JschNodeExecutor.extractFailure(e, node, timeout, this.framework);
            errormsg = extractJschFailure.getErrormsg();
            failureReason = extractJschFailure.getReason();
            context.getExecutionListener().log(0, errormsg);
        }
        if (null != responderCleanup) {
            responderCleanup.run();
        }
        this.shutdownAndAwaitTermination(executor);
        if (null != responderFuture) {
            try {
                logger.debug((Object)"Waiting 5 seconds for responder future result");
                ResponderTask.ResponderResult result = (ResponderTask.ResponderResult)responderFuture.get(5L, TimeUnit.SECONDS);
                logger.debug((Object)("Responder result: " + result));
                if (!result.isSuccess() && !result.isInterrupted()) {
                    context.getExecutionListener().log(0, result.getResponder().toString() + " failed: " + result.getFailureReason());
                }
            }
            catch (InterruptedException e) {
            }
            catch (ExecutionException e) {
                e.printStackTrace();
            }
            catch (TimeoutException e) {
                // empty catch block
            }
        }
        int resultCode = sshexec.getExitStatus();
        if (success) {
            return NodeExecutorResultImpl.createSuccess(node);
        }
        return NodeExecutorResultImpl.createFailure(failureReason, errormsg, node, resultCode);
    }

    static ExtractFailure extractFailure(BuildException e, INodeEntry node, int timeout, Framework framework) {
        Enum failureReason;
        String errormsg;
        if (e.getMessage().contains("Timeout period exceeded, connection dropped")) {
            errormsg = "Failed execution for node: " + node.getNodename() + ": Execution Timeout period exceeded (after " + timeout + "ms), connection dropped";
            failureReason = NodeStepFailureReason.ConnectionTimeout;
        } else {
            if (null != e.getCause() && e.getCause() instanceof JSchException) {
                JSchException jSchException = (JSchException)e.getCause();
                return JschNodeExecutor.extractJschFailure(node, timeout, jSchException, framework);
            }
            if (e.getMessage().contains("Remote command failed with exit status")) {
                errormsg = e.getMessage();
                failureReason = NodeStepFailureReason.NonZeroResultCode;
            } else {
                failureReason = StepFailureReason.Unknown;
                errormsg = e.getMessage();
            }
        }
        return new ExtractFailure(errormsg, (FailureReason)((Object)failureReason));
    }

    static ExtractFailure extractJschFailure(INodeEntry node, int timeout, JSchException jSchException, Framework framework) {
        Enum reason;
        String errormsg;
        if (null == jSchException.getCause()) {
            if (jSchException.getMessage().contains("Auth cancel")) {
                String msgformat = FWK_PROP_AUTH_CANCEL_MSG_DEFAULT;
                if (framework.getPropertyLookup().hasProperty(FWK_PROP_AUTH_CANCEL_MSG)) {
                    msgformat = framework.getProperty(FWK_PROP_AUTH_CANCEL_MSG);
                }
                errormsg = MessageFormat.format(msgformat, node.getNodename(), jSchException.getMessage());
                reason = NodeStepFailureReason.AuthenticationFailure;
            } else if (jSchException.getMessage().contains("Auth fail")) {
                String msgformat = FWK_PROP_AUTH_FAIL_MSG_DEFAULT;
                if (framework.getPropertyLookup().hasProperty(FWK_PROP_AUTH_FAIL_MSG)) {
                    msgformat = framework.getProperty(FWK_PROP_AUTH_FAIL_MSG);
                }
                errormsg = MessageFormat.format(msgformat, node.getNodename(), jSchException.getMessage());
                reason = NodeStepFailureReason.AuthenticationFailure;
            } else {
                reason = JschFailureReason.SSHProtocolFailure;
                errormsg = jSchException.getMessage();
            }
        } else {
            Throwable cause = ExceptionUtils.getRootCause((Throwable)jSchException);
            errormsg = cause.getMessage();
            if (cause instanceof NoRouteToHostException) {
                reason = NodeStepFailureReason.ConnectionFailure;
            } else if (cause instanceof UnknownHostException) {
                reason = NodeStepFailureReason.HostNotFound;
            } else if (cause instanceof SocketTimeoutException) {
                errormsg = "Connection Timeout (after " + timeout + "ms): " + cause.getMessage();
                reason = NodeStepFailureReason.ConnectionTimeout;
            } else {
                reason = cause instanceof SocketException ? NodeStepFailureReason.ConnectionFailure : StepFailureReason.Unknown;
            }
        }
        return new ExtractFailure(errormsg, (FailureReason)((Object)reason));
    }

    void shutdownAndAwaitTermination(ExecutorService pool) {
        pool.shutdownNow();
        try {
            logger.debug((Object)"Waiting up to 30 seconds for ExecutorService to shut down");
            if (!pool.awaitTermination(30L, TimeUnit.SECONDS)) {
                logger.debug((Object)"Pool did not terminate");
            }
        }
        catch (InterruptedException ie) {
            pool.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    private static String resolveProperty(String nodeAttribute, String defaultValue, INodeEntry node, FrameworkProject frameworkProject, Framework framework) {
        if (null != node.getAttributes().get(nodeAttribute)) {
            return node.getAttributes().get(nodeAttribute);
        }
        if (frameworkProject.hasProperty(PROJ_PROP_PREFIX + nodeAttribute) && !"".equals(frameworkProject.getProperty(PROJ_PROP_PREFIX + nodeAttribute))) {
            return frameworkProject.getProperty(PROJ_PROP_PREFIX + nodeAttribute);
        }
        if (framework.hasProperty(FWK_PROP_PREFIX + nodeAttribute)) {
            return framework.getProperty(FWK_PROP_PREFIX + nodeAttribute);
        }
        return defaultValue;
    }

    private static int resolveIntProperty(String attribute, int defaultValue, INodeEntry iNodeEntry, FrameworkProject frameworkProject, Framework framework) {
        int value = defaultValue;
        String string = JschNodeExecutor.resolveProperty(attribute, null, iNodeEntry, frameworkProject, framework);
        if (null != string) {
            try {
                value = Integer.parseInt(string);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return value;
    }

    private static long resolveLongProperty(String attribute, long defaultValue, INodeEntry iNodeEntry, FrameworkProject frameworkProject, Framework framework) {
        long value = defaultValue;
        String string = JschNodeExecutor.resolveProperty(attribute, null, iNodeEntry, frameworkProject, framework);
        if (null != string) {
            try {
                value = Long.parseLong(string);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return value;
    }

    private static boolean resolveBooleanProperty(String attribute, boolean defaultValue, INodeEntry iNodeEntry, FrameworkProject frameworkProject, Framework framework) {
        boolean value = defaultValue;
        String string = JschNodeExecutor.resolveProperty(attribute, null, iNodeEntry, frameworkProject, framework);
        if (null != string) {
            value = Boolean.parseBoolean(string);
        }
        return value;
    }

    static {
        DescriptionBuilder builder = DescriptionBuilder.builder();
        builder.name(SERVICE_PROVIDER_TYPE).title("SSH").description("Executes a command on a remote node via SSH.");
        builder.property(PropertyUtil.string(CONFIG_KEYPATH, "SSH Keypath", "Path to the SSH Key to use", true, null));
        builder.property(PropertyUtil.select(CONFIG_AUTHENTICATION, "SSH Authentication", "Type of SSH Authentication to use", true, SSHTaskBuilder.AuthenticationType.privateKey.toString(), Arrays.asList(SSHTaskBuilder.AuthenticationType.values()), null, null));
        builder.mapping(CONFIG_KEYPATH, PROJ_PROP_SSH_KEYPATH);
        builder.frameworkMapping(CONFIG_KEYPATH, FWK_PROP_SSH_KEYPATH);
        builder.mapping(CONFIG_AUTHENTICATION, PROJ_PROP_SSH_AUTHENTICATION);
        builder.frameworkMapping(CONFIG_AUTHENTICATION, FWK_PROP_SSH_AUTHENTICATION);
        DESC = builder.build();
    }

    static class ExtractFailure {
        private String errormsg;
        private FailureReason reason;

        private ExtractFailure(String errormsg, FailureReason reason) {
            this.errormsg = errormsg;
            this.reason = reason;
        }

        public String getErrormsg() {
            return this.errormsg;
        }

        public FailureReason getReason() {
            return this.reason;
        }
    }

    private static class SudoResponder
    implements Responder {
        public static final String DEFAULT_DESCRIPTION = "Sudo execution password response";
        private String sudoCommandPattern;
        private String inputSuccessPattern;
        private String inputFailurePattern;
        private String responseSuccessPattern;
        private String responseFailurePattern;
        private int inputMaxLines = -1;
        private long inputMaxTimeout = -1L;
        private boolean failOnInputLinesThreshold = false;
        private boolean failOnInputTimeoutThreshold = true;
        private boolean successOnInputThreshold = true;
        private int responseMaxLines = -1;
        private long responseMaxTimeout = -1L;
        private boolean failOnResponseThreshold = false;
        private String inputString;
        private String configPrefix = "sudo-";
        private String description = "Sudo execution password response";
        private String defaultSudoPasswordOption = "option.sudoPassword";
        private String defaultSudoCommandPattern = "^sudo$";
        private boolean sudoEnabled = false;

        private SudoResponder() {
        }

        private SudoResponder(String configPrefix, String defaultSudoPasswordOption, String defaultSudoCommandPattern) {
            this();
            if (null != configPrefix) {
                this.configPrefix = configPrefix;
            }
            if (null != defaultSudoPasswordOption) {
                this.defaultSudoPasswordOption = defaultSudoPasswordOption;
            }
            if (null != defaultSudoCommandPattern) {
                this.defaultSudoCommandPattern = defaultSudoCommandPattern;
            }
        }

        static SudoResponder create(INodeEntry node, Framework framework, ExecutionContext context) {
            return SudoResponder.create(node, framework, context, null, null, null);
        }

        static SudoResponder create(INodeEntry node, Framework framework, ExecutionContext context, String configPrefix, String defaultSudoPasswordOption, String defaultSudoCommandPattern) {
            SudoResponder sudoResponder = new SudoResponder(configPrefix, defaultSudoPasswordOption, defaultSudoCommandPattern);
            sudoResponder.init(node, framework.getFrameworkProjectMgr().getFrameworkProject(context.getFrameworkProject()), framework, context);
            return sudoResponder;
        }

        public boolean matchesCommandPattern(String command) {
            String sudoCommandPattern1 = this.getSudoCommandPattern();
            if (null != sudoCommandPattern1) {
                return Pattern.compile(sudoCommandPattern1).matcher(command).matches();
            }
            return false;
        }

        private void init(INodeEntry node, FrameworkProject frameworkProject, Framework framework, ExecutionContext context) {
            this.sudoEnabled = JschNodeExecutor.resolveBooleanProperty(this.configPrefix + JschNodeExecutor.NODE_ATTR_SUDO_COMMAND_ENABLED, false, node, frameworkProject, framework);
            if (this.sudoEnabled) {
                String sudoPassOptname = JschNodeExecutor.resolveProperty(this.configPrefix + JschNodeExecutor.NODE_ATTR_SUDO_PASSWORD_OPTION, null, node, frameworkProject, framework);
                String sudoPassword = NodeSSHConnectionInfo.evaluateSecureOption(null != sudoPassOptname ? sudoPassOptname : this.defaultSudoPasswordOption, context);
                this.inputString = (null != sudoPassword ? sudoPassword : "") + "\n";
                this.sudoCommandPattern = JschNodeExecutor.resolveProperty(this.configPrefix + JschNodeExecutor.NODE_ATTR_SUDO_COMMAND_PATTERN, this.defaultSudoCommandPattern, node, frameworkProject, framework);
                this.inputSuccessPattern = JschNodeExecutor.resolveProperty(this.configPrefix + JschNodeExecutor.NODE_ATTR_SUDO_PROMPT_PATTERN, JschNodeExecutor.DEFAULT_SUDO_PROMPT_PATTERN, node, frameworkProject, framework);
                this.inputFailurePattern = null;
                this.responseFailurePattern = JschNodeExecutor.resolveProperty(this.configPrefix + JschNodeExecutor.NODE_ATTR_SUDO_FAILURE_PATTERN, JschNodeExecutor.DEFAULT_SUDO_FAILURE_PATTERN, node, frameworkProject, framework);
                this.responseSuccessPattern = null;
                this.inputMaxLines = JschNodeExecutor.resolveIntProperty(this.configPrefix + JschNodeExecutor.NODE_ATTR_SUDO_PROMPT_MAX_LINES, 12, node, frameworkProject, framework);
                this.inputMaxTimeout = JschNodeExecutor.resolveLongProperty(this.configPrefix + JschNodeExecutor.NODE_ATTR_SUDO_PROMPT_MAX_TIMEOUT, 5000L, node, frameworkProject, framework);
                this.responseMaxLines = JschNodeExecutor.resolveIntProperty(this.configPrefix + JschNodeExecutor.NODE_ATTR_SUDO_RESPONSE_MAX_LINES, 2, node, frameworkProject, framework);
                this.responseMaxTimeout = JschNodeExecutor.resolveLongProperty(this.configPrefix + JschNodeExecutor.NODE_ATTR_SUDO_RESPONSE_MAX_TIMEOUT, 5000L, node, frameworkProject, framework);
                this.failOnInputLinesThreshold = JschNodeExecutor.resolveBooleanProperty(this.configPrefix + JschNodeExecutor.NODE_ATTR_SUDO_FAIL_ON_PROMPT_MAX_LINES, false, node, frameworkProject, framework);
                this.failOnInputTimeoutThreshold = JschNodeExecutor.resolveBooleanProperty(this.configPrefix + JschNodeExecutor.NODE_ATTR_SUDO_FAIL_ON_PROMPT_TIMEOUT, true, node, frameworkProject, framework);
                this.failOnResponseThreshold = JschNodeExecutor.resolveBooleanProperty(this.configPrefix + JschNodeExecutor.NODE_ATTR_SUDO_FAIL_ON_RESPONSE_TIMEOUT, false, node, frameworkProject, framework);
                this.successOnInputThreshold = JschNodeExecutor.resolveBooleanProperty(this.configPrefix + JschNodeExecutor.NODE_ATTR_SUDO_SUCCESS_ON_PROMPT_THRESHOLD, true, node, frameworkProject, framework);
            }
        }

        public boolean isSudoEnabled() {
            return this.sudoEnabled;
        }

        @Override
        public String getInputString() {
            return this.inputString;
        }

        @Override
        public boolean isFailOnInputLinesThreshold() {
            return this.failOnInputLinesThreshold;
        }

        @Override
        public boolean isFailOnInputTimeoutThreshold() {
            return this.failOnInputTimeoutThreshold;
        }

        @Override
        public boolean isFailOnResponseThreshold() {
            return this.failOnResponseThreshold;
        }

        @Override
        public boolean isSuccessOnInputThreshold() {
            return this.successOnInputThreshold;
        }

        public String getSudoCommandPattern() {
            return this.sudoCommandPattern;
        }

        @Override
        public String getInputFailurePattern() {
            return this.inputFailurePattern;
        }

        @Override
        public String getInputSuccessPattern() {
            return this.inputSuccessPattern;
        }

        @Override
        public String getResponseSuccessPattern() {
            return this.responseSuccessPattern;
        }

        @Override
        public String getResponseFailurePattern() {
            return this.responseFailurePattern;
        }

        @Override
        public int getInputMaxLines() {
            return this.inputMaxLines;
        }

        @Override
        public long getInputMaxTimeout() {
            return this.inputMaxTimeout;
        }

        @Override
        public int getResponseMaxLines() {
            return this.responseMaxLines;
        }

        @Override
        public long getResponseMaxTimeout() {
            return this.responseMaxTimeout;
        }

        public String toString() {
            return this.description;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }
    }

    private static class DisconnectResultHandler
    implements ResponderTask.ResultHandler,
    ExtSSHExec.DisconnectHolder {
        private volatile ExtSSHExec.Disconnectable disconnectable;
        private volatile boolean needsDisconnect = false;

        private DisconnectResultHandler() {
        }

        @Override
        public void setDisconnectable(ExtSSHExec.Disconnectable disconnectable) {
            this.disconnectable = disconnectable;
            this.checkAndDisconnect();
        }

        @Override
        public void handleResult(boolean success, String reason) {
            this.needsDisconnect = !success;
            this.checkAndDisconnect();
        }

        private synchronized void checkAndDisconnect() {
            if (null != this.disconnectable && this.needsDisconnect) {
                this.disconnectable.disconnect();
                this.needsDisconnect = false;
            }
        }
    }

    static final class NodeSSHConnectionInfo
    implements SSHTaskBuilder.SSHConnectionInfo {
        final INodeEntry node;
        final Framework framework;
        final ExecutionContext context;
        FrameworkProject frameworkProject;

        NodeSSHConnectionInfo(INodeEntry node, Framework framework, ExecutionContext context) {
            this.node = node;
            this.framework = framework;
            this.context = context;
            this.frameworkProject = framework.getFrameworkProjectMgr().getFrameworkProject(context.getFrameworkProject());
        }

        @Override
        public SSHTaskBuilder.AuthenticationType getAuthenticationType() {
            if (null != this.node.getAttributes().get(JschNodeExecutor.NODE_ATTR_SSH_AUTHENTICATION)) {
                return SSHTaskBuilder.AuthenticationType.valueOf(this.node.getAttributes().get(JschNodeExecutor.NODE_ATTR_SSH_AUTHENTICATION));
            }
            if (this.frameworkProject.hasProperty(JschNodeExecutor.PROJ_PROP_SSH_AUTHENTICATION)) {
                return SSHTaskBuilder.AuthenticationType.valueOf(this.frameworkProject.getProperty(JschNodeExecutor.PROJ_PROP_SSH_AUTHENTICATION));
            }
            if (this.framework.hasProperty(JschNodeExecutor.FWK_PROP_SSH_AUTHENTICATION)) {
                return SSHTaskBuilder.AuthenticationType.valueOf(this.framework.getProperty(JschNodeExecutor.FWK_PROP_SSH_AUTHENTICATION));
            }
            return SSHTaskBuilder.AuthenticationType.privateKey;
        }

        @Override
        public String getPrivateKeyfilePath() {
            if (null != this.node.getAttributes().get(JschNodeExecutor.NODE_ATTR_SSH_KEYPATH)) {
                return this.node.getAttributes().get(JschNodeExecutor.NODE_ATTR_SSH_KEYPATH);
            }
            if (this.frameworkProject.hasProperty(JschNodeExecutor.PROJ_PROP_SSH_KEYPATH)) {
                return this.frameworkProject.getProperty(JschNodeExecutor.PROJ_PROP_SSH_KEYPATH);
            }
            if (this.framework.hasProperty(JschNodeExecutor.FWK_PROP_SSH_KEYPATH)) {
                return this.framework.getProperty(JschNodeExecutor.FWK_PROP_SSH_KEYPATH);
            }
            return this.framework.getProperty("framework.ssh.keypath");
        }

        @Override
        public String getPrivateKeyPassphrase() {
            if (null != this.node.getAttributes().get(JschNodeExecutor.NODE_ATTR_SSH_KEY_PASSPHRASE_OPTION)) {
                return NodeSSHConnectionInfo.evaluateSecureOption(this.node.getAttributes().get(JschNodeExecutor.NODE_ATTR_SSH_KEY_PASSPHRASE_OPTION), this.context);
            }
            return NodeSSHConnectionInfo.evaluateSecureOption(JschNodeExecutor.DEFAULT_SSH_KEY_PASSPHRASE_OPTION, this.context);
        }

        static String evaluateSecureOption(String optionName, ExecutionContext context) {
            if (null == optionName) {
                logger.debug((Object)"option name was null");
                return null;
            }
            if (null == context.getPrivateDataContext()) {
                logger.debug((Object)"private context was null");
                return null;
            }
            String[] opts = optionName.split("\\.", 2);
            if (null != opts && 2 == opts.length) {
                Map<String, String> option = context.getPrivateDataContext().get(opts[0]);
                if (null != option) {
                    String value = option.get(opts[1]);
                    if (null == value) {
                        logger.debug((Object)("private context '" + optionName + "' was null"));
                    }
                    return value;
                }
                logger.debug((Object)("private context '" + opts[0] + "' was null"));
            }
            return null;
        }

        @Override
        public String getPassword() {
            if (null != this.node.getAttributes().get(JschNodeExecutor.NODE_ATTR_SSH_PASSWORD_OPTION)) {
                return NodeSSHConnectionInfo.evaluateSecureOption(this.node.getAttributes().get(JschNodeExecutor.NODE_ATTR_SSH_PASSWORD_OPTION), this.context);
            }
            return NodeSSHConnectionInfo.evaluateSecureOption(JschNodeExecutor.DEFAULT_SSH_PASSWORD_OPTION, this.context);
        }

        @Override
        public int getSSHTimeout() {
            int timeout = 0;
            if (this.framework.getPropertyLookup().hasProperty("framework.ssh.timeout")) {
                String val = this.framework.getProperty("framework.ssh.timeout");
                try {
                    timeout = Integer.parseInt(val);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return timeout;
        }

        public static String nonBlank(String input) {
            if (null == input || "".equals(input.trim())) {
                return null;
            }
            return input.trim();
        }

        @Override
        public String getUsername() {
            String user = null != NodeSSHConnectionInfo.nonBlank(this.node.getUsername()) || this.node.containsUserName() ? NodeSSHConnectionInfo.nonBlank(this.node.extractUserName()) : (this.frameworkProject.hasProperty(JschNodeExecutor.PROJECT_SSH_USER) && null != NodeSSHConnectionInfo.nonBlank(this.frameworkProject.getProperty(JschNodeExecutor.PROJECT_SSH_USER)) ? NodeSSHConnectionInfo.nonBlank(this.frameworkProject.getProperty(JschNodeExecutor.PROJECT_SSH_USER)) : NodeSSHConnectionInfo.nonBlank(this.framework.getProperty("framework.ssh.user")));
            if (null != user && user.contains("${")) {
                return DataContextUtils.replaceDataReferences(user, this.context.getDataContext());
            }
            return user;
        }
    }

    static enum JschFailureReason implements FailureReason
    {
        SSHProtocolFailure;

    }
}

