/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.execution.workflow;

import com.dtolabs.rundeck.core.execution.workflow.ContextStack;
import com.dtolabs.rundeck.core.execution.workflow.StepNodeContext;
import com.dtolabs.rundeck.core.execution.workflow.StepNodeContextListener;
import java.util.List;

public class StepContextWorkflowExecutionListener<NODE, STEP>
implements StepNodeContextListener<NODE, STEP>,
StepNodeContext<NODE, STEP> {
    private InheritableThreadLocal<STEP> localStep = new InheritableThreadLocal();
    private InheritableThreadLocal<NODE> localNode = new InheritableThreadLocal();
    private InheritableThreadLocal<ContextStack<STEP>> contextStack = new InheritableThreadLocal();

    @Override
    public void beginContext() {
        Object info = this.localStep.get();
        if (null != info) {
            if (null != this.contextStack.get()) {
                this.contextStack.set(((ContextStack)this.contextStack.get()).copyPush(info));
            } else {
                this.contextStack.set(ContextStack.create(info));
            }
        }
        this.localStep.set(null);
        this.localNode.set(null);
    }

    @Override
    public void finishContext() {
        ContextStack stack = (ContextStack)this.contextStack.get();
        if (null != stack) {
            if (stack.size() > 0) {
                this.localStep.set(stack.pop());
            } else {
                this.localStep.set(null);
                this.contextStack.set(null);
            }
        } else {
            this.localStep.set(null);
        }
        this.localNode.set(null);
    }

    @Override
    public void beginStepContext(STEP step) {
        this.localStep.set(step);
    }

    @Override
    public void finishStepContext() {
        this.localStep.set(null);
    }

    @Override
    public void beginNodeContext(NODE node) {
        this.localNode.set(node);
    }

    @Override
    public void finishNodeContext() {
        this.localNode.set(null);
    }

    @Override
    public NODE getCurrentNode() {
        return (NODE)this.localNode.get();
    }

    @Override
    public List<STEP> getCurrentContext() {
        Object step = this.localStep.get();
        if (null != step) {
            if (null != this.contextStack.get()) {
                return ((ContextStack)this.contextStack.get()).copyPush(step).stack();
            }
            return ContextStack.create(step).stack();
        }
        if (null != this.contextStack.get()) {
            List stack = ((ContextStack)this.contextStack.get()).stack();
            if (stack.size() > 0) {
                return stack;
            }
            return null;
        }
        return null;
    }
}

