/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.plugins;

import com.dtolabs.rundeck.core.common.Framework;
import com.dtolabs.rundeck.core.plugins.ScriptPluginProvider;
import com.dtolabs.rundeck.core.plugins.configuration.ConfigurationException;
import com.dtolabs.rundeck.core.plugins.configuration.Describable;
import com.dtolabs.rundeck.core.plugins.configuration.Description;
import com.dtolabs.rundeck.core.plugins.configuration.Property;
import com.dtolabs.rundeck.core.plugins.configuration.PropertyScope;
import com.dtolabs.rundeck.plugins.util.DescriptionBuilder;
import com.dtolabs.rundeck.plugins.util.PropertyBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class AbstractDescribableScriptPlugin
implements Describable {
    public static final String TITLE_PROP = "title";
    public static final String DESCRIPTION_PROP = "description";
    public static final String CONFIG_PROP_PREFIX = "config";
    public static final String CONFIG_TITLE = "title";
    public static final String CONFIG_DESCRIPTION = "description";
    public static final String CONFIG_NAME = "name";
    public static final String CONFIG_TYPE = "type";
    public static final String CONFIG_REQUIRED = "required";
    public static final String CONFIG_DEFAULT = "default";
    public static final String CONFIG_VALUES = "values";
    public static final String CONFIG_SCOPE = "scope";
    private final ScriptPluginProvider provider;
    private final Framework framework;
    Description description;

    public AbstractDescribableScriptPlugin(ScriptPluginProvider provider, Framework framework) {
        this.provider = provider;
        this.framework = framework;
    }

    public Map<String, String> createPluginDataContext() {
        HashMap<String, String> pluginDataContext = new HashMap<String, String>();
        pluginDataContext.put("file", this.provider.getArchiveFile().getAbsolutePath());
        pluginDataContext.put("scriptfile", this.provider.getScriptFile().getAbsolutePath());
        pluginDataContext.put("base", this.provider.getContentsBasedir().getAbsolutePath());
        return pluginDataContext;
    }

    private static void createProperties(ScriptPluginProvider provider, DescriptionBuilder dbuilder) throws ConfigurationException {
        Map<String, Object> metadata = provider.getMetadata();
        Object config = metadata.get(CONFIG_PROP_PREFIX);
        if (config instanceof List) {
            List configs = (List)config;
            for (Object citem : configs) {
                ArrayList<String> values;
                List valueList;
                if (!(citem instanceof Map)) continue;
                PropertyBuilder pbuild = PropertyBuilder.builder();
                Map itemmeta = (Map)citem;
                String typestr = AbstractDescribableScriptPlugin.metaStringProp(itemmeta, CONFIG_TYPE);
                try {
                    pbuild.type(Property.Type.valueOf(typestr));
                }
                catch (IllegalArgumentException e) {
                    throw new ConfigurationException("Invalid property type: " + typestr);
                }
                pbuild.name(AbstractDescribableScriptPlugin.metaStringProp(itemmeta, CONFIG_NAME)).title(AbstractDescribableScriptPlugin.metaStringProp(itemmeta, "title")).description(AbstractDescribableScriptPlugin.metaStringProp(itemmeta, "description"));
                Object reqValue = itemmeta.get(CONFIG_REQUIRED);
                boolean required = reqValue instanceof Boolean ? (Boolean)reqValue : reqValue instanceof String && Boolean.parseBoolean((String)reqValue);
                pbuild.required(required);
                Object defObj = itemmeta.get(CONFIG_DEFAULT);
                pbuild.defaultValue(null != defObj ? defObj.toString() : null);
                String valuesstr = AbstractDescribableScriptPlugin.metaStringProp(itemmeta, CONFIG_VALUES);
                if (null != valuesstr) {
                    String[] split = null != valuesstr ? valuesstr.split(",") : null;
                    valueList = Arrays.asList(split);
                } else {
                    Object vlist = itemmeta.get(CONFIG_VALUES);
                    valueList = vlist instanceof List ? (List)vlist : null;
                }
                if (null != valueList) {
                    ArrayList<String> valuesA = new ArrayList<String>();
                    for (String s : valueList) {
                        valuesA.add(s.trim());
                    }
                    values = valuesA;
                } else {
                    values = null;
                }
                pbuild.values(values);
                String scopeString = AbstractDescribableScriptPlugin.metaStringProp(itemmeta, CONFIG_SCOPE);
                if (null != scopeString) {
                    try {
                        pbuild.scope(PropertyScope.valueOf(scopeString.trim()));
                    }
                    catch (IllegalArgumentException e) {
                        throw new ConfigurationException("Invalid property scope: " + scopeString);
                    }
                }
                try {
                    dbuilder.property(pbuild.build());
                }
                catch (IllegalStateException e) {
                    throw new ConfigurationException(e.getMessage());
                }
            }
        }
    }

    private static String metaStringProp(Map<String, Object> metadata, String prop) {
        return AbstractDescribableScriptPlugin.metaStringProp(metadata, prop, null);
    }

    private static String metaStringProp(Map<String, Object> metadata, String prop, String defString) {
        Object titleobj = metadata.get(prop);
        return null != titleobj && titleobj instanceof String ? (String)titleobj : defString;
    }

    protected static void createDescription(ScriptPluginProvider provider, boolean allowCustomProperties, DescriptionBuilder builder) throws ConfigurationException {
        builder.name(provider.getName()).title(AbstractDescribableScriptPlugin.metaStringProp(provider.getMetadata(), "title", provider.getName() + " Script Plugin")).description(AbstractDescribableScriptPlugin.metaStringProp(provider.getMetadata(), "description", ""));
        if (allowCustomProperties) {
            AbstractDescribableScriptPlugin.createProperties(provider, builder);
        }
    }

    @Override
    public Description getDescription() {
        if (null == this.description) {
            DescriptionBuilder builder = DescriptionBuilder.builder();
            try {
                AbstractDescribableScriptPlugin.createDescription(this.provider, this.isAllowCustomProperties(), builder);
            }
            catch (ConfigurationException e) {
                e.printStackTrace();
            }
            this.description = builder.build();
        }
        return this.description;
    }

    public abstract boolean isAllowCustomProperties();

    public ScriptPluginProvider getProvider() {
        return this.provider;
    }

    public Framework getFramework() {
        return this.framework;
    }
}

