/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.resources;

import com.dtolabs.rundeck.core.common.INodeSet;
import com.dtolabs.rundeck.core.resources.ResourceModelSource;
import com.dtolabs.rundeck.core.resources.ResourceModelSourceCache;
import com.dtolabs.rundeck.core.resources.ResourceModelSourceException;
import com.dtolabs.rundeck.core.resources.format.ResourceFormatGenerator;
import com.dtolabs.rundeck.core.resources.format.ResourceFormatGeneratorException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;

public class FileResourceModelSourceCache
implements ResourceModelSourceCache {
    private File cacheFile;
    private ResourceFormatGenerator generator;
    private ResourceModelSource fileResourceModelSource;

    public FileResourceModelSourceCache(File cacheFile, ResourceFormatGenerator generator, ResourceModelSource fileResourceModelSource) {
        this.cacheFile = cacheFile;
        this.generator = generator;
        this.fileResourceModelSource = fileResourceModelSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storeNodesInCache(INodeSet nodes) throws ResourceModelSourceException {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(this.cacheFile);
            try {
                this.generator.generateDocument(nodes, fileOutputStream);
            }
            finally {
                fileOutputStream.close();
            }
        }
        catch (ResourceFormatGeneratorException e) {
            throw new ResourceModelSourceException("Failed to generate cache file: " + e.getLocalizedMessage(), e);
        }
        catch (IOException e) {
            throw new ResourceModelSourceException("Failed to generate cache file: " + e.getLocalizedMessage(), e);
        }
    }

    @Override
    public INodeSet loadCachedNodes() throws ResourceModelSourceException {
        return this.fileResourceModelSource.getNodes();
    }
}

