/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.utils;

import com.dtolabs.rundeck.core.common.PropertyRetriever;
import com.dtolabs.rundeck.core.utils.IPropertyLookup;
import com.dtolabs.rundeck.core.utils.PropertyLookupException;
import com.dtolabs.rundeck.core.utils.PropertyUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;

public class PropertyLookup
implements IPropertyLookup {
    final Properties properties;
    final File propsFile;
    volatile boolean deferred;

    private PropertyLookup(File propsFile, boolean deferred) {
        this.properties = new Properties();
        this.propsFile = propsFile;
        this.deferred = deferred;
    }

    private PropertyLookup(Properties props) {
        this.properties = props;
        this.propsFile = null;
        this.deferred = false;
    }

    public static PropertyLookup create(Properties props) {
        return new PropertyLookup(props);
    }

    public static PropertyLookup create(IPropertyLookup defaultsLookup) {
        return new PropertyLookup(new Properties(), defaultsLookup);
    }

    private PropertyLookup(Properties props, Map defaults) {
        this(props);
        this.properties.putAll((Map<?, ?>)this.difference(defaults));
    }

    private PropertyLookup(Properties props, IPropertyLookup defaultsLookup) {
        this(props, defaultsLookup.getPropertiesMap());
    }

    private PropertyLookup(File propfile, Map defaults, IPropertyLookup defaultsLookup) {
        this(PropertyLookup.fetchProperties(propfile), defaults);
        this.properties.putAll((Map<?, ?>)this.difference(defaultsLookup.getPropertiesMap()));
    }

    public static PropertyLookup create(File propFile) {
        return new PropertyLookup(PropertyLookup.fetchProperties(propFile));
    }

    public static PropertyLookup createDeferred(File propFile) {
        return new PropertyLookup(propFile, true);
    }

    public static PropertyLookup create(File propfile, IPropertyLookup defaultsLookup) {
        return new PropertyLookup(PropertyLookup.fetchProperties(propfile), defaultsLookup);
    }

    public static PropertyLookup create(File propfile, Map defaults, IPropertyLookup defaultsLookup) {
        return new PropertyLookup(propfile, defaults, defaultsLookup);
    }

    @Override
    public String getProperty(String key) {
        if (this.hasProperty(key)) {
            return this.properties.getProperty(key);
        }
        throw new PropertyLookupException("property not found: " + key);
    }

    public PropertyRetriever safe() {
        return PropertyLookup.safePropertyRetriever(this);
    }

    public static PropertyRetriever safePropertyRetriever(final IPropertyLookup lookup) {
        return new PropertyRetriever(){

            @Override
            public String getProperty(String name) {
                if (lookup.hasProperty(name)) {
                    return lookup.getProperty(name);
                }
                return null;
            }
        };
    }

    @Override
    public boolean hasProperty(String key) {
        if (this.deferred) {
            this.loadProperties();
        }
        return this.properties.containsKey(key);
    }

    private synchronized void loadProperties() {
        if (this.deferred && this.propsFile.exists()) {
            try {
                this.properties.putAll((Map<?, ?>)PropertyLookup.fetchProperties(this.propsFile));
                this.expand();
                this.deferred = false;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties fetchProperties(File propFile) {
        Properties properties = new Properties();
        try {
            FileInputStream fis = new FileInputStream(propFile);
            try {
                properties.load(fis);
            }
            finally {
                if (null != fis) {
                    fis.close();
                }
            }
        }
        catch (IOException e) {
            throw new PropertyLookupException("failed loading properties from file: " + propFile, e);
        }
        return properties;
    }

    @Override
    public Map getPropertiesMap() {
        return Collections.unmodifiableMap(this.properties);
    }

    public PropertyLookup expand() {
        try {
            Properties expanded = PropertyUtil.expand(this.properties);
            this.properties.putAll((Map<?, ?>)expanded);
        }
        catch (Exception e) {
            throw new PropertyLookupException("failed expanding properties", e);
        }
        return this;
    }

    protected Properties difference(Map map) {
        Properties difference = new Properties();
        Iterator i$ = map.entrySet().iterator();
        while (i$.hasNext()) {
            Map.Entry o;
            Map.Entry entry = o = i$.next();
            String key = (String)entry.getKey();
            String val = (String)entry.getValue();
            if (this.properties.containsKey(key)) continue;
            difference.setProperty(key, val);
        }
        return difference;
    }

    protected int countProperties() {
        return this.properties.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean hasProperty(String propKey, File propFile) {
        if (null == propKey) {
            throw new IllegalArgumentException("propKey param was null");
        }
        if (null == propFile) {
            throw new IllegalArgumentException("propFile param was null");
        }
        if (propFile.exists()) {
            Properties p = new Properties();
            try {
                FileInputStream fis = new FileInputStream(propFile);
                try {
                    p.load(fis);
                }
                finally {
                    if (null != fis) {
                        fis.close();
                    }
                }
                return p.containsKey(propKey);
            }
            catch (IOException e) {
                return false;
            }
        }
        return false;
    }
}

