/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.client.services;

import com.dtolabs.client.services.CentralDispatcherFailureResponseException;
import com.dtolabs.client.services.CentralDispatcherServerRequestException;
import com.dtolabs.client.services.DeleteJobResultImpl;
import com.dtolabs.client.services.ExecutionDetailImpl;
import com.dtolabs.client.services.QueuedItemResultImpl;
import com.dtolabs.client.services.ServerService;
import com.dtolabs.client.services.StoredJobExecutionImpl;
import com.dtolabs.client.services.StoredJobImpl;
import com.dtolabs.client.services.StoredJobLoadResultImpl;
import com.dtolabs.client.utils.WebserviceResponse;
import com.dtolabs.rundeck.core.common.Framework;
import com.dtolabs.rundeck.core.dispatcher.CentralDispatcher;
import com.dtolabs.rundeck.core.dispatcher.CentralDispatcherException;
import com.dtolabs.rundeck.core.dispatcher.DeleteJobResult;
import com.dtolabs.rundeck.core.dispatcher.DispatcherResult;
import com.dtolabs.rundeck.core.dispatcher.ExecutionDetail;
import com.dtolabs.rundeck.core.dispatcher.ExecutionFollowReceiver;
import com.dtolabs.rundeck.core.dispatcher.ExecutionFollowRequest;
import com.dtolabs.rundeck.core.dispatcher.ExecutionFollowResult;
import com.dtolabs.rundeck.core.dispatcher.ExecutionState;
import com.dtolabs.rundeck.core.dispatcher.IDispatchedJob;
import com.dtolabs.rundeck.core.dispatcher.IDispatchedScript;
import com.dtolabs.rundeck.core.dispatcher.ILoadJobsRequest;
import com.dtolabs.rundeck.core.dispatcher.IStoredJob;
import com.dtolabs.rundeck.core.dispatcher.IStoredJobLoadResult;
import com.dtolabs.rundeck.core.dispatcher.IStoredJobsQuery;
import com.dtolabs.rundeck.core.dispatcher.IStoredJobsQueryImpl;
import com.dtolabs.rundeck.core.dispatcher.JobDefinitionFileFormat;
import com.dtolabs.rundeck.core.dispatcher.QueuedItem;
import com.dtolabs.rundeck.core.dispatcher.QueuedItemResult;
import com.dtolabs.rundeck.core.utils.OptsUtil;
import com.dtolabs.utils.Streams;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.util.URIUtil;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.Node;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.SafeConstructor;
import org.yaml.snakeyaml.error.YAMLException;

public class RundeckAPICentralDispatcher
implements CentralDispatcher {
    public static final String RUNDECK_JOB_LINK_PREFIX = "/job/show/";
    public static final String RUNDECK_EXEC_LINK_PREFIX = "/execution/show/";
    public static final String RUNDECK_API_VERSION = "2";
    public static final String RUNDECK_API_VERSION_4 = "4";
    public static final String RUNDECK_API_VERSION_5 = "5";
    public static final String RUNDECK_API_VERSION_8 = "8";
    public static final String RUNDECK_API_VERSION_9 = "9";
    public static final String RUNDECK_API_BASE = "/api/2";
    public static final String RUNDECK_API_BASE_v4 = "/api/4";
    public static final String RUNDECK_API_BASE_v5 = "/api/5";
    public static final String RUNDECK_API_BASE_v8 = "/api/8";
    public static final String RUNDECK_API_BASE_v9 = "/api/9";
    public static final String RUNDECK_API_EXECUTION_REPORT = "/api/2/report/create";
    public static final String RUNDECK_API_RUN_SCRIPT = "/api/2/run/script";
    public static final String RUNDECK_API_RUN_COMMAND = "/api/2/run/command";
    public static final String RUNDECK_API_RUN_URL = "/api/4/run/url";
    public static final String RUNDECK_API_LIST_EXECUTIONS_PATH = "/api/2/executions/running";
    public static final String RUNDECK_API_EXECUTION_PATH = "/api/2/execution/$id";
    public static final String RUNDECK_API_KILL_JOB_PATH = "/api/2/execution/$id/abort";
    public static final String RUNDECK_API_EXEC_OUTPUT_PATH = "/api/5/execution/$id/output";
    public static final String RUNDECK_API_JOBS_EXPORT_PATH = "/api/2/jobs/export";
    public static final String RUNDECK_API_JOBS_BULK_DELETE_PATH = "/api/5/jobs/delete";
    public static final String RUNDECK_API_JOBS_LIST_PATH = "/api/2/jobs";
    public static final String RUNDECK_API_JOBS_UPLOAD = "/api/9/jobs/import";
    public static final String RUNDECK_API_JOBS_RUN = "/api/2/job/$id/run";
    public static final Logger logger = Logger.getLogger(RundeckAPICentralDispatcher.class);
    private ServerService serverService;
    private static final SimpleDateFormat w3cDateFormat = new SimpleDateFormat(""){
        {
            this.setTimeZone(TimeZone.getTimeZone("GMT"));
        }
    };

    public RundeckAPICentralDispatcher(Framework framework) {
        this.serverService = new ServerService(framework);
    }

    @Override
    public void reportExecutionStatus(String project, String title, String status, int failedNodeCount, int successNodeCount, String tags, String script, String summary, Date start, Date end) throws CentralDispatcherException {
        WebserviceResponse response;
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("project", project);
        params.put("title", title);
        params.put("status", status);
        params.put("nodesuccesscount", Integer.toString(successNodeCount));
        params.put("nodefailcount", Integer.toString(failedNodeCount));
        if (null != tags) {
            params.put("tags", tags);
        }
        if (null != script) {
            params.put("script", script);
        }
        params.put("summary", summary);
        if (null != start) {
            params.put("start", Long.toString(start.getTime()));
        }
        if (null != end) {
            params.put("end", Long.toString(end.getTime()));
        }
        try {
            response = this.serverService.makeRundeckRequest(RUNDECK_API_EXECUTION_REPORT, null, params);
        }
        catch (MalformedURLException e) {
            throw new CentralDispatcherServerRequestException("Failed to make request", e);
        }
        this.validateResponse(response);
    }

    @Override
    public QueuedItemResult queueDispatcherScript(IDispatchedScript iDispatchedScript) throws CentralDispatcherException {
        boolean isUrl;
        boolean isExec;
        ArrayList<String> args = new ArrayList<String>();
        String scriptURL = null;
        File uploadFile = null;
        InputStream stream = iDispatchedScript.getScriptAsStream();
        if (null != iDispatchedScript.getScript() || null != stream) {
            if (null != iDispatchedScript.getScript()) {
                String scriptString = iDispatchedScript.getScript();
            } else {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                try {
                    Streams.copyStream(stream, byteArrayOutputStream);
                }
                catch (IOException e) {
                    throw new CentralDispatcherServerRequestException("Unable to queue command: " + e.getMessage(), e);
                }
                String scriptString = new String(byteArrayOutputStream.toByteArray());
            }
            isExec = false;
            isUrl = false;
        } else if (null != iDispatchedScript.getServerScriptFilePath()) {
            uploadFile = new File(iDispatchedScript.getServerScriptFilePath());
            isExec = false;
            isUrl = false;
        } else if (null != iDispatchedScript.getScriptURLString()) {
            scriptURL = iDispatchedScript.getScriptURLString();
            Object scriptString = null;
            isExec = false;
            isUrl = true;
        } else if (null != iDispatchedScript.getArgs() && iDispatchedScript.getArgs().length > 0) {
            Object scriptString = null;
            isExec = true;
            isUrl = false;
        } else {
            throw new IllegalArgumentException("Dispatched script did not specify a command, script or filepath");
        }
        if (null != iDispatchedScript.getArgs() && iDispatchedScript.getArgs().length > 0) {
            args.addAll(Arrays.asList(iDispatchedScript.getArgs()));
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("project", iDispatchedScript.getFrameworkProject());
        if (isExec) {
            params.put("exec", OptsUtil.join(args));
        } else if (null != scriptURL) {
            params.put("scriptURL", scriptURL);
        }
        if (!isExec && args.size() > 0) {
            params.put("argString", OptsUtil.join(args));
        }
        this.addLoglevelParams(params, iDispatchedScript.getLoglevel());
        RundeckAPICentralDispatcher.addAPINodeSetParams(params, iDispatchedScript.isKeepgoing(), iDispatchedScript.getNodeFilter(), iDispatchedScript.getNodeThreadcount(), iDispatchedScript.getNodeExcludePrecedence());
        return this.submitRunRequest(uploadFile, params, isExec ? RUNDECK_API_RUN_COMMAND : (isUrl ? RUNDECK_API_RUN_URL : RUNDECK_API_RUN_SCRIPT), "scriptFile");
    }

    private QueuedItemResult submitExecutionRequest(File tempxml, HashMap<String, String> otherparams, String requestPath) throws CentralDispatcherException {
        WebserviceResponse response;
        HashMap<String, String> params = new HashMap<String, String>();
        if (null != otherparams) {
            params.putAll(otherparams);
        }
        try {
            response = this.serverService.makeRundeckRequest(requestPath, params, tempxml, null, "xmlBatch");
        }
        catch (MalformedURLException e) {
            throw new CentralDispatcherServerRequestException("Failed to make request", e);
        }
        this.validateResponse(response);
        ArrayList<QueuedItem> list = this.parseExecutionListResult(response);
        if (null == list || list.size() < 1) {
            return QueuedItemResultImpl.failed("Server response contained no success information.");
        }
        QueuedItem next = list.iterator().next();
        return QueuedItemResultImpl.successful("Succeeded queueing " + next.getName(), next.getId(), next.getUrl(), next.getName());
    }

    private QueuedItemResult submitRunRequest(File tempxml, HashMap<String, String> otherparams, String requestPath, String uploadFileParam) throws CentralDispatcherException {
        WebserviceResponse response;
        HashMap<String, String> params = new HashMap<String, String>();
        if (null != otherparams) {
            params.putAll(otherparams);
        }
        try {
            response = this.serverService.makeRundeckRequest(requestPath, params, tempxml, null, null, null, uploadFileParam);
        }
        catch (MalformedURLException e) {
            throw new CentralDispatcherServerRequestException("Failed to make request", e);
        }
        this.validateResponse(response);
        Document resultDoc = response.getResultDoc();
        if (null != resultDoc.selectSingleNode("/result/execution") && null != resultDoc.selectSingleNode("/result/execution/@id")) {
            Node node = resultDoc.selectSingleNode("/result/execution/@id");
            String succeededId = node.getStringValue();
            String name = "adhoc";
            String url = this.createExecutionURL(succeededId);
            url = this.makeAbsoluteURL(url);
            logger.info((Object)("\t[" + succeededId + "] <" + url + ">"));
            return QueuedItemResultImpl.successful("Succeeded queueing adhoc", succeededId, url, "adhoc");
        }
        return QueuedItemResultImpl.failed("Server response contained no success information.");
    }

    @Override
    public Collection<QueuedItem> listDispatcherQueue() throws CentralDispatcherException {
        throw new CentralDispatcherException("Unsupported operation: project is required by the RunDeck API");
    }

    @Override
    public Collection<QueuedItem> listDispatcherQueue(String project) throws CentralDispatcherException {
        WebserviceResponse response;
        if (null == project) {
            throw new CentralDispatcherException("Unsupported operation: project is required by the RunDeck API");
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("project", project);
        try {
            response = this.serverService.makeRundeckRequest(RUNDECK_API_LIST_EXECUTIONS_PATH, params, null, null, null);
        }
        catch (MalformedURLException e) {
            throw new CentralDispatcherServerRequestException("Failed to make request", e);
        }
        this.validateResponse(response);
        return this.parseExecutionListResult(response);
    }

    private List<ExecutionDetail> parseExecutionsResult(WebserviceResponse response) {
        Document resultDoc = response.getResultDoc();
        Node node = resultDoc.selectSingleNode("/result/executions");
        List items = node.selectNodes("execution");
        ArrayList<ExecutionDetail> list = new ArrayList<ExecutionDetail>();
        if (null != items && items.size() > 0) {
            for (Object o : items) {
                Node node1 = (Node)o;
                ExecutionDetailImpl detail = new ExecutionDetailImpl();
                String url = node1.selectSingleNode("@href").getStringValue();
                url = this.makeAbsoluteURL(url);
                detail.setId(this.stringNodeValue(node1, "@id", null));
                try {
                    detail.setStatus(ExecutionState.valueOf(this.stringNodeValue(node1, "@status", null)));
                }
                catch (IllegalArgumentException e) {
                    // empty catch block
                }
                detail.setUrl(url);
                detail.setUser(this.stringNodeValue(node1, "user", null));
                detail.setAbortedBy(this.stringNodeValue(node1, "abortedBy", null));
                detail.setDescription(this.stringNodeValue(node1, "description", null));
                detail.setArgString(this.stringNodeValue(node1, "argString", null));
                detail.setDateStarted(this.w3cDateNodeValue(node1, "date-started", null));
                detail.setDateCompleted(this.w3cDateNodeValue(node1, "date-started", null));
                Node jobNode = node1.selectSingleNode("job");
                if (null != jobNode) {
                    String jobId = this.stringNodeValue(jobNode, "@id", null);
                    StoredJobExecutionImpl job = new StoredJobExecutionImpl(jobId, this.stringNodeValue(jobNode, "name", null), this.createJobURL(jobId), this.stringNodeValue(jobNode, "group", null), this.stringNodeValue(jobNode, "description", null), this.stringNodeValue(jobNode, "project", null), this.longNodeValue(jobNode, "@averageDuration", -1L));
                    detail.setExecutionJob(job);
                }
                list.add(detail);
            }
        }
        return list;
    }

    private ArrayList<QueuedItem> parseExecutionListResult(WebserviceResponse response) {
        Document resultDoc = response.getResultDoc();
        Node node = resultDoc.selectSingleNode("/result/executions");
        List items = node.selectNodes("execution");
        ArrayList<QueuedItem> list = new ArrayList<QueuedItem>();
        if (null != items && items.size() > 0) {
            for (Object o : items) {
                Node node1 = (Node)o;
                String id = node1.selectSingleNode("@id").getStringValue();
                Node jobname = node1.selectSingleNode("job/name");
                Node desc = node1.selectSingleNode("description");
                String name = null != jobname ? jobname.getStringValue() : desc.getStringValue();
                String url = node1.selectSingleNode("@href").getStringValue();
                url = this.makeAbsoluteURL(url);
                logger.info((Object)("\t: " + name + " [" + id + "] <" + url + ">"));
                list.add(QueuedItemResultImpl.createQueuedItem(id, url, name));
            }
        }
        return list;
    }

    String makeAbsoluteURL(String url) {
        if (null != url && url.startsWith("/")) {
            try {
                URL serverUrl = new URL(this.serverService.getConnParams().getServerUrl());
                URL newUrl = new URL(serverUrl, url);
                url = newUrl.toExternalForm();
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
        }
        return url;
    }

    String makeContextAbsoluteURL(String url) {
        if (null != url && url.startsWith("/")) {
            try {
                URL newUrl = new URL(this.serverService.getConnParams().getServerUrl() + url);
                url = newUrl.toExternalForm();
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
        }
        return url;
    }

    private void validateJobsResponse(WebserviceResponse response) throws CentralDispatcherServerRequestException {
        Document resultDoc;
        if (null == response) {
            throw new CentralDispatcherServerRequestException("Response was null");
        }
        if (null != response.getResponseMessage()) {
            logger.info((Object)("Response: " + response.getResponseMessage()));
        }
        if (null == (resultDoc = response.getResultDoc())) {
            throw new CentralDispatcherServerRequestException("Response content unexpectedly empty");
        }
        try {
            logger.debug((Object)RundeckAPICentralDispatcher.serialize(resultDoc));
        }
        catch (IOException e) {
            logger.debug((Object)"ioexception serializing result doc", (Throwable)e);
        }
        if (!"joblist".equals(resultDoc.getRootElement().getName())) {
            throw new CentralDispatcherServerRequestException("Response had unexpected content: " + resultDoc);
        }
    }

    private Envelope validateResponse(WebserviceResponse response) throws CentralDispatcherException {
        Document resultDoc;
        if (null == response) {
            throw new CentralDispatcherServerRequestException("Response was null");
        }
        if (null != response.getResponseMessage()) {
            logger.debug((Object)("Response: " + response.getResponseMessage()));
        }
        if (null == (resultDoc = response.getResultDoc())) {
            throw new CentralDispatcherServerRequestException("Response content unexpectedly empty. " + (response.getResponseMessage() != null ? response.getResponseMessage() : ""));
        }
        try {
            logger.debug((Object)RundeckAPICentralDispatcher.serialize(resultDoc));
        }
        catch (IOException e) {
            logger.debug((Object)"ioexception serializing result doc", (Throwable)e);
        }
        if (!"result".equals(resultDoc.getRootElement().getName())) {
            throw new CentralDispatcherServerRequestException("Response had unexpected content: " + resultDoc);
        }
        Envelope envelope = new Envelope(response.getResultDoc());
        if (envelope.isErrorResult()) {
            StringBuffer sb = new StringBuffer();
            StringBuffer buffer = envelope.errorMessages();
            if (buffer.length() > 0) {
                sb.append(buffer);
            } else {
                sb.append("Server reported an error");
                if (null != response.getResponseMessage()) {
                    sb.append(": ").append(response.getResponseMessage());
                }
            }
            if (null != response.getResponseMessage()) {
                logger.error((Object)("Server reported an error: " + response.getResponseMessage()));
            } else {
                logger.error((Object)"Server reported an error.");
            }
            throw new CentralDispatcherFailureResponseException(sb.toString());
        }
        return envelope;
    }

    private void checkErrorResponse(WebserviceResponse response) throws CentralDispatcherException {
        Document resultDoc;
        if (null == response) {
            throw new CentralDispatcherServerRequestException("Response was null");
        }
        if (null != response.getResponseMessage()) {
            logger.info((Object)("Response: " + response.getResponseMessage()));
        }
        if (null == (resultDoc = response.getResultDoc())) {
            return;
        }
        try {
            logger.debug((Object)RundeckAPICentralDispatcher.serialize(resultDoc));
        }
        catch (IOException e) {
            logger.debug((Object)"ioexception serializing result doc", (Throwable)e);
        }
        if (!"result".equals(resultDoc.getRootElement().getName())) {
            return;
        }
        Envelope envelope = new Envelope(response.getResultDoc());
        if (envelope.isErrorResult()) {
            StringBuffer sb = new StringBuffer();
            StringBuffer buffer = envelope.errorMessages();
            if (buffer.length() > 0) {
                sb.append(buffer);
            } else {
                sb.append("Server reported an error");
                if (null != response.getResponseMessage()) {
                    sb.append(": ").append(response.getResponseMessage());
                }
            }
            if (null != response.getResponseMessage()) {
                logger.error((Object)("Server reported an error: " + response.getResponseMessage()));
            } else {
                logger.error((Object)"Server reported an error.");
            }
            throw new CentralDispatcherFailureResponseException(sb.toString());
        }
    }

    @Override
    public DispatcherResult killDispatcherExecution(String execId) throws CentralDispatcherException {
        WebserviceResponse response;
        HashMap params = new HashMap();
        String rundeckApiKillJobPath = RundeckAPICentralDispatcher.substitutePathVariable(RUNDECK_API_KILL_JOB_PATH, "id", execId);
        try {
            response = this.serverService.makeRundeckRequest(rundeckApiKillJobPath, params, null, null, null);
        }
        catch (MalformedURLException e) {
            throw new CentralDispatcherServerRequestException("Failed to make request", e);
        }
        Envelope envelope = this.validateResponse(response);
        Node result1 = envelope.doc.selectSingleNode("result");
        String abortStatus = result1.selectSingleNode("abort/@status").getStringValue();
        final boolean result = !"failed".equals(abortStatus);
        final StringBuffer sb = envelope.successMessages();
        return new DispatcherResult(){

            @Override
            public boolean isSuccessful() {
                return result;
            }

            @Override
            public String getMessage() {
                return sb.toString();
            }
        };
    }

    @Override
    public ExecutionDetail getExecution(String execId) throws CentralDispatcherException {
        WebserviceResponse response;
        HashMap params = new HashMap();
        String rundeckApiKillJobPath = RundeckAPICentralDispatcher.substitutePathVariable(RUNDECK_API_EXECUTION_PATH, "id", execId);
        try {
            response = this.serverService.makeRundeckRequest(rundeckApiKillJobPath, params, null, null, null);
        }
        catch (MalformedURLException e) {
            throw new CentralDispatcherServerRequestException("Failed to make request", e);
        }
        Envelope envelope = this.validateResponse(response);
        List<ExecutionDetail> details = this.parseExecutionsResult(response);
        if (details.size() != 1) {
            throw new CentralDispatcherException("The results were unexpected: did not contain 1 execution definition");
        }
        ExecutionDetail detail = details.get(0);
        return detail;
    }

    @Override
    public ExecutionFollowResult followDispatcherExecution(String execId, ExecutionFollowRequest request, ExecutionFollowReceiver receiver) throws CentralDispatcherException {
        String rundeckApiExecOutputJobPath = RundeckAPICentralDispatcher.substitutePathVariable(RUNDECK_API_EXEC_OUTPUT_PATH, "id", execId) + ".xml";
        boolean complete = false;
        boolean interrupt = false;
        boolean receiverfinished = false;
        boolean jobsuccess = false;
        boolean jobcomplete = false;
        boolean jobcancel = false;
        Long offset = 0L;
        Long rlastmod = 0L;
        boolean resume = null != request && request.isResume();
        double percentage = 0.0;
        int BASE_DELAY = 1000;
        int MAX_DELAY = 5000;
        long delay = 1000L;
        float backoff = 1.0f;
        String jobstatus = null;
        while (!(complete || interrupt || receiverfinished)) {
            WebserviceResponse response;
            HashMap<String, String> params = new HashMap<String, String>();
            if (resume) {
                params.put("lastlines", "0");
                resume = false;
            } else {
                params.put("offset", offset.toString());
                params.put("lastmod", rlastmod.toString());
            }
            params.put("maxlines", "500");
            logger.debug((Object)("request" + rundeckApiExecOutputJobPath + " params: " + params));
            try {
                response = this.serverService.makeRundeckRequest(rundeckApiExecOutputJobPath, params, null, null, null);
            }
            catch (MalformedURLException e) {
                throw new CentralDispatcherServerRequestException("Failed to make request", e);
            }
            Envelope envelope = this.validateResponse(response);
            Node result1 = envelope.doc.selectSingleNode("result/output");
            if (null == result1) {
                throw new CentralDispatcherServerRequestException("Response output was unexpected");
            }
            String errorStr = this.stringNodeValue(result1, "error", null);
            String messageStr = this.stringNodeValue(result1, "message", null);
            Boolean unmodified = this.boolNodeValue(result1, "unmodified", null);
            Boolean empty = this.boolNodeValue(result1, "empty", null);
            Boolean iscompleted = this.boolNodeValue(result1, "completed", null);
            Boolean jobcompleted = this.boolNodeValue(result1, "execCompleted", null);
            jobstatus = this.stringNodeValue(result1, "execState", null);
            Long lastmod = this.longNodeValue(result1, "lastModified", 0L);
            Long duration = this.longNodeValue(result1, "execDuration", 0L);
            Long totalsize = this.longNodeValue(result1, "totalSize", 0L);
            Double percentLoaded = this.floatNodeValue(result1, "percentLoaded", 0.0);
            Long dataoffset = this.longNodeValue(result1, "offset", -1L);
            if (dataoffset > 0L && dataoffset > offset) {
                offset = dataoffset;
            }
            if (lastmod > 0L && lastmod > rlastmod) {
                rlastmod = lastmod;
            }
            if (percentLoaded > 0.0 && percentLoaded > percentage) {
                percentage = percentLoaded;
            }
            if (null != unmodified && unmodified.booleanValue() && delay < 5000L) {
                delay += (long)Math.round(backoff * 1000.0f);
            } else if (null != unmodified && !unmodified.booleanValue()) {
                delay = 1000L;
            }
            if (null != iscompleted) {
                complete = iscompleted;
            }
            if (null != receiver && !receiver.receiveFollowStatus(offset, totalsize, duration)) {
                receiverfinished = true;
                break;
            }
            List list = result1.selectNodes("entries/entry");
            for (Object obj : list) {
                Node node = (Node)obj;
                String timeStr = this.stringNodeValue(node, "@time", null);
                String levelStr = this.stringNodeValue(node, "@level", null);
                String user = this.stringNodeValue(node, "@user", null);
                String command = this.stringNodeValue(node, "@command", null);
                String nodeName = this.stringNodeValue(node, "@node", null);
                String logMessage = node.getStringValue();
                if (null == receiver || receiver.receiveLogEntry(timeStr, levelStr, user, command, nodeName, logMessage)) continue;
                receiverfinished = true;
                break;
            }
            try {
                Thread.sleep(delay);
            }
            catch (InterruptedException e) {
                interrupt = true;
            }
        }
        final boolean finalComplete = complete;
        final boolean finalReceiverfinished = receiverfinished;
        ExecutionState state = null;
        if (null != jobstatus) {
            try {
                state = ExecutionState.valueOf(jobstatus);
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
        }
        final ExecutionState finalState = state;
        return new ExecutionFollowResult(){

            @Override
            public boolean isLogComplete() {
                return finalComplete;
            }

            @Override
            public ExecutionState getState() {
                return finalState;
            }

            @Override
            public boolean isReceiverFinished() {
                return finalReceiverfinished;
            }
        };
    }

    private String stringNodeValue(Node result1, String path, String defValue) {
        return null != result1.selectSingleNode(path) ? result1.selectSingleNode(path).getStringValue() : defValue;
    }

    private Boolean boolNodeValue(Node result1, String path, Boolean defValue) {
        if (null != result1.selectSingleNode(path)) {
            return Boolean.parseBoolean(result1.selectSingleNode(path).getStringValue());
        }
        return defValue;
    }

    private double floatNodeValue(Node result1, String path, double defValue) {
        if (null != result1.selectSingleNode(path)) {
            try {
                Float.parseFloat(result1.selectSingleNode(path).getStringValue());
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return defValue;
    }

    private long longNodeValue(Node result1, String path, long defValue) {
        if (null != result1.selectSingleNode(path)) {
            try {
                return Long.parseLong(result1.selectSingleNode(path).getStringValue());
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return defValue;
    }

    private Date w3cDateNodeValue(Node result1, String path, Date defValue) {
        if (null != result1.selectSingleNode(path)) {
            String stringValue = result1.selectSingleNode(path).getStringValue();
            try {
                return w3cDateFormat.parse(stringValue);
            }
            catch (ParseException e) {
                // empty catch block
            }
        }
        return defValue;
    }

    public static String substitutePathVariable(String path, String var, String value) throws CentralDispatcherException {
        String encoded;
        try {
            encoded = URIUtil.encodeWithinPath((String)value);
        }
        catch (URIException e) {
            throw new CentralDispatcherException(e);
        }
        return path.replace("$" + var, encoded);
    }

    private String createJobURL(String id) {
        return this.makeContextAbsoluteURL(RUNDECK_JOB_LINK_PREFIX + id);
    }

    private String createExecutionURL(String id) {
        return this.makeContextAbsoluteURL(RUNDECK_EXEC_LINK_PREFIX + id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<IStoredJob> listStoredJobs(IStoredJobsQuery iStoredJobsQuery, OutputStream output, JobDefinitionFileFormat fformat) throws CentralDispatcherException {
        WebserviceResponse response;
        String expectedContentType;
        HashMap<String, String> params = new HashMap<String, String>();
        String nameMatch = iStoredJobsQuery.getNameMatch();
        String groupMatch = iStoredJobsQuery.getGroupMatch();
        String projectFilter = iStoredJobsQuery.getProjectFilter();
        String idlistFilter = iStoredJobsQuery.getIdlist();
        if (null != fformat) {
            params.put("format", fformat.getName());
            expectedContentType = fformat == JobDefinitionFileFormat.xml ? "text/xml" : "text/yaml";
        } else {
            params.put("format", JobDefinitionFileFormat.xml.getName());
            expectedContentType = "text/xml";
        }
        if (null != nameMatch) {
            params.put("jobFilter", nameMatch);
        }
        if (null != groupMatch) {
            Matcher matcher = Pattern.compile("^/*(.+?)/*$").matcher(groupMatch);
            if (matcher.matches()) {
                groupMatch = matcher.group(1);
            }
            params.put("groupPath", groupMatch);
        }
        if (null != projectFilter) {
            params.put("project", projectFilter);
        }
        if (null != idlistFilter) {
            params.put("idlist", idlistFilter);
        }
        try {
            response = this.serverService.makeRundeckRequest(RUNDECK_API_JOBS_EXPORT_PATH, params, null, null, expectedContentType, null);
        }
        catch (MalformedURLException e) {
            throw new CentralDispatcherServerRequestException("Failed to make request", e);
        }
        this.checkErrorResponse(response);
        if (null == fformat || fformat == JobDefinitionFileFormat.xml) {
            this.validateJobsResponse(response);
            Document resultDoc = response.getResultDoc();
            Node node = resultDoc.selectSingleNode("/joblist");
            ArrayList<IStoredJob> list = new ArrayList<IStoredJob>();
            if (null == node) {
                return list;
            }
            List items = node.selectNodes("job");
            if (null != items && items.size() > 0) {
                for (Object o : items) {
                    Node node1 = (Node)o;
                    Node uuid = node1.selectSingleNode("uuid");
                    Node id1 = node1.selectSingleNode("id");
                    String id = null != uuid ? uuid.getStringValue() : id1.getStringValue();
                    String name = node1.selectSingleNode("name").getStringValue();
                    String url = this.createJobURL(id);
                    Node gnode = node1.selectSingleNode("group");
                    String group = null != gnode ? gnode.getStringValue() : null;
                    String description = node1.selectSingleNode("description").getStringValue();
                    list.add(StoredJobImpl.create(id, name, url, group, description, projectFilter));
                }
            }
            if (null != output) {
                OutputFormat format = OutputFormat.createPrettyPrint();
                try {
                    XMLWriter writer = new XMLWriter(output, format);
                    writer.write(resultDoc);
                    writer.flush();
                }
                catch (IOException e) {
                    throw new CentralDispatcherServerRequestException(e);
                }
            }
            return list;
        }
        if (fformat == JobDefinitionFileFormat.yaml) {
            Collection<Map> mapCollection;
            FileInputStream tempIn;
            File temp;
            try {
                temp = File.createTempFile("listStoredJobs", ".yaml");
                temp.deleteOnExit();
                FileOutputStream os = new FileOutputStream(temp);
                try {
                    Streams.copyStream(response.getResultStream(), os);
                }
                finally {
                    ((OutputStream)os).close();
                }
                tempIn = new FileInputStream(temp);
                try {
                    mapCollection = this.validateJobsResponseYAML(response, tempIn);
                }
                finally {
                    ((InputStream)tempIn).close();
                }
            }
            catch (IOException e) {
                throw new CentralDispatcherServerRequestException(e);
            }
            ArrayList<IStoredJob> list = new ArrayList<IStoredJob>();
            if (null == mapCollection || mapCollection.size() < 1) {
                return list;
            }
            for (Map map : mapCollection) {
                Object uuidobj = map.get("uuid");
                Object idobj = map.get("id");
                String id = null != uuidobj ? uuidobj.toString() : idobj.toString();
                String name = (String)map.get("name");
                String group = map.containsKey("group") ? (String)map.get("group") : null;
                String desc = map.containsKey("description") ? (String)map.get("description") : "";
                String url = this.createJobURL(id);
                list.add(StoredJobImpl.create(id, name, url, group, desc, projectFilter));
            }
            if (null != output) {
                try {
                    tempIn = new FileInputStream(temp);
                    try {
                        Streams.copyStream(tempIn, output);
                    }
                    finally {
                        ((InputStream)tempIn).close();
                    }
                    temp.delete();
                }
                catch (IOException e) {
                    throw new CentralDispatcherServerRequestException(e);
                }
            }
            return list;
        }
        return null;
    }

    @Override
    public Collection<DeleteJobResult> deleteStoredJobs(Collection<String> jobIds) throws CentralDispatcherException {
        DeleteJobResult storedJobLoadResult;
        Node node1;
        List nodes;
        WebserviceResponse response;
        HashMap<String, Collection<String>> params = new HashMap<String, Collection<String>>();
        params.put("ids", jobIds);
        try {
            response = this.serverService.makeRundeckRequest(RUNDECK_API_JOBS_BULK_DELETE_PATH, null, params);
        }
        catch (MalformedURLException e) {
            throw new CentralDispatcherServerRequestException("Failed to make request", e);
        }
        this.checkErrorResponse(response);
        Document result = response.getResultDoc();
        Node node = result.selectSingleNode("/result/deleteJobs/succeeded/@count");
        int succeeded = null != node ? Integer.parseInt(node.getStringValue()) : -1;
        node = result.selectSingleNode("/result/deleteJobs/failed/@count");
        int failed = null != node ? Integer.parseInt(node.getStringValue()) : -1;
        ArrayList<DeleteJobResult> resultList = new ArrayList<DeleteJobResult>();
        if (succeeded > 0) {
            logger.debug((Object)("Succeeded deleting " + succeeded + " Jobs:"));
            nodes = result.selectNodes("/result/deleteJobs/succeeded/deleteJobResult");
            for (Object node2 : nodes) {
                node1 = (Node)node2;
                String message = null != node1.selectSingleNode("message") ? node1.selectSingleNode("message").getStringValue() : "Succeeded";
                storedJobLoadResult = this.parseAPIJobDeleteResult(node1, true, message);
                resultList.add(storedJobLoadResult);
            }
        }
        if (failed > 0) {
            logger.debug((Object)("Failed to delete " + failed + " Jobs:"));
            nodes = result.selectNodes("/result/deleteJobs/failed/deleteJobResult");
            for (Object node2 : nodes) {
                node1 = (Node)node2;
                String error = null != node1.selectSingleNode("error") ? node1.selectSingleNode("error").getStringValue() : "Failed";
                storedJobLoadResult = this.parseAPIJobDeleteResult(node1, false, error);
                resultList.add(storedJobLoadResult);
            }
        }
        return resultList;
    }

    public Collection<IStoredJob> reallistStoredJobs(IStoredJobsQuery iStoredJobsQuery) throws CentralDispatcherException {
        WebserviceResponse response;
        HashMap<String, String> params = new HashMap<String, String>();
        String nameMatch = iStoredJobsQuery.getNameMatch();
        String groupMatch = iStoredJobsQuery.getGroupMatch();
        String projectFilter = iStoredJobsQuery.getProjectFilter();
        String idlistFilter = iStoredJobsQuery.getIdlist();
        if (null != nameMatch) {
            params.put("jobExactFilter", nameMatch);
        }
        if (null != groupMatch) {
            Matcher matcher = Pattern.compile("^/*(.+?)/*$").matcher(groupMatch);
            if (matcher.matches()) {
                groupMatch = matcher.group(1);
            }
            params.put("groupPathExact", groupMatch);
        }
        if (null != projectFilter) {
            params.put("project", projectFilter);
        }
        if (null != idlistFilter) {
            params.put("idlist", idlistFilter);
        }
        try {
            response = this.serverService.makeRundeckRequest(RUNDECK_API_JOBS_LIST_PATH, params, null, null, null);
        }
        catch (MalformedURLException e) {
            throw new CentralDispatcherServerRequestException("Failed to make request", e);
        }
        this.validateResponse(response);
        Document resultDoc = response.getResultDoc();
        ArrayList<IStoredJob> list = new ArrayList<IStoredJob>();
        Node jobs = resultDoc.selectSingleNode("/result/jobs");
        for (Object job1 : jobs.selectNodes("job")) {
            Node job = (Node)job1;
            String id = job.selectSingleNode("@id").getStringValue();
            String name = job.selectSingleNode("name").getStringValue();
            String group = job.selectSingleNode("group").getStringValue();
            String desc = job.selectSingleNode("description").getStringValue();
            String url = this.createJobURL(id);
            list.add(StoredJobImpl.create(id, name, url, group, desc, projectFilter));
        }
        return list;
    }

    private Collection<Map> validateJobsResponseYAML(WebserviceResponse response, InputStream resultStream) throws CentralDispatcherServerRequestException {
        Object resobj;
        String resultContentType;
        if (null == response) {
            throw new CentralDispatcherServerRequestException("Response was null");
        }
        if (null != response.getResponseMessage()) {
            logger.info((Object)("Response: " + response.getResponseMessage()));
        }
        if ((resultContentType = response.getResultContentType()).contains(";")) {
            resultContentType = resultContentType.substring(0, resultContentType.indexOf(";"));
        }
        if (!resultContentType.endsWith("/yaml")) {
            throw new CentralDispatcherServerRequestException("Expected YAML response, unexpected content type: " + response.getResultContentType());
        }
        ArrayList<Map> dataset = new ArrayList<Map>();
        try {
            Yaml yaml = new Yaml((BaseConstructor)new SafeConstructor());
            resobj = yaml.load(resultStream);
        }
        catch (YAMLException e) {
            throw new CentralDispatcherServerRequestException("Failed to parse YAML: " + e.getMessage(), (Exception)((Object)e));
        }
        if (!(resobj instanceof Collection)) {
            throw new CentralDispatcherServerRequestException("Response had unexpected content type: " + resobj);
        }
        dataset.addAll((Collection)resobj);
        for (Map map : dataset) {
            if (map.containsKey("name") && (map.containsKey("id") || map.containsKey("uuid"))) continue;
            throw new CentralDispatcherServerRequestException("Response had unexpected dataset: " + resobj);
        }
        return dataset;
    }

    @Override
    public QueuedItemResult queueDispatcherJob(IDispatchedJob dispatchedJob) throws CentralDispatcherException {
        String jobid;
        HashMap<String, String> params = new HashMap<String, String>();
        if (null == dispatchedJob.getJobRef()) {
            throw new IllegalArgumentException("JobRef was null");
        }
        if (null != dispatchedJob.getJobRef().getJobId()) {
            jobid = dispatchedJob.getJobRef().getJobId();
        } else {
            String group;
            if (null == dispatchedJob.getJobRef().getName() || "".equals(dispatchedJob.getJobRef().getName())) {
                throw new CentralDispatcherException("job name input is required");
            }
            String project = dispatchedJob.getJobRef().getProject();
            String name = dispatchedJob.getJobRef().getName();
            Collection<IStoredJob> iStoredJobs = this.reallistStoredJobs(new IStoredJobsQueryImpl(name, group = null != dispatchedJob.getJobRef().getGroup() && !"".equals(dispatchedJob.getJobRef().getGroup()) ? dispatchedJob.getJobRef().getGroup() : "-", null, project));
            if (null == iStoredJobs) {
                throw new CentralDispatcherException("Unable to query jobs");
            }
            if (iStoredJobs.size() < 1) {
                throw new CentralDispatcherException("Job not found matching query: " + (null != group ? group : "") + "/" + name);
            }
            if (iStoredJobs.size() > 1) {
                ArrayList<String> ids = new ArrayList<String>();
                for (IStoredJob iStoredJob : iStoredJobs) {
                    ids.add(iStoredJob.getJobId());
                }
                throw new CentralDispatcherException("Job was not unique: " + (null != group ? group : "") + "/" + name + ": " + iStoredJobs.size() + " jobs found: " + ids);
            }
            IStoredJob next = iStoredJobs.iterator().next();
            jobid = next.getJobId();
        }
        RundeckAPICentralDispatcher.addAPINodeSetParams(params, dispatchedJob.isKeepgoing(), dispatchedJob.getNodeFilter(), dispatchedJob.getNodeThreadcount(), dispatchedJob.getNodeExcludePrecedence());
        this.addLoglevelParams(params, dispatchedJob.getLoglevel());
        if (null != dispatchedJob.getArgs() && dispatchedJob.getArgs().length > 0) {
            params.put("argString", OptsUtil.join(dispatchedJob.getArgs()));
        }
        String apipath = RundeckAPICentralDispatcher.substitutePathVariable(RUNDECK_API_JOBS_RUN, "id", jobid);
        return this.submitExecutionRequest(null, params, apipath);
    }

    private void addLoglevelParams(Map<String, String> params, int loglevel) {
        String loglevelstr = "INFO".toUpperCase();
        switch (loglevel) {
            case 4: {
                loglevelstr = "DEBUG".toUpperCase();
                break;
            }
            case 3: {
                loglevelstr = "VERBOSE".toUpperCase();
                break;
            }
            case 2: {
                loglevelstr = "INFO".toUpperCase();
                break;
            }
            case 1: {
                loglevelstr = "WARN".toUpperCase();
                break;
            }
            case 0: {
                loglevelstr = "ERR".toUpperCase();
            }
        }
        params.put("loglevel", loglevelstr);
    }

    public static void addAPINodeSetParams(HashMap<String, String> params, Boolean isKeepgoing, String nodeFilter, int threadcount, Boolean excludePrecedence) {
        if (null != nodeFilter && !"".equals(nodeFilter.trim())) {
            params.put("filter", nodeFilter);
            if (null != excludePrecedence) {
                params.put("exclude-precedence", Boolean.toString(excludePrecedence));
            }
        }
        if (threadcount > 0) {
            params.put("nodeThreadcount", Integer.toString(threadcount));
        }
        if (null != isKeepgoing) {
            params.put("nodeKeepgoing", Boolean.toString(isKeepgoing));
        }
    }

    @Override
    public Collection<IStoredJobLoadResult> loadJobs(ILoadJobsRequest iLoadJobsRequest, File input, JobDefinitionFileFormat format) throws CentralDispatcherException {
        IStoredJobLoadResult storedJobLoadResult;
        String error;
        Node node1;
        List nodes;
        WebserviceResponse response;
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("dupeOption", iLoadJobsRequest.getDuplicateOption().toString());
        if (null != format) {
            params.put("format", format.getName());
        }
        if (null != iLoadJobsRequest.getProject()) {
            params.put("project", iLoadJobsRequest.getProject());
        }
        if (null != iLoadJobsRequest.getUUIDOption()) {
            params.put("uuidOption", iLoadJobsRequest.getUUIDOption().toString());
        }
        try {
            response = this.serverService.makeRundeckRequest(RUNDECK_API_JOBS_UPLOAD, params, input, null, "xmlBatch");
        }
        catch (MalformedURLException e) {
            throw new CentralDispatcherServerRequestException("Failed to make request", e);
        }
        this.validateResponse(response);
        Document result = response.getResultDoc();
        Node node = result.selectSingleNode("/result/succeeded/@count");
        int succeeded = null != node ? Integer.parseInt(node.getStringValue()) : -1;
        node = result.selectSingleNode("/result/failed/@count");
        int failed = null != node ? Integer.parseInt(node.getStringValue()) : -1;
        node = result.selectSingleNode("/result/skipped/@count");
        int skipped = null != node ? Integer.parseInt(node.getStringValue()) : -1;
        ArrayList<IStoredJobLoadResult> resultList = new ArrayList<IStoredJobLoadResult>();
        if (succeeded > 0) {
            logger.debug((Object)("Succeeded creating/updating " + succeeded + " Jobs:"));
            nodes = result.selectNodes("/result/succeeded/job");
            for (Object node2 : nodes) {
                node1 = (Node)node2;
                IStoredJobLoadResult storedJobLoadResult2 = this.parseAPIJobResult(node1, true, false, "Succeeded");
                resultList.add(storedJobLoadResult2);
            }
        }
        if (failed > 0) {
            logger.debug((Object)("Failed to add " + failed + " Jobs:"));
            nodes = result.selectNodes("/result/failed/job");
            for (Object node2 : nodes) {
                node1 = (Node)node2;
                error = null != node1.selectSingleNode("error") ? node1.selectSingleNode("error").getStringValue() : "Failed";
                storedJobLoadResult = this.parseAPIJobResult(node1, false, false, error);
                resultList.add(storedJobLoadResult);
            }
        }
        if (skipped > 0) {
            logger.debug((Object)("Skipped " + skipped + " Jobs:"));
            nodes = result.selectNodes("/result/skipped/job");
            for (Object node2 : nodes) {
                node1 = (Node)node2;
                error = null != node1.selectSingleNode("error") ? node1.selectSingleNode("error").getStringValue() : "Skipped";
                storedJobLoadResult = this.parseAPIJobResult(node1, true, true, error);
                resultList.add(storedJobLoadResult);
            }
        }
        return resultList;
    }

    private DeleteJobResult parseAPIJobDeleteResult(Node node1, boolean successful, String message) {
        Node idNode = node1.selectSingleNode("@id");
        String id = null != idNode ? idNode.getStringValue() : null;
        Node codeNode = node1.selectSingleNode("errorCode");
        String errorCode = null != codeNode ? codeNode.getStringValue() : null;
        logger.debug((Object)("\t[" + id + "] " + message));
        return DeleteJobResultImpl.createDeleteJobResultImpl(successful, message, id, errorCode);
    }

    private IStoredJobLoadResult parseAPIJobResult(Node node1, boolean successful, boolean skippedJob, String message) {
        Node uuidNode = node1.selectSingleNode("uuid");
        Node idNode = node1.selectSingleNode("id");
        String id = null != uuidNode ? uuidNode.getStringValue() : (null != idNode ? idNode.getStringValue() : null);
        String name = node1.selectSingleNode("name").getStringValue();
        String url = null != id ? this.createJobURL(id) : null;
        String group = null != node1.selectSingleNode("group") ? node1.selectSingleNode("group").getStringValue() : null;
        String description = null != node1.selectSingleNode("description") ? node1.selectSingleNode("description").getStringValue() : null;
        String project = null != node1.selectSingleNode("project") ? node1.selectSingleNode("project").getStringValue() : null;
        logger.debug((Object)("\t" + name + " [" + id + "] <" + url + "> (" + project + ")"));
        return StoredJobLoadResultImpl.createLoadResult(id, name, url, group, description, project, successful, skippedJob, message);
    }

    private static String serialize(Document document) throws IOException {
        OutputFormat format = OutputFormat.createPrettyPrint();
        StringWriter sw = new StringWriter();
        XMLWriter writer = new XMLWriter((Writer)sw, format);
        writer.write(document);
        writer.flush();
        sw.flush();
        return sw.toString();
    }

    private static class Envelope {
        private Document doc;

        public Envelope(Document doc) {
            this.doc = doc;
        }

        public boolean isErrorResult() {
            Node node = this.doc.selectSingleNode("/result/@error");
            return null != node && "true".equals(node.getText());
        }

        public boolean isSuccessResult() {
            Node node = this.doc.selectSingleNode("/result/@success");
            return null == node || "true".equals(node.getText());
        }

        public StringBuffer successMessages() {
            return this.readMessages("/result/success/message");
        }

        public StringBuffer errorMessages() {
            return this.readMessages("/result/error/message");
        }

        private StringBuffer readMessages(String xpath) {
            StringBuffer sb = new StringBuffer();
            List errs = this.doc.selectNodes(xpath);
            if (null != errs) {
                for (Object err : errs) {
                    Node node = (Node)err;
                    if (sb.length() > 0) {
                        sb.append("\n");
                    }
                    sb.append(node.getStringValue());
                    logger.error((Object)("\t" + node.getStringValue()));
                }
            }
            return sb;
        }
    }
}

