/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.cli;

import com.dtolabs.rundeck.core.cli.CLIToolLogger;
import com.dtolabs.rundeck.core.execution.ExecutionListenerOverride;
import com.dtolabs.rundeck.core.execution.ExecutionListenerOverrideBase;
import com.dtolabs.rundeck.core.execution.FailedNodesListener;
import java.util.Map;

public class CLIExecutionListener
extends ExecutionListenerOverrideBase {
    private CLIToolLogger logger;
    private int loglevel;
    private CLIExecutionListener delegate;

    private CLIExecutionListener(CLIExecutionListener delegate) {
        super(delegate);
        this.delegate = delegate;
    }

    public CLIExecutionListener(FailedNodesListener failedNodesListener, CLIToolLogger logger, int loglevel) {
        super(failedNodesListener, false, null);
        this.logger = logger;
        this.loglevel = loglevel;
    }

    public CLIExecutionListener(FailedNodesListener failedNodesListener, CLIToolLogger logger, int loglevel, boolean terse) {
        super(failedNodesListener, terse, null);
        this.logger = logger;
        this.loglevel = loglevel;
    }

    public CLIExecutionListener(FailedNodesListener failedNodesListener, CLIToolLogger logger, int loglevel, boolean terse, String logFormat) {
        super(failedNodesListener, terse, logFormat);
        this.logger = logger;
        this.loglevel = loglevel;
    }

    private boolean shouldlog(int level) {
        return level <= this.loglevel;
    }

    @Override
    public void log(int level, String message) {
        if (null != this.delegate) {
            this.delegate.log(level, message);
            return;
        }
        if (this.shouldlog(level)) {
            if (level >= 4) {
                this.logger.verbose(message);
            } else if (level >= 3) {
                this.logger.verbose(message);
            } else if (level >= 2) {
                this.logger.log(message);
            } else if (level >= 1) {
                this.logger.warn(message);
            } else if (level >= 0) {
                this.logger.error(message);
            } else {
                this.logger.log(message);
            }
        }
    }

    @Override
    public void event(String eventType, String message, Map eventMeta) {
        this.logger.debug("event[" + eventType + "] " + message);
    }

    @Override
    public ExecutionListenerOverride createOverride() {
        return new CLIExecutionListener(this);
    }
}

