/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.common;

import com.dtolabs.rundeck.core.Constants;
import com.dtolabs.rundeck.core.CoreException;
import com.dtolabs.rundeck.core.authorization.Attribute;
import com.dtolabs.rundeck.core.authorization.AuthContext;
import com.dtolabs.rundeck.core.authorization.Decision;
import com.dtolabs.rundeck.core.common.FrameworkProject;
import com.dtolabs.rundeck.core.common.FrameworkProjectMgr;
import com.dtolabs.rundeck.core.common.FrameworkResourceException;
import com.dtolabs.rundeck.core.common.FrameworkResourceParent;
import com.dtolabs.rundeck.core.common.FrameworkSupportService;
import com.dtolabs.rundeck.core.common.IFrameworkProjectMgr;
import com.dtolabs.rundeck.core.common.IFrameworkResource;
import com.dtolabs.rundeck.core.common.IFrameworkResourceParent;
import com.dtolabs.rundeck.core.common.INodeDesc;
import com.dtolabs.rundeck.core.common.INodeEntry;
import com.dtolabs.rundeck.core.common.INodeSet;
import com.dtolabs.rundeck.core.common.NodeEntryImpl;
import com.dtolabs.rundeck.core.common.NodeFileParserException;
import com.dtolabs.rundeck.core.common.NodeFilter;
import com.dtolabs.rundeck.core.common.NodeSetImpl;
import com.dtolabs.rundeck.core.common.NodesSelector;
import com.dtolabs.rundeck.core.common.PropertyRetriever;
import com.dtolabs.rundeck.core.dispatcher.CentralDispatcher;
import com.dtolabs.rundeck.core.dispatcher.CentralDispatcherException;
import com.dtolabs.rundeck.core.dispatcher.CentralDispatcherMgrFactory;
import com.dtolabs.rundeck.core.execution.ExecutionContext;
import com.dtolabs.rundeck.core.execution.ExecutionService;
import com.dtolabs.rundeck.core.execution.ExecutionServiceFactory;
import com.dtolabs.rundeck.core.execution.dispatch.NodeDispatcher;
import com.dtolabs.rundeck.core.execution.dispatch.NodeDispatcherService;
import com.dtolabs.rundeck.core.execution.service.ExecutionServiceException;
import com.dtolabs.rundeck.core.execution.service.FileCopier;
import com.dtolabs.rundeck.core.execution.service.FileCopierService;
import com.dtolabs.rundeck.core.execution.service.NodeExecutor;
import com.dtolabs.rundeck.core.execution.service.NodeExecutorService;
import com.dtolabs.rundeck.core.execution.workflow.WorkflowExecutionService;
import com.dtolabs.rundeck.core.execution.workflow.steps.StepExecutionService;
import com.dtolabs.rundeck.core.execution.workflow.steps.node.NodeStepExecutionItem;
import com.dtolabs.rundeck.core.execution.workflow.steps.node.NodeStepExecutionService;
import com.dtolabs.rundeck.core.execution.workflow.steps.node.NodeStepExecutor;
import com.dtolabs.rundeck.core.plugins.PluginManagerService;
import com.dtolabs.rundeck.core.plugins.ServiceProviderLoader;
import com.dtolabs.rundeck.core.plugins.configuration.ConfigurationException;
import com.dtolabs.rundeck.core.resources.FileResourceModelSource;
import com.dtolabs.rundeck.core.resources.ResourceModelSourceException;
import com.dtolabs.rundeck.core.resources.ResourceModelSourceService;
import com.dtolabs.rundeck.core.resources.format.ResourceFormatGeneratorService;
import com.dtolabs.rundeck.core.resources.format.ResourceFormatParserService;
import com.dtolabs.rundeck.core.utils.IPropertyLookup;
import com.dtolabs.rundeck.core.utils.PropertyLookup;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class Framework
extends FrameworkResourceParent {
    public static final Logger logger = Logger.getLogger(Framework.class);
    public static final String CENTRALDISPATCHER_CLS_PROP = "framework.centraldispatcher.classname";
    public static final String NODES_RESOURCES_FILE_PROP = "framework.nodes.file.name";
    public static final String NODES_FILE_AUTOGEN_PROP = "framework.nodes.file.autogenerate";
    public static final String CENTRALDISPATCHER_CLS_DEFAULT = "com.dtolabs.client.services.RundeckAPICentralDispatcher";
    public static final Attribute RUNDECK_APP_CONTEXT = new Attribute(URI.create("http://dtolabs.com/rundeck/env/application"), "rundeck");
    public static final Set<Attribute> RUNDECK_APP_ENV = Collections.singleton(RUNDECK_APP_CONTEXT);
    static final String PROJECTMGR_NAME = "projectResourceMgr";
    public static final String FRAMEWORK_LIBEXT_DIR = "framework.libext.dir";
    public static final String FRAMEWORK_LIBEXT_CACHE_DIR = "framework.libext.cache.dir";
    public static final String DEFAULT_LIBEXT_DIR_NAME = "libext";
    public static final String DEFAULT_LIBEXT_CACHE_DIR_NAME = "cache";
    public static final String SYSTEM_PROP_LIBEXT = "rdeck.libext";
    public static final String SYSTEM_PROP_LIBEXT_CACHE = "rdeck.libext.cache";
    public static final String FRAMEWORK_PLUGINS_ENABLED = "framework.plugins.enabled";
    private final IPropertyLookup lookup;
    private final File projectsBase;
    private FrameworkProjectMgr projectResourceMgr;
    final HashMap<String, FrameworkSupportService> services = new HashMap();
    private CentralDispatcher centralDispatcherMgr;
    private INodeDesc nodedesc;

    @Override
    public IFrameworkResourceParent getParent() {
        throw new FrameworkResourceException("Framework has no parent resource.", this);
    }

    @Override
    public boolean childCouldBeLoaded(String name) {
        return false;
    }

    @Override
    public IFrameworkResource loadChild(String name) {
        return null;
    }

    @Override
    public Collection listChildNames() {
        return new ArrayList();
    }

    @Override
    public void initialize() {
        this.projectResourceMgr = FrameworkProjectMgr.create(PROJECTMGR_NAME, this.projectsBase, this);
        if (null == this.centralDispatcherMgr) {
            try {
                String propValue = CENTRALDISPATCHER_CLS_DEFAULT;
                if (this.lookup.hasProperty(CENTRALDISPATCHER_CLS_PROP)) {
                    propValue = this.lookup.getProperty(CENTRALDISPATCHER_CLS_PROP);
                }
                this.centralDispatcherMgr = CentralDispatcherMgrFactory.create(propValue, this).getCentralDispatcher();
            }
            catch (CentralDispatcherException e) {
                System.err.println("unable to load central dispatcher class: " + e.getMessage());
                throw new CoreException(e);
            }
        }
        if (!this.hasProperty(FRAMEWORK_PLUGINS_ENABLED) || "true".equals(this.getProperty(FRAMEWORK_PLUGINS_ENABLED))) {
            PluginManagerService.getInstanceForFramework(this);
        }
        NodeStepExecutionService.getInstanceForFramework(this);
        NodeExecutorService.getInstanceForFramework(this);
        FileCopierService.getInstanceForFramework(this);
        NodeDispatcherService.getInstanceForFramework(this);
        ExecutionServiceFactory.getInstanceForFramework(this);
        WorkflowExecutionService.getInstanceForFramework(this);
        StepExecutionService.getInstanceForFramework(this);
        ResourceModelSourceService.getInstanceForFramework(this);
        ResourceFormatParserService.getInstanceForFramework(this);
        ResourceFormatGeneratorService.getInstanceForFramework(this);
    }

    public CentralDispatcher getCentralDispatcherMgr() {
        return this.centralDispatcherMgr;
    }

    public IFrameworkProjectMgr getFrameworkProjectMgr() {
        return this.projectResourceMgr;
    }

    private Framework(String rdeck_base_dir, String projects_base_dir) {
        super("framework", new File(null == rdeck_base_dir ? Constants.getSystemBaseDir() : rdeck_base_dir), null);
        String projectsBaseDir;
        if (null == this.getBaseDir()) {
            throw new NullPointerException("rdeck_base_dir was not set in constructor and system property rdeck.base was not defined");
        }
        String string = projectsBaseDir = null == projects_base_dir ? Framework.getProjectsBaseDir(this.getBaseDir()) : projects_base_dir;
        if (null == projectsBaseDir) {
            throw new CoreException("projects base dir could not be determined.");
        }
        logger.debug((Object)("creating new Framework instance.  rdeck_base_dir=" + this.getBaseDir() + ", projects_base_dir=" + projectsBaseDir));
        if (!this.getBaseDir().exists()) {
            throw new IllegalArgumentException("rdeck_base directory does not exist. " + rdeck_base_dir);
        }
        this.projectsBase = new File(projectsBaseDir);
        if (!this.projectsBase.exists() && !this.projectsBase.mkdirs()) {
            throw new IllegalArgumentException("project base directory could not be created. " + projectsBaseDir);
        }
        File propertyFile = Framework.getPropertyFile(this.getConfigDir());
        PropertyLookup lookup1 = PropertyLookup.createDeferred(propertyFile);
        lookup1.expand();
        this.lookup = lookup1;
        long start = System.currentTimeMillis();
        this.initialize();
        long end = System.currentTimeMillis();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Framework.initialize() time: " + (end - start) + "ms"));
        }
    }

    public static String getProjectsBaseDir(File baseDir) {
        return baseDir + Constants.FILE_SEP + "projects";
    }

    public static File getPropertyFile(File configDir) {
        return new File(configDir, "framework.properties");
    }

    public static PropertyRetriever createPropertyRetriever(File baseDir) {
        return Framework.createPropertyLookupFromBasedir(baseDir).expand().safe();
    }

    public static PropertyLookup createPropertyLookupFromBasedir(File baseDir) {
        return PropertyLookup.create(Framework.getPropertyFile(Framework.getConfigDir(baseDir)));
    }

    public static PropertyRetriever createProjectPropertyRetriever(File baseDir, File projectsBaseDir, String projectName) {
        return FrameworkProject.createProjectPropertyRetriever(baseDir, projectsBaseDir, projectName);
    }

    public FrameworkSupportService getService(String name) {
        return this.services.get(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setService(String name, FrameworkSupportService service) {
        HashMap<String, FrameworkSupportService> hashMap = this.services;
        synchronized (hashMap) {
            if (null == this.services.get(name) && null != service) {
                this.services.put(name, service);
            } else if (null == service) {
                this.services.remove(name);
            }
        }
    }

    public ExecutionService getExecutionService() {
        return ExecutionServiceFactory.getInstanceForFramework(this);
    }

    public WorkflowExecutionService getWorkflowExecutionService() {
        return WorkflowExecutionService.getInstanceForFramework(this);
    }

    public StepExecutionService getStepExecutionService() {
        return StepExecutionService.getInstanceForFramework(this);
    }

    public FileCopier getFileCopierForNodeAndProject(INodeEntry node, String project) throws ExecutionServiceException {
        return (FileCopier)this.getFileCopierService().getProviderForNodeAndProject(node, project);
    }

    public FileCopierService getFileCopierService() {
        return FileCopierService.getInstanceForFramework(this);
    }

    public NodeExecutor getNodeExecutorForNodeAndProject(INodeEntry node, String project) throws ExecutionServiceException {
        return (NodeExecutor)this.getNodeExecutorService().getProviderForNodeAndProject(node, project);
    }

    public NodeExecutorService getNodeExecutorService() throws ExecutionServiceException {
        return NodeExecutorService.getInstanceForFramework(this);
    }

    public NodeStepExecutionService getNodeStepExecutorService() throws ExecutionServiceException {
        return NodeStepExecutionService.getInstanceForFramework(this);
    }

    public NodeStepExecutor getNodeStepExecutorForItem(NodeStepExecutionItem item) throws ExecutionServiceException {
        return NodeStepExecutionService.getInstanceForFramework(this).getExecutorForExecutionItem(item);
    }

    public NodeDispatcher getNodeDispatcherForContext(ExecutionContext context) throws ExecutionServiceException {
        return NodeDispatcherService.getInstanceForFramework(this).getNodeDispatcher(context);
    }

    public ResourceModelSourceService getResourceModelSourceService() {
        return ResourceModelSourceService.getInstanceForFramework(this);
    }

    public ResourceFormatParserService getResourceFormatParserService() {
        return ResourceFormatParserService.getInstanceForFramework(this);
    }

    public ResourceFormatGeneratorService getResourceFormatGeneratorService() {
        return ResourceFormatGeneratorService.getInstanceForFramework(this);
    }

    public ServiceProviderLoader getPluginManager() {
        if (null != this.getService("PluginManager")) {
            return PluginManagerService.getInstanceForFramework(this);
        }
        return null;
    }

    public static Framework getInstanceWithoutProjectsDir(String rdeck_base_dir) {
        File baseDir = new File(rdeck_base_dir);
        File propertyFile = Framework.getPropertyFile(Framework.getConfigDir(baseDir));
        String projectsDir = null;
        if (propertyFile.exists()) {
            PropertyRetriever propertyRetriever = Framework.createPropertyRetriever(baseDir);
            projectsDir = propertyRetriever.getProperty("framework.projects.dir");
        }
        return new Framework(rdeck_base_dir, projectsDir);
    }

    public static Framework getInstance(String rdeck_base_dir, String projects_base_dir) {
        return new Framework(rdeck_base_dir, projects_base_dir);
    }

    public void setCentralDispatcherMgr(CentralDispatcher centralDispatcherMgr) {
        this.centralDispatcherMgr = centralDispatcherMgr;
    }

    public String getProperty(String name) {
        return this.lookup.getProperty(name);
    }

    public PropertyRetriever getPropertyRetriever() {
        return PropertyLookup.safePropertyRetriever(this.lookup);
    }

    public boolean hasProperty(String key) {
        return this.lookup.hasProperty(key);
    }

    public boolean hasProjectProperty(String key, String project) {
        FrameworkProject frameworkProject = this.getFrameworkProjectMgr().getFrameworkProject(project);
        return frameworkProject.hasProperty(key) || this.hasProperty(key);
    }

    public String getProjectProperty(String project, String key) {
        FrameworkProject frameworkProject = this.getFrameworkProjectMgr().getFrameworkProject(project);
        if (frameworkProject.hasProperty(key)) {
            return frameworkProject.getProperty(key);
        }
        if (this.hasProperty(key)) {
            return this.getProperty(key);
        }
        return null;
    }

    public IPropertyLookup getPropertyLookup() {
        return this.lookup;
    }

    @Override
    public String toString() {
        return "Framework{baseDir=" + this.getBaseDir() + ", projectsBaseDir=" + this.projectsBase + "}";
    }

    public String getFrameworkNodeHostname() {
        String hostname = this.getProperty("framework.server.hostname");
        if (null != hostname) {
            return hostname.trim();
        }
        return hostname;
    }

    public String getFrameworkNodeName() {
        String name = this.getProperty("framework.server.name");
        if (null != name) {
            return name.trim();
        }
        return name;
    }

    public NodeEntryImpl createFrameworkNode() {
        NodeEntryImpl node = new NodeEntryImpl(this.getFrameworkNodeHostname(), this.getFrameworkNodeName());
        node.setUsername(this.getProperty("framework.ssh.user"));
        node.setDescription("Rundeck server node");
        node.setOsArch(System.getProperty("os.arch"));
        node.setOsName(System.getProperty("os.name"));
        node.setOsVersion(System.getProperty("os.version"));
        String s = System.getProperty("file.separator");
        node.setOsFamily("/".equals(s) ? "unix" : ("\\".equals(s) ? "windows" : ""));
        return node;
    }

    public Collection<INodeEntry> filterNodes(NodesSelector nodeset, String project, File nodesFile) throws NodeFileParserException {
        return this.filterNodeSet(nodeset, project, nodesFile).getNodes();
    }

    public INodeSet filterNodeSet(NodesSelector nodeset, String project, File nodesFile) throws NodeFileParserException {
        INodeSet unfiltered = null;
        if (null != nodesFile) {
            try {
                unfiltered = FileResourceModelSource.parseFile(nodesFile, this, project);
            }
            catch (ResourceModelSourceException e) {
                throw new CoreException(e);
            }
            catch (ConfigurationException e) {
                throw new CoreException(e);
            }
        } else {
            unfiltered = this.getFrameworkProjectMgr().getFrameworkProject(project).getNodeSet();
        }
        if (0 == unfiltered.getNodeNames().size()) {
            logger.warn((Object)"Empty node list");
        }
        INodeSet filtered = NodeFilter.filterNodes(nodeset, unfiltered);
        return filtered;
    }

    public INodeSet filterAuthorizedNodes(String project, Set<String> actions, INodeSet unfiltered, AuthContext authContext) {
        if (null == actions || actions.size() <= 0) {
            return unfiltered;
        }
        HashSet<Map<String, String>> resources = new HashSet<Map<String, String>>();
        for (INodeEntry iNodeEntry : unfiltered.getNodes()) {
            HashMap<String, String> resdef = new HashMap<String, String>(iNodeEntry.getAttributes());
            resdef.put("type", "node");
            resdef.put("rundeck_server", Boolean.toString(this.isLocalNode(iNodeEntry)));
            resources.add(resdef);
        }
        Set<Decision> decisions = authContext.evaluate(resources, actions, Collections.singleton(new Attribute(URI.create("http://dtolabs.com/rundeck/env/project"), project)));
        NodeSetImpl authorized = new NodeSetImpl();
        HashMap authorizations = new HashMap();
        for (Decision decision : decisions) {
            if (!decision.isAuthorized() || !actions.contains(decision.getAction())) continue;
            String nodename = decision.getResource().get("nodename");
            if (null == authorizations.get(nodename)) {
                authorizations.put(nodename, new HashSet());
            }
            ((Set)authorizations.get(nodename)).add(decision.getAction());
        }
        for (Map.Entry entry : authorizations.entrySet()) {
            if (((Set)entry.getValue()).size() != actions.size()) continue;
            authorized.putNode(unfiltered.getNode((String)entry.getKey()));
        }
        return authorized;
    }

    public File getConfigDir() {
        return new File(Constants.getFrameworkConfigDir(this.getBaseDir().getAbsolutePath()));
    }

    public static File getConfigDir(File baseDir) {
        return new File(Constants.getFrameworkConfigDir(baseDir.getAbsolutePath()));
    }

    public File getLibextDir() {
        if (null != System.getProperty(SYSTEM_PROP_LIBEXT)) {
            return new File(System.getProperty(SYSTEM_PROP_LIBEXT));
        }
        if (this.hasProperty(FRAMEWORK_LIBEXT_DIR)) {
            return new File(this.getProperty(FRAMEWORK_LIBEXT_DIR));
        }
        return new File(this.getBaseDir(), DEFAULT_LIBEXT_DIR_NAME);
    }

    public File getLibextCacheDir() {
        if (null != System.getProperty(SYSTEM_PROP_LIBEXT_CACHE)) {
            return new File(System.getProperty(SYSTEM_PROP_LIBEXT_CACHE));
        }
        if (this.hasProperty(FRAMEWORK_LIBEXT_CACHE_DIR)) {
            return new File(this.getProperty(FRAMEWORK_LIBEXT_CACHE_DIR));
        }
        return new File(this.getLibextDir(), DEFAULT_LIBEXT_CACHE_DIR_NAME);
    }

    public File getFrameworkProjectsBaseDir() {
        return this.projectsBase;
    }

    public INodeDesc getNodeDesc() {
        if (null == this.nodedesc) {
            this.nodedesc = NodeEntryImpl.create(this.getFrameworkNodeHostname(), this.getFrameworkNodeName());
        }
        return this.nodedesc;
    }

    public boolean isLocalNode(INodeDesc node) {
        String fwkNodeName = this.getFrameworkNodeName();
        return fwkNodeName.equals(node.getNodename());
    }
}

