/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.common;

import com.dtolabs.rundeck.core.common.Framework;
import com.dtolabs.rundeck.core.common.FrameworkProject;
import com.dtolabs.rundeck.core.common.FrameworkResourceException;
import com.dtolabs.rundeck.core.common.FrameworkResourceParent;
import com.dtolabs.rundeck.core.common.IFrameworkProjectMgr;
import com.dtolabs.rundeck.core.common.IFrameworkResource;
import com.dtolabs.rundeck.core.utils.IPropertyLookup;
import com.dtolabs.rundeck.core.utils.PropertyLookup;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;

public class FrameworkProjectMgr
extends FrameworkResourceParent
implements IFrameworkProjectMgr {
    public static final Logger log = Logger.getLogger(FrameworkProjectMgr.class);
    private final Framework framework;
    private final IPropertyLookup lookup;
    final HashMap<String, FrameworkProject> projectCache = new HashMap();

    public static FrameworkProjectMgr create(String name, File baseDir, Framework framework) {
        return new FrameworkProjectMgr(name, baseDir, framework);
    }

    private FrameworkProjectMgr(String name, File baseDir, Framework framework) {
        super(name, baseDir, framework);
        this.framework = framework;
        this.lookup = PropertyLookup.create(framework.getPropertyLookup());
    }

    @Override
    public FrameworkProject createFrameworkProject(String projectName) {
        FrameworkProject project = this.createFrameworkProjectInt(projectName);
        return project;
    }

    @Override
    public FrameworkProject createFrameworkProject(String projectName, Properties properties) {
        FrameworkProject project = this.createFrameworkProjectInt(projectName, properties, false);
        return project;
    }

    @Override
    public FrameworkProject createFrameworkProjectStrict(String projectName, Properties properties) {
        FrameworkProject project = this.createFrameworkProjectInt(projectName, properties, true);
        return project;
    }

    private FrameworkProject createFrameworkProjectInt(String projectName) {
        return this.createFrameworkProjectInt(projectName, null, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FrameworkProject createFrameworkProjectInt(String projectName, Properties properties, boolean strict) {
        FrameworkProject project;
        if (strict && this.existsFrameworkProject(projectName)) {
            throw new IllegalArgumentException("project exists: " + projectName);
        }
        HashMap<String, FrameworkProject> hashMap = this.projectCache;
        synchronized (hashMap) {
            if (null != this.projectCache.get(projectName)) {
                return this.projectCache.get(projectName);
            }
            project = FrameworkProject.create(projectName, this.getBaseDir(), this, properties);
            this.projectCache.put(projectName, project);
        }
        return project;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeFrameworkProject(String projectName) {
        HashMap<String, FrameworkProject> hashMap = this.projectCache;
        synchronized (hashMap) {
            super.remove(projectName);
            this.projectCache.remove(projectName);
        }
    }

    @Override
    public Collection listFrameworkProjects() {
        return this.listChildren();
    }

    @Override
    public FrameworkProject getFrameworkProject(String name) {
        try {
            return (FrameworkProject)this.getChild(name);
        }
        catch (FrameworkResourceParent.NoSuchResourceException e) {
            throw new FrameworkResourceParent.NoSuchResourceException("Project does not exist: " + name, this);
        }
    }

    @Override
    public boolean existsFrameworkProject(String project) {
        if (null == project) {
            throw new IllegalArgumentException("project paramater was null");
        }
        return this.existsChild(project);
    }

    @Override
    public String toString() {
        return "DepotMgr{name=" + this.getName() + ", baseDir=" + this.getBaseDir() + "}";
    }

    public Properties getProperties() {
        return new Properties();
    }

    public File getPropertyFile() {
        throw new UnsupportedOperationException("FrameworkProjectMgr should not have its own property file");
    }

    @Override
    public IFrameworkResource createChild(String projectName) {
        return this.createFrameworkProject(projectName);
    }

    @Override
    public IFrameworkResource loadChild(String name) {
        if (this.childCouldBeLoaded(name)) {
            return this.createFrameworkProjectInt(name);
        }
        return null;
    }

    @Override
    public Framework getFramework() {
        return this.framework;
    }

    @Override
    public boolean isConfiguredObjectDeploymentsCheck(String projectName) {
        if (this.existsFrameworkProject(projectName)) {
            FrameworkProject d = this.getFrameworkProject(projectName);
            return d.hasProperty("project.resources.check");
        }
        throw new FrameworkResourceException("project not found: " + projectName, this);
    }

    @Override
    public String getProperty(String key) {
        return this.lookup.getProperty(key);
    }

    @Override
    public boolean hasProperty(String key) {
        return this.lookup.hasProperty(key);
    }

    @Override
    public Map getPropertiesMap() {
        return this.lookup.getPropertiesMap();
    }
}

