/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.execution.service;

import com.dtolabs.rundeck.core.common.Framework;
import com.dtolabs.rundeck.core.common.INodeEntry;
import com.dtolabs.rundeck.core.dispatcher.DataContextUtils;
import com.dtolabs.rundeck.core.execution.ExecutionContext;
import com.dtolabs.rundeck.core.execution.impl.common.BaseFileCopier;
import com.dtolabs.rundeck.core.execution.service.DestinationFileCopier;
import com.dtolabs.rundeck.core.execution.service.FileCopierException;
import com.dtolabs.rundeck.core.execution.workflow.steps.FailureReason;
import com.dtolabs.rundeck.core.execution.workflow.steps.StepFailureReason;
import com.dtolabs.rundeck.core.execution.workflow.steps.node.NodeStepFailureReason;
import com.dtolabs.rundeck.core.plugins.BaseScriptPlugin;
import com.dtolabs.rundeck.core.plugins.PluginException;
import com.dtolabs.rundeck.core.plugins.ScriptPluginProvider;
import com.dtolabs.rundeck.core.utils.ScriptExecUtil;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

class ScriptPluginFileCopier
extends BaseScriptPlugin
implements DestinationFileCopier {
    @Override
    public boolean isAllowCustomProperties() {
        return false;
    }

    ScriptPluginFileCopier(ScriptPluginProvider provider, Framework framework) {
        super(provider, framework);
    }

    static void validateScriptPlugin(ScriptPluginProvider plugin) throws PluginException {
        if (null == plugin.getScriptArgs()) {
            throw new PluginException("no script-args defined for provider: " + plugin);
        }
    }

    @Override
    public String copyFileStream(ExecutionContext executionContext, InputStream inputStream, INodeEntry node) throws FileCopierException {
        return this.copyFile(executionContext, null, inputStream, null, node, null, false);
    }

    @Override
    public String copyFile(ExecutionContext executionContext, File file, INodeEntry node) throws FileCopierException {
        return this.copyFile(executionContext, file, null, null, node, null, false);
    }

    @Override
    public String copyScriptContent(ExecutionContext executionContext, String s, INodeEntry node) throws FileCopierException {
        return this.copyFile(executionContext, null, null, s, node, null, false);
    }

    @Override
    public String copyFileStream(ExecutionContext executionContext, InputStream inputStream, INodeEntry node, String destination) throws FileCopierException {
        return this.copyFile(executionContext, null, inputStream, null, node, destination, null == destination);
    }

    @Override
    public String copyFile(ExecutionContext executionContext, File file, INodeEntry node, String destination) throws FileCopierException {
        return this.copyFile(executionContext, file, null, null, node, destination, null == destination);
    }

    @Override
    public String copyScriptContent(ExecutionContext executionContext, String s, INodeEntry node, String destination) throws FileCopierException {
        return this.copyFile(executionContext, null, null, s, node, destination, null == destination);
    }

    String copyFile(ExecutionContext executionContext, File file, InputStream input, String content, INodeEntry node, String destination, boolean expandTokens) throws FileCopierException {
        String pluginname = this.getProvider().getName();
        Map<String, Map<String, String>> localDataContext = this.createScriptDataContext(executionContext.getFramework(), executionContext.getFrameworkProject(), executionContext.getDataContext());
        localDataContext.put("node", DataContextUtils.nodeData(node));
        File srcFile = expandTokens ? BaseFileCopier.writeScriptTempFile(executionContext, file, input, content, node) : (null != file ? file : BaseFileCopier.writeTempFile(executionContext, file, input, content));
        String destFilePath = destination;
        if (null != destFilePath && destFilePath.endsWith("/")) {
            destFilePath = destFilePath + srcFile.getName();
        }
        HashMap<String, String> scptexec = new HashMap<String, String>();
        scptexec.put("file", srcFile.getAbsolutePath());
        scptexec.put("destination", null != destFilePath ? destFilePath : "");
        localDataContext.put("file-copy", scptexec);
        String[] finalargs = this.createScriptArgs(localDataContext);
        executionContext.getExecutionListener().log(3, "[" + this.getProvider().getName() + "] executing: " + Arrays.asList(finalargs));
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            int result = ScriptExecUtil.runLocalCommand(finalargs, DataContextUtils.generateEnvVarsFromContext(localDataContext), null, byteArrayOutputStream, System.err);
            executionContext.getExecutionListener().log(3, "[" + pluginname + "]: result code: " + result);
            if (result != 0) {
                throw new FileCopierException("[" + pluginname + "]: external script failed with exit code: " + result, NodeStepFailureReason.NonZeroResultCode);
            }
        }
        catch (IOException e) {
            throw new FileCopierException(e.getMessage(), StepFailureReason.IOFailure);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new FileCopierException(e.getMessage(), StepFailureReason.Interrupted);
        }
        if (null != destination) {
            return destFilePath;
        }
        String output = byteArrayOutputStream.toString();
        if (null == output || output.length() < 1) {
            throw new FileCopierException("[" + pluginname + "]: No output from external script", ScriptPluginFailureReason.ScriptPluginFileCopierOutputMissing);
        }
        String[] split1 = output.split("(\\r?\\n)");
        if (split1.length < 1) {
            throw new FileCopierException("[" + pluginname + "]: No output from external script", ScriptPluginFailureReason.ScriptPluginFileCopierOutputMissing);
        }
        String remotefilepath = split1[0];
        executionContext.getExecutionListener().log(3, "[" + pluginname + "]: result filepath: " + remotefilepath);
        return remotefilepath;
    }

    static enum ScriptPluginFailureReason implements FailureReason
    {
        ScriptPluginFileCopierOutputMissing;

    }
}

