/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.execution.workflow;

import com.dtolabs.rundeck.core.common.INodeEntry;
import com.dtolabs.rundeck.core.execution.ExecutionContext;
import com.dtolabs.rundeck.core.execution.ExecutionListener;
import com.dtolabs.rundeck.core.execution.ExecutionListenerOverride;
import com.dtolabs.rundeck.core.execution.FailedNodesListener;
import com.dtolabs.rundeck.core.execution.StepExecutionItem;
import com.dtolabs.rundeck.core.execution.workflow.ContextLogger;
import com.dtolabs.rundeck.core.execution.workflow.ContextualExecutionListener;
import com.dtolabs.rundeck.core.execution.workflow.StepContextWorkflowExecutionListener;
import com.dtolabs.rundeck.core.execution.workflow.StepExecutionContext;
import com.dtolabs.rundeck.core.execution.workflow.WFStepContext;
import com.dtolabs.rundeck.core.execution.workflow.WorkflowExecutionItem;
import com.dtolabs.rundeck.core.execution.workflow.WorkflowExecutionListener;
import com.dtolabs.rundeck.core.execution.workflow.WorkflowExecutionResult;
import com.dtolabs.rundeck.core.execution.workflow.steps.StepExecutionResult;
import com.dtolabs.rundeck.core.execution.workflow.steps.node.NodeStepExecutionItem;
import com.dtolabs.rundeck.core.execution.workflow.steps.node.NodeStepResult;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class WorkflowExecutionListenerImpl
extends ContextualExecutionListener
implements WorkflowExecutionListener,
ExecutionListener {
    private StepContextWorkflowExecutionListener<INodeEntry, WFStepContext> stepContext = new StepContextWorkflowExecutionListener();
    private WorkflowExecutionListenerImpl delegate;

    protected WorkflowExecutionListenerImpl(WorkflowExecutionListenerImpl delegate) {
        super(delegate);
        this.delegate = delegate;
    }

    public WorkflowExecutionListenerImpl(FailedNodesListener failedNodesListener, ContextLogger logger, boolean terse, String logFormat) {
        super(failedNodesListener, logger, terse, logFormat);
    }

    @Override
    public void beginExecuteNodeStep(ExecutionContext context, NodeStepExecutionItem item, INodeEntry node) {
        if (null != this.delegate) {
            this.delegate.beginExecuteNodeStep(context, item, node);
            return;
        }
        super.beginExecuteNodeStep(context, item, node);
        this.stepContext.beginNodeContext(node);
        this.log(4, "[workflow] beginExecuteNodeStep(" + node.getNodename() + "): " + item.getType() + ": " + item);
    }

    @Override
    public void finishExecuteNodeStep(NodeStepResult result, ExecutionContext context, StepExecutionItem item, INodeEntry node) {
        if (null != this.delegate) {
            this.delegate.finishExecuteNodeStep(result, context, item, node);
            return;
        }
        super.finishExecuteNodeStep(result, context, item, node);
        this.stepContext.finishNodeContext();
        this.log(4, "[workflow] finishExecuteNodeStep(" + node.getNodename() + "): " + item.getType() + ": " + result);
    }

    @Override
    public Map<String, String> getLoggingContext() {
        if (null != this.delegate) {
            return this.delegate.getLoggingContext();
        }
        INodeEntry currentNode = this.stepContext.getCurrentNode();
        List<WFStepContext> currentContext = this.stepContext.getCurrentContext();
        if (null != currentContext || null != currentNode) {
            HashMap<String, String> loggingContext = new HashMap<String, String>();
            if (null != currentNode) {
                loggingContext.put("node", currentNode.getNodename());
                loggingContext.put("user", currentNode.extractUserName());
            }
            if (null != currentContext) {
                WFStepContext last = currentContext.get(currentContext.size() - 1);
                if (last.getStep() > -1) {
                    loggingContext.put("step", Integer.toString(last.getStep()));
                }
                loggingContext.put("stepctx", this.generateContextId(currentContext));
            }
            return loggingContext;
        }
        return null;
    }

    private String generateContextString(List<WFStepContext> stack) {
        if (null != this.delegate) {
            return this.delegate.generateContextString(stack);
        }
        Object[] strings = new String[stack.size()];
        int i = 0;
        for (WFStepContext context : stack) {
            strings[i++] = this.makePrefix(context);
        }
        return StringUtils.join((Object[])strings, (String)":");
    }

    private String generateContextId(List<WFStepContext> stack) {
        if (null != this.delegate) {
            return this.delegate.generateContextString(stack);
        }
        Object[] strings = new String[stack.size()];
        int i = 0;
        for (WFStepContext context : stack) {
            strings[i++] = Integer.toString(context.getStep()) + (context.isErrorHandler() ? "e" : "");
        }
        return StringUtils.join((Object[])strings, (String)"/");
    }

    private String makePrefix(WFStepContext wfStepInfo) {
        if (null != this.delegate) {
            return this.delegate.makePrefix(wfStepInfo);
        }
        String type = wfStepInfo.getStepItem().getType();
        if (wfStepInfo.getStepItem() instanceof NodeStepExecutionItem) {
            NodeStepExecutionItem ns = (NodeStepExecutionItem)wfStepInfo.getStepItem();
            type = type + "-" + ns.getNodeStepType();
        }
        return wfStepInfo.getStep() + "-" + type;
    }

    @Override
    public void beginWorkflowExecution(StepExecutionContext executionContext, WorkflowExecutionItem item) {
        if (null != this.delegate) {
            this.delegate.beginWorkflowExecution(executionContext, item);
            return;
        }
        this.stepContext.beginContext();
        this.log(4, "[workflow] Begin execution: " + item.getType() + " context: " + this.stepContext.getCurrentContext());
    }

    @Override
    public void finishWorkflowExecution(WorkflowExecutionResult result, StepExecutionContext executionContext, WorkflowExecutionItem item) {
        if (null != this.delegate) {
            this.delegate.finishWorkflowExecution(result, executionContext, item);
            return;
        }
        this.stepContext.finishContext();
        this.log(4, "[workflow] Finish execution:  " + item.getType() + ": " + result);
    }

    @Override
    public void beginWorkflowItem(int step, StepExecutionItem item) {
        if (null != this.delegate) {
            this.delegate.beginWorkflowItem(step, item);
            return;
        }
        this.stepContext.beginStepContext(new WFStepContext(item, step));
        this.log(4, "[workflow] Begin step: " + step + "," + item.getType());
    }

    @Override
    public void beginWorkflowItemErrorHandler(int step, StepExecutionItem item) {
        if (null != this.delegate) {
            this.delegate.beginWorkflowItemErrorHandler(step, item);
            return;
        }
        this.stepContext.beginStepContext(new WFStepContext(item, step, true));
        this.log(4, "[workflow] Begin error handler: " + step + "," + item.getType());
    }

    @Override
    public void finishWorkflowItem(int step, StepExecutionItem item, StepExecutionResult result) {
        if (null != this.delegate) {
            this.delegate.finishWorkflowItem(step, item, result);
            return;
        }
        this.stepContext.finishStepContext();
        this.log(4, "[workflow] Finish step: " + step + "," + item.getType());
    }

    @Override
    public void finishWorkflowItemErrorHandler(int step, StepExecutionItem item, StepExecutionResult result) {
        if (null != this.delegate) {
            this.delegate.finishWorkflowItemErrorHandler(step, item, result);
            return;
        }
        this.stepContext.finishStepContext();
        this.log(4, "[workflow] Finish error handler: " + step + "," + item.getType());
    }

    @Override
    public ExecutionListenerOverride createOverride() {
        return new WorkflowExecutionListenerImpl(this);
    }
}

