/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.execution.workflow.state;

import com.dtolabs.rundeck.core.execution.workflow.state.ExecutionState;
import com.dtolabs.rundeck.core.execution.workflow.state.StepAspect;
import com.dtolabs.rundeck.core.execution.workflow.state.StepContextId;
import com.dtolabs.rundeck.core.execution.workflow.state.StepIdentifier;
import com.dtolabs.rundeck.core.execution.workflow.state.StepIdentifierImpl;
import com.dtolabs.rundeck.core.execution.workflow.state.StepState;
import com.dtolabs.rundeck.core.execution.workflow.state.StepStateChange;
import com.dtolabs.rundeck.core.execution.workflow.state.StepStateChangeImpl;
import com.dtolabs.rundeck.core.execution.workflow.state.StepStateImpl;
import com.dtolabs.rundeck.core.execution.workflow.state.WorkflowNodeState;
import com.dtolabs.rundeck.core.execution.workflow.state.WorkflowNodeStateImpl;
import com.dtolabs.rundeck.core.execution.workflow.state.WorkflowState;
import com.dtolabs.rundeck.core.execution.workflow.state.WorkflowStateImpl;
import com.dtolabs.rundeck.core.execution.workflow.state.WorkflowStepState;
import com.dtolabs.rundeck.core.execution.workflow.state.WorkflowStepStateImpl;
import com.dtolabs.rundeck.core.utils.PairImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class StateUtils {
    public static StepState stepState(ExecutionState state) {
        return StateUtils.stepState(state, null, null, null, null, null);
    }

    public static StepState stepState(ExecutionState state, Map metadata) {
        return StateUtils.stepState(state, metadata, null, null, null, null);
    }

    public static StepState stepState(ExecutionState state, Map metadata, String errorMessage) {
        return StateUtils.stepState(state, metadata, errorMessage, null, null, null);
    }

    public static StepState stepState(ExecutionState state, Map metadata, String errorMessage, Date startTime, Date updateTime, Date endTime) {
        StepStateImpl stepState = new StepStateImpl();
        stepState.setExecutionState(state);
        stepState.setMetadata(metadata);
        stepState.setErrorMessage(errorMessage);
        stepState.setStartTime(startTime);
        stepState.setUpdateTime(updateTime);
        stepState.setEndTime(endTime);
        return stepState;
    }

    public static StepStateChange stepStateChange(StepState state) {
        StepStateChangeImpl stepStateChange = new StepStateChangeImpl();
        stepStateChange.setStepState(state);
        stepStateChange.setNodeState(false);
        return stepStateChange;
    }

    public static StepStateChange stepStateChange(StepState state, String nodeName) {
        StepStateChangeImpl stepStateChange = new StepStateChangeImpl();
        stepStateChange.setStepState(state);
        stepStateChange.setNodeState(null != nodeName);
        stepStateChange.setNodeName(nodeName);
        return stepStateChange;
    }

    public static StepContextId stepContextId(int step, boolean errorhandler) {
        return new CtxItem(step, errorhandler);
    }

    public static StepIdentifier stepIdentifier(List<StepContextId> context) {
        return new StepIdentifierImpl(context);
    }

    public static StepIdentifier stepIdentifier(StepContextId ... context) {
        return new StepIdentifierImpl(Arrays.asList(context));
    }

    public static StepIdentifier stepIdentifier(int id) {
        return StateUtils.stepIdentifier(StateUtils.stepContextId(id, false));
    }

    public static StepIdentifier stepIdentifier(int ... ids) {
        return StateUtils.stepIdentifier(StateUtils.asStepContextIds(ids));
    }

    public static StepContextId last(StepIdentifier stepIdentifier) {
        return stepIdentifier.getContext().get(stepIdentifier.getContext().size() - 1);
    }

    public static StepContextId first(StepIdentifier stepIdentifier) {
        return stepIdentifier.getContext().get(0);
    }

    private static List<StepContextId> asStepContextIds(int[] ids) {
        ArrayList<StepContextId> stepContextIds = new ArrayList<StepContextId>(ids.length);
        for (int i = 0; i < ids.length; ++i) {
            int id = ids[i];
            stepContextIds.add(StateUtils.stepContextId(id, false));
        }
        return stepContextIds;
    }

    public static StepIdentifier stepIdentifierTail(StepIdentifier identifier) {
        return new StepIdentifierImpl(identifier.getContext().subList(1, identifier.getContext().size()));
    }

    public static StepIdentifier stepIdentifierAppend(StepIdentifier identifier, StepIdentifier identifier2) {
        ArrayList<StepContextId> context = new ArrayList<StepContextId>();
        if (null != identifier && null != identifier.getContext() && identifier.getContext().size() > 0) {
            context.addAll(identifier.getContext());
        }
        if (null != identifier2 && null != identifier2.getContext() && identifier2.getContext().size() > 0) {
            context.addAll(identifier2.getContext());
        }
        return new StepIdentifierImpl(context);
    }

    public static WorkflowState workflowState(List<String> nodeSet, List<String> allNodes, long stepCount, ExecutionState executionState, Date updateTime, Date startTime, Date endTime, String serverNode, List<WorkflowStepState> stepStates, boolean setupNodeStates) {
        WorkflowStateImpl workflowState = new WorkflowStateImpl(nodeSet, allNodes, stepCount, executionState, updateTime, startTime, endTime, serverNode, stepStates, null);
        if (setupNodeStates) {
            StateUtils.setupNodeStates(workflowState);
        }
        return workflowState;
    }

    public static WorkflowState workflowState(List<String> nodeSet, List<String> allNodes, long stepCount, ExecutionState executionState, Date timestamp, Date startTime, Date endTime, String serverNode, List<WorkflowStepState> stepStates, Map<String, WorkflowNodeState> nodeStates) {
        return new WorkflowStateImpl(nodeSet, allNodes, stepCount, executionState, timestamp, startTime, endTime, serverNode, stepStates, nodeStates);
    }

    public static void setupNodeStates(WorkflowStateImpl current) {
        StateUtils.setupNodeStates(current, current, null);
    }

    private static void setupNodeStates(WorkflowState current, WorkflowStateImpl parent, StepIdentifier ident) {
        HashMap<String, WorkflowNodeState> nodeStates = new HashMap<String, WorkflowNodeState>();
        if (null != parent.getNodeStates()) {
            nodeStates.putAll(parent.getNodeStates());
        }
        ArrayList<String> allNodes = new ArrayList<String>();
        if (null != parent.getNodeSet()) {
            allNodes.addAll(parent.getNodeSet());
        }
        parent.setNodeStates(nodeStates);
        parent.setAllNodes(allNodes);
        for (WorkflowStepState workflowStepState : current.getStepStates()) {
            StepIdentifier thisident = StateUtils.stepIdentifierAppend(ident, workflowStepState.getStepIdentifier());
            if (workflowStepState.isNodeStep()) {
                for (String nodeName : current.getNodeSet()) {
                    HashMap<StepIdentifier, ? extends StepState> stepStatesForNode = new HashMap<StepIdentifier, StepState>();
                    StepState state = workflowStepState.getNodeStateMap().get(nodeName);
                    stepStatesForNode.put(thisident, state);
                    WorkflowNodeState orig = nodeStates.get(nodeName);
                    if (null != orig && null != orig.getStepStateMap()) {
                        stepStatesForNode.putAll(orig.getStepStateMap());
                    }
                    if (!allNodes.contains(nodeName)) {
                        allNodes.add(nodeName);
                    }
                    WorkflowNodeState workflowNodeState = StateUtils.workflowNodeState(nodeName, state, thisident, stepStatesForNode);
                    nodeStates.put(nodeName, workflowNodeState);
                }
                continue;
            }
            if (!workflowStepState.hasSubWorkflow()) continue;
            StateUtils.setupNodeStates(workflowStepState.getSubWorkflowState(), parent, thisident);
        }
    }

    public static WorkflowStepState workflowStepState(StepState stepState, Map<String, StepState> nodeStateMap, StepIdentifier stepIdentifier, WorkflowState subWorkflowState, List<String> nodeStepTargets, boolean nodeStep) {
        WorkflowStepStateImpl workflowStepState = new WorkflowStepStateImpl();
        workflowStepState.setStepState(stepState);
        workflowStepState.setNodeStateMap(nodeStateMap);
        workflowStepState.setStepIdentifier(stepIdentifier);
        workflowStepState.setSubWorkflow(null != subWorkflowState);
        workflowStepState.setSubWorkflowState(subWorkflowState);
        if (null != nodeStepTargets) {
            workflowStepState.setNodeStepTargets(nodeStepTargets);
        }
        workflowStepState.setNodeStep(nodeStep);
        return workflowStepState;
    }

    public static WorkflowNodeState workflowNodeState(String nodeName, StepState nodeState, StepIdentifier lastIdentifier, Map<StepIdentifier, ? extends StepState> stepStates) {
        return StateUtils.workflowNodeStateImpl(nodeName, nodeState, lastIdentifier, stepStates);
    }

    private static WorkflowNodeStateImpl workflowNodeStateImpl(String nodeName, StepState nodeState, StepIdentifier lastIdentifier, Map<StepIdentifier, ? extends StepState> stepStates) {
        WorkflowNodeStateImpl workflowNodeState = new WorkflowNodeStateImpl();
        workflowNodeState.setNodeName(nodeName);
        workflowNodeState.setNodeState(nodeState);
        workflowNodeState.setLastIdentifier(lastIdentifier);
        workflowNodeState.setStepStateMap(stepStates);
        return workflowNodeState;
    }

    public static class CtxItem
    extends PairImpl<Integer, Boolean>
    implements StepContextId {
        public CtxItem(Integer first, Boolean second) {
            super(first, second);
        }

        @Override
        public int getStep() {
            return (Integer)this.getFirst();
        }

        @Override
        public StepAspect getAspect() {
            return (Boolean)this.getSecond() != false ? StepAspect.ErrorHandler : StepAspect.Main;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CtxItem that = (CtxItem)o;
            if (this.getStep() != that.getStep()) {
                return false;
            }
            return this.getAspect().equals((Object)that.getAspect());
        }

        @Override
        public int hashCode() {
            int result = super.hashCode();
            result = 31 * result + this.getStep();
            result = 31 * result + this.getAspect().hashCode();
            return result;
        }

        @Override
        public int compareTo(StepContextId o) {
            int c;
            int thatstep;
            int step = this.getStep();
            int n = step < (thatstep = o.getStep()) ? -1 : (c = step > thatstep ? 1 : 0);
            if (c != 0) {
                return c;
            }
            return this.getAspect().compareTo(o.getAspect());
        }

        public String toString() {
            return this.getStep() + ((Boolean)this.getSecond() != false ? "e" : "");
        }
    }
}

