/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.execution.workflow.state;

import com.dtolabs.rundeck.core.common.INodeEntry;
import com.dtolabs.rundeck.core.execution.ExecutionContext;
import com.dtolabs.rundeck.core.execution.StatusResult;
import com.dtolabs.rundeck.core.execution.StepExecutionItem;
import com.dtolabs.rundeck.core.execution.dispatch.INodeEntryComparator;
import com.dtolabs.rundeck.core.execution.workflow.StepContextWorkflowExecutionListener;
import com.dtolabs.rundeck.core.execution.workflow.StepExecutionContext;
import com.dtolabs.rundeck.core.execution.workflow.WorkflowExecutionItem;
import com.dtolabs.rundeck.core.execution.workflow.WorkflowExecutionListener;
import com.dtolabs.rundeck.core.execution.workflow.WorkflowExecutionResult;
import com.dtolabs.rundeck.core.execution.workflow.state.ExecutionState;
import com.dtolabs.rundeck.core.execution.workflow.state.StateUtils;
import com.dtolabs.rundeck.core.execution.workflow.state.StepContextId;
import com.dtolabs.rundeck.core.execution.workflow.state.StepIdentifier;
import com.dtolabs.rundeck.core.execution.workflow.state.StepStateChange;
import com.dtolabs.rundeck.core.execution.workflow.state.WorkflowStateListener;
import com.dtolabs.rundeck.core.execution.workflow.steps.StepExecutionResult;
import com.dtolabs.rundeck.core.execution.workflow.steps.StepExecutor;
import com.dtolabs.rundeck.core.execution.workflow.steps.node.NodeStepExecutionItem;
import com.dtolabs.rundeck.core.execution.workflow.steps.node.NodeStepResult;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class WorkflowExecutionStateListenerAdapter
implements WorkflowExecutionListener {
    List<WorkflowStateListener> listeners;
    StepContextWorkflowExecutionListener<INodeEntry, StepContextId> stepContext;

    public WorkflowExecutionStateListenerAdapter() {
        this(new ArrayList<WorkflowStateListener>());
    }

    public WorkflowExecutionStateListenerAdapter(List<WorkflowStateListener> listeners) {
        this.listeners = listeners;
        this.stepContext = new StepContextWorkflowExecutionListener();
    }

    public void addWorkflowStateListener(WorkflowStateListener listener) {
        this.listeners.add(listener);
    }

    private void notifyAllWorkflowState(ExecutionState executionState, Date timestamp, List<String> nodenames) {
        for (WorkflowStateListener listener : this.listeners) {
            listener.workflowExecutionStateChanged(executionState, timestamp, nodenames);
        }
    }

    private void notifyAllSubWorkflowState(StepIdentifier identifier, ExecutionState executionState, Date timestamp, List<String> nodenames) {
        for (WorkflowStateListener listener : this.listeners) {
            listener.subWorkflowExecutionStateChanged(identifier, executionState, timestamp, nodenames);
        }
    }

    private void notifyAllStepState(StepIdentifier identifier, StepStateChange stepStateChange, Date timestamp) {
        for (WorkflowStateListener listener : this.listeners) {
            listener.stepStateChanged(identifier, stepStateChange, timestamp);
        }
    }

    @Override
    public void beginWorkflowExecution(StepExecutionContext executionContext, WorkflowExecutionItem item) {
        this.stepContext.beginContext();
        List<StepContextId> currentContext = this.stepContext.getCurrentContext();
        List<String> names = this.getNodeNames(executionContext);
        if (null == currentContext) {
            this.notifyAllWorkflowState(ExecutionState.RUNNING, new Date(), names);
        } else {
            this.notifyAllSubWorkflowState(this.createIdentifier(), ExecutionState.RUNNING, new Date(), names);
        }
    }

    private List<String> getNodeNames(StepExecutionContext executionContext) {
        List<INodeEntry> orderedNodes = INodeEntryComparator.rankOrderedNodes(executionContext.getNodes(), executionContext.getNodeRankAttribute(), executionContext.isNodeRankOrderAscending());
        ArrayList<String> names = new ArrayList<String>();
        for (INodeEntry orderedNode : orderedNodes) {
            names.add(orderedNode.getNodename());
        }
        return names;
    }

    @Override
    public void finishWorkflowExecution(WorkflowExecutionResult result, StepExecutionContext executionContext, WorkflowExecutionItem item) {
        List<StepContextId> currentContext = this.stepContext.getCurrentContext();
        if (null == currentContext || currentContext.size() < 1) {
            this.notifyAllWorkflowState(null != result && result.isSuccess() ? ExecutionState.SUCCEEDED : ExecutionState.FAILED, new Date(), null);
        } else {
            this.notifyAllSubWorkflowState(this.createIdentifier(), null != result && result.isSuccess() ? ExecutionState.SUCCEEDED : ExecutionState.FAILED, new Date(), null);
        }
        this.stepContext.finishContext();
    }

    private StepIdentifier createIdentifier() {
        return StateUtils.stepIdentifier(this.stepContext.getCurrentContext());
    }

    private StepStateChange createStepStateChange(ExecutionState executionState) {
        return this.createStepStateChange(executionState, null);
    }

    private StepStateChange createStepStateChange(ExecutionState executionState, Map metadata) {
        INodeEntry currentNode = this.stepContext.getCurrentNode();
        return StateUtils.stepStateChange(StateUtils.stepState(executionState, metadata), null != currentNode ? currentNode.getNodename() : null);
    }

    private StepStateChange createStepStateChange(StepExecutionResult result) {
        INodeEntry currentNode = this.stepContext.getCurrentNode();
        return this.createStepStateChange(result, currentNode);
    }

    private StepStateChange createStepStateChange(StepExecutionResult result, INodeEntry currentNode) {
        return StateUtils.stepStateChange(StateUtils.stepState(this.resultState(result), this.resultMetadata(result), this.resultMessage(result)), null != currentNode ? currentNode.getNodename() : null);
    }

    private String resultMessage(StepExecutionResult result) {
        return null != result ? result.getFailureMessage() : null;
    }

    private ExecutionState resultState(StepExecutionResult result) {
        return null != result && result.isSuccess() ? ExecutionState.SUCCEEDED : ExecutionState.FAILED;
    }

    private Map<String, Object> resultMetadata(StepExecutionResult result) {
        if (null != result && result.isSuccess()) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (null != result && null != result.getFailureData()) {
            map.putAll(result.getFailureData());
        }
        map.put("failureReason", null != result ? result.getFailureReason().toString() : "Unknown");
        return map;
    }

    @Override
    public void beginWorkflowItem(int step, StepExecutionItem item) {
        this.stepContext.beginStepContext(StateUtils.stepContextId(step, false));
        this.notifyAllStepState(this.createIdentifier(), this.createStepStateChange(ExecutionState.RUNNING), new Date());
    }

    @Override
    public void beginWorkflowItemErrorHandler(int step, StepExecutionItem item) {
        this.stepContext.beginStepContext(StateUtils.stepContextId(step, true));
        HashMap<String, String> ehMap = new HashMap<String, String>();
        ehMap.put("handlerTriggered", "true");
        this.notifyAllStepState(this.createIdentifier(), this.createStepStateChange(ExecutionState.RUNNING_HANDLER, ehMap), new Date());
    }

    @Override
    public void finishWorkflowItem(int step, StepExecutionItem item, StepExecutionResult result) {
        if (!"NodeDispatch".equals(item.getType()) && !(item instanceof NodeStepExecutionItem)) {
            this.notifyAllStepState(this.createIdentifier(), this.createStepStateChange(result), new Date());
        }
        this.stepContext.finishStepContext();
    }

    @Override
    public void finishWorkflowItemErrorHandler(int step, StepExecutionItem item, StepExecutionResult result) {
    }

    @Override
    public void beginExecuteNodeStep(ExecutionContext context, NodeStepExecutionItem item, INodeEntry node) {
        this.stepContext.beginNodeContext(node);
        StepIdentifier identifier = this.createIdentifier();
        this.notifyAllStepState(identifier, this.createStepStateChange(StateUtils.last(identifier).getAspect().isMain() ? ExecutionState.RUNNING : ExecutionState.RUNNING_HANDLER), new Date());
    }

    @Override
    public void beginStepExecution(StepExecutor executor, StepExecutionContext context, StepExecutionItem item) {
    }

    @Override
    public void finishStepExecution(StepExecutor executor, StatusResult result, StepExecutionContext context, StepExecutionItem item) {
    }

    @Override
    public void finishExecuteNodeStep(NodeStepResult result, ExecutionContext context, StepExecutionItem item, INodeEntry node) {
        this.notifyAllStepState(this.createIdentifier(), this.createStepStateChange(result), new Date());
        this.stepContext.finishNodeContext();
    }
}

