/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.logging;

import com.dtolabs.rundeck.core.execution.workflow.ContextLogger;
import com.dtolabs.rundeck.core.logging.LogLevel;
import com.dtolabs.rundeck.core.logging.LogUtil;
import com.dtolabs.rundeck.core.logging.StreamingLogWriter;
import java.util.Map;

class ContextLogWriter
implements ContextLogger {
    StreamingLogWriter writer;

    public ContextLogWriter(StreamingLogWriter writer) {
        this.writer = writer;
    }

    @Override
    public void log(String message, Map<String, String> context) {
        this.writer.addEvent(LogUtil.logNormal(message, context));
    }

    @Override
    public void error(String message, Map<String, String> context) {
        this.writer.addEvent(LogUtil.logError(message, context));
    }

    @Override
    public void warn(String message, Map<String, String> context) {
        this.writer.addEvent(LogUtil.logWarn(message, context));
    }

    @Override
    public void verbose(String message, Map<String, String> context) {
        this.writer.addEvent(LogUtil.logVerbose(message, context));
    }

    @Override
    public void debug(String message, Map<String, String> context) {
        this.writer.addEvent(LogUtil.logDebug(message, context));
    }

    @Override
    public void emit(String eventType, LogLevel level, String message, Map<String, String> context) {
        this.writer.addEvent(LogUtil.event(eventType, level, message, context));
    }

    @Override
    public void log(String message) {
        this.log(message, null);
    }

    @Override
    public void error(String message) {
        this.error(message, null);
    }

    @Override
    public void warn(String message) {
        this.warn(message, null);
    }

    @Override
    public void verbose(String message) {
        this.verbose(message, null);
    }

    @Override
    public void debug(String message) {
        this.debug(message, null);
    }
}

