/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.resources;

import com.dtolabs.rundeck.core.common.AdditiveListNodeSet;
import com.dtolabs.rundeck.core.common.Framework;
import com.dtolabs.rundeck.core.common.INodeSet;
import com.dtolabs.rundeck.core.common.MergedAttributesNodeSet;
import com.dtolabs.rundeck.core.execution.service.ExecutionServiceException;
import com.dtolabs.rundeck.core.plugins.configuration.Configurable;
import com.dtolabs.rundeck.core.plugins.configuration.ConfigurationException;
import com.dtolabs.rundeck.core.plugins.configuration.Description;
import com.dtolabs.rundeck.core.plugins.configuration.Property;
import com.dtolabs.rundeck.core.plugins.configuration.PropertyUtil;
import com.dtolabs.rundeck.core.resources.FileResourceModelSource;
import com.dtolabs.rundeck.core.resources.ResourceModelSource;
import com.dtolabs.rundeck.core.resources.ResourceModelSourceException;
import com.dtolabs.rundeck.core.resources.format.ResourceFormatParserService;
import com.dtolabs.rundeck.plugins.util.DescriptionBuilder;
import com.dtolabs.rundeck.plugins.util.PropertyBuilder;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Properties;
import org.apache.log4j.Logger;

public class DirectoryResourceModelSource
implements ResourceModelSource,
Configurable {
    static final Logger logger = Logger.getLogger((String)DirectoryResourceModelSource.class.getName());
    private final Framework framework;
    private Configuration configuration;
    long lastModTime = 0L;
    private AdditiveListNodeSet listNodeSet = new AdditiveListNodeSet();
    private ArrayList<ResourceModelSource> fileSources = new ArrayList();
    private HashMap<File, ResourceModelSource> sourceCache = new HashMap();
    static ArrayList<Property> properties = new ArrayList();
    public static final Description DESCRIPTION;

    public DirectoryResourceModelSource(Framework framework) {
        this.framework = framework;
    }

    @Override
    public void configure(Properties configuration) throws ConfigurationException {
        Configuration configuration1 = Configuration.fromProperties(configuration);
        this.configure(configuration1);
    }

    void configure(Configuration config) throws ConfigurationException {
        this.configuration = config;
        this.configuration.validate();
    }

    @Override
    public INodeSet getNodes() throws ResourceModelSourceException {
        this.loadFileSources(this.configuration.directory, this.configuration.project);
        this.listNodeSet = new MergedAttributesNodeSet();
        this.loadNodeSets();
        return this.listNodeSet;
    }

    private void loadNodeSets() throws ResourceModelSourceException {
        for (ResourceModelSource fileSource : this.fileSources) {
            try {
                this.listNodeSet.addNodeSet(fileSource.getNodes());
            }
            catch (ResourceModelSourceException e) {
                e.printStackTrace();
            }
        }
    }

    private void loadFileSources(File directory, String project) {
        this.fileSources.clear();
        if (!directory.isDirectory()) {
            logger.warn((Object)("Not a directory: " + directory));
        }
        final HashSet<String> exts = new HashSet<String>(this.framework.getResourceFormatParserService().listSupportedFileExtensions());
        File[] files = directory.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File file, String s) {
                return exts.contains(ResourceFormatParserService.getFileExtension(s));
            }
        });
        HashSet<File> trackedFiles = new HashSet<File>(this.sourceCache.keySet());
        if (null != files) {
            Arrays.sort(files, new Comparator<File>(){

                @Override
                public int compare(File file, File file1) {
                    return file.getName().compareTo(file1.getName());
                }
            });
            for (File file : files) {
                trackedFiles.remove(file);
                if (!this.sourceCache.containsKey(file)) {
                    try {
                        ResourceModelSource source = this.framework.getResourceModelSourceService().getSourceForConfiguration("file", FileResourceModelSource.Configuration.build().project(project).file(file).generateFileAutomatically(false).includeServerNode(false).getProperties());
                        this.fileSources.add(source);
                        this.sourceCache.put(file, source);
                    }
                    catch (ExecutionServiceException e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                this.fileSources.add(this.sourceCache.get(file));
            }
        }
        for (File oldFile : trackedFiles) {
            this.sourceCache.remove(oldFile);
        }
    }

    public String toString() {
        return "DirectoryResourceModelSource{directory=" + this.configuration.directory + '}';
    }

    static {
        properties.add(PropertyUtil.string("directory", "Directory Path", "Directory path to scan", true, null));
        DESCRIPTION = DescriptionBuilder.builder().name("directory").title("Directory").description("Scans a directory and loads all resource document files").property(PropertyBuilder.builder().string("directory").title("Directory Path").description("Directory path to scan").required(true).build()).build();
    }

    public static class Configuration {
        public static final String DIRECTORY = "directory";
        public static final String PROJECT = "project";
        String project;
        File directory;

        public Configuration(Properties config) {
            this.configure(config);
        }

        public static Configuration fromProperties(Properties props) {
            return new Configuration(props);
        }

        public void configure(Properties props) {
            if (props.containsKey(PROJECT)) {
                this.project = props.getProperty(PROJECT);
            }
            if (props.containsKey(DIRECTORY)) {
                this.directory = new File(props.getProperty(DIRECTORY));
            }
        }

        public void validate() throws ConfigurationException {
            if (null == this.project) {
                throw new ConfigurationException("project is required");
            }
            if (null == this.directory) {
                throw new ConfigurationException("directory is required");
            }
            if (this.directory.isFile()) {
                throw new ConfigurationException("path specified is not a directory: " + this.directory);
            }
        }
    }
}

