/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.plugins;

import java.io.File;
import java.util.Comparator;
import java.util.Map;

class VersionCompare {
    public Integer maj;
    public String majString;
    public Integer min;
    public String minString;
    public Integer patch;
    public String patchString;
    public String tag;

    VersionCompare() {
    }

    public static int comp(Integer v1, String s1, Integer v2, String s2) {
        if (v1 != null && v2 != null) {
            return v1.compareTo(v2);
        }
        if (v1 != null) {
            return 1;
        }
        if (v2 != null) {
            return -1;
        }
        if (null == s1 && null == s2) {
            return 0;
        }
        if (null == s1) {
            return -1;
        }
        if (null == s2) {
            return 1;
        }
        return s1.compareTo(s2);
    }

    public int compareTo(VersionCompare b) {
        int c1 = VersionCompare.comp(this.maj, this.majString, b.maj, b.majString);
        if (c1 != 0) {
            return c1;
        }
        int c2 = VersionCompare.comp(this.min, this.minString, b.min, b.minString);
        if (c2 != 0) {
            return c2;
        }
        int c3 = VersionCompare.comp(this.patch, this.patchString, b.patch, b.patchString);
        if (c3 != 0) {
            return c3;
        }
        return 0;
    }

    public boolean atLeast(VersionCompare b) {
        return this.compareTo(b) >= 0;
    }

    public boolean atMost(VersionCompare b) {
        return this.compareTo(b) <= 0;
    }

    public static VersionCompare forString(String value) {
        VersionCompare vers = new VersionCompare();
        if (null == value || "".equals(value)) {
            return vers;
        }
        String[] parr1 = value.split("-", 2);
        String[] v1arr = parr1[0].split("\\.", 3);
        if (v1arr.length > 0) {
            vers.majString = v1arr[0];
            try {
                vers.maj = Integer.parseInt(vers.majString);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (v1arr.length > 1) {
            vers.minString = v1arr[1];
            try {
                vers.min = Integer.parseInt(vers.minString);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (v1arr.length > 2) {
            vers.patchString = v1arr[2];
            try {
                vers.patch = Integer.parseInt(vers.patchString);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (parr1.length > 1) {
            vers.tag = parr1[1];
        }
        return vers;
    }

    public String toString() {
        return "Vers{maj=" + this.maj + ", majString='" + this.majString + '\'' + ", min=" + this.min + ", minString='" + this.minString + '\'' + ", patch=" + this.patch + ", patchString='" + this.patchString + '\'' + ", tag='" + this.tag + '\'' + '}';
    }

    public static class fileComparator
    implements Comparator<File> {
        Map<File, VersionCompare> versions;

        public fileComparator(Map<File, VersionCompare> versions) {
            this.versions = versions;
        }

        @Override
        public int compare(File file, File file1) {
            VersionCompare v1 = this.versions.get(file);
            VersionCompare v2 = this.versions.get(file1);
            int comp = 0;
            if (null != v1 && null != v2) {
                comp = v1.compareTo(v2);
            } else if (v1 == null) {
                comp = -1;
            } else if (v2 == null) {
                comp = 1;
            }
            if (0 == comp) {
                comp = file.getName().compareTo(file1.getName());
            }
            return comp;
        }
    }
}

