/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.common;

import com.dtolabs.rundeck.core.common.Framework;
import com.dtolabs.rundeck.core.common.PluginControlService;
import com.dtolabs.rundeck.core.common.PluginDisabledException;
import com.dtolabs.rundeck.core.plugins.configuration.Description;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class PluginControlServiceImpl
implements PluginControlService {
    private final Framework framework;
    private final String projectName;

    private PluginControlServiceImpl(Framework framework, String project) {
        this.framework = framework;
        this.projectName = project;
    }

    public static PluginControlService forProject(Framework framework, String project) {
        return new PluginControlServiceImpl(framework, project);
    }

    @Override
    public List<String> listDisabledPlugins() {
        String disabledPlugins = this.framework.getProjectProperty(this.projectName, "disabled.plugins");
        if (disabledPlugins != null && !disabledPlugins.trim().isEmpty()) {
            return Arrays.asList(disabledPlugins.split("\\s*,\\s*"));
        }
        return new ArrayList<String>();
    }

    @Override
    public List<Description> filterEnabledPlugins(List<Description> plugins, String serviceName) {
        List<String> strings = this.listDisabledPlugins();
        return plugins.stream().filter(description -> !strings.contains(serviceName + ":" + description.getName())).collect(Collectors.toList());
    }

    @Override
    public Predicate<String> enabledPredicateForService(String serviceName) {
        List<String> strings = this.listDisabledPlugins();
        return name -> !strings.contains(serviceName + ":" + name);
    }

    @Override
    public Predicate<String> disabledPredicateForService(String serviceName) {
        return this.enabledPredicateForService(serviceName).negate();
    }

    @Override
    public boolean isDisabledPlugin(String pluginName, String serviceName) {
        List<String> disabledPluginsList = this.listDisabledPlugins();
        return disabledPluginsList.contains(serviceName + ":" + pluginName);
    }

    @Override
    public void checkDisabledPlugin(String pluginName, String serviceName) throws PluginDisabledException {
        if (this.isDisabledPlugin(pluginName, serviceName)) {
            throw new PluginDisabledException(String.format("%s Plugin '%s' is disabled", serviceName, pluginName));
        }
    }
}

