/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.execution.impl.jsch;

import com.dtolabs.rundeck.core.common.Framework;
import com.dtolabs.rundeck.core.common.INodeEntry;
import com.dtolabs.rundeck.core.common.IRundeckProject;
import com.dtolabs.rundeck.core.dispatcher.DataContextUtils;
import com.dtolabs.rundeck.core.execution.ExecutionContext;
import com.dtolabs.rundeck.core.execution.impl.jsch.JschNodeExecutor;
import com.dtolabs.rundeck.core.execution.utils.ResolverUtil;
import com.dtolabs.rundeck.core.storage.ResourceMeta;
import com.dtolabs.rundeck.core.tasks.net.SSHTaskBuilder;
import com.dtolabs.rundeck.core.utils.IPropertyLookup;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;

final class NodeSSHConnectionInfo
implements SSHTaskBuilder.SSHConnectionInfo {
    final INodeEntry node;
    final Framework framework;
    final ExecutionContext context;
    IRundeckProject frameworkProject;

    NodeSSHConnectionInfo(INodeEntry node, Framework framework, ExecutionContext context) {
        this.node = node;
        this.framework = framework;
        this.context = context;
        this.frameworkProject = framework.getFrameworkProjectMgr().getFrameworkProject(context.getFrameworkProject());
    }

    @Override
    public SSHTaskBuilder.AuthenticationType getAuthenticationType() {
        String authType = this.resolve("ssh-authentication");
        if (null != authType) {
            return SSHTaskBuilder.AuthenticationType.valueOf(authType);
        }
        return SSHTaskBuilder.AuthenticationType.privateKey;
    }

    @Override
    public String getPrivateKeyfilePath() {
        String path = this.resolve("ssh-keypath");
        if (path == null && this.framework.hasProperty("framework.ssh.keypath")) {
            path = this.framework.getProperty("framework.ssh.keypath");
        }
        if (path != null && path.contains("${")) {
            path = DataContextUtils.replaceDataReferencesInString(path, this.context.getDataContext());
        }
        return path;
    }

    @Override
    public InputStream getPrivateKeyStorageData() throws IOException {
        String privateKeyResourcePath = this.getPrivateKeyStoragePath();
        if (null == privateKeyResourcePath) {
            return null;
        }
        return ((ResourceMeta)this.context.getStorageTree().getResource(privateKeyResourcePath).getContents()).getInputStream();
    }

    @Override
    public byte[] getPasswordStorageData() throws IOException {
        return this.loadStoragePathData(this.getPasswordStoragePath());
    }

    private byte[] loadStoragePathData(String passwordStoragePath) throws IOException {
        if (null == passwordStoragePath) {
            return null;
        }
        ResourceMeta contents = (ResourceMeta)this.context.getStorageTree().getResource(passwordStoragePath).getContents();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        contents.writeContent(byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    @Override
    public String getPrivateKeyStoragePath() {
        String path = this.resolve("ssh-key-storage-path");
        if (null == path && this.framework.hasProperty("framework.ssh.key.resource")) {
            path = this.framework.getProperty("framework.ssh.key.resource");
        }
        if (path != null && path.contains("${")) {
            path = DataContextUtils.replaceDataReferencesInString(path, this.context.getDataContext());
        }
        return path;
    }

    @Override
    public String getPasswordStoragePath() {
        String path = this.resolve("ssh-password-storage-path");
        if (path != null && path.contains("${")) {
            path = DataContextUtils.replaceDataReferencesInString(path, this.context.getDataContext());
        }
        return path;
    }

    @Override
    public String getSudoPasswordStoragePath(String prefix) {
        String path = this.resolve(prefix + "password-storage-path");
        if (path != null && path.contains("${")) {
            path = DataContextUtils.replaceDataReferencesInString(path, this.context.getDataContext());
        }
        return path;
    }

    @Override
    public byte[] getSudoPasswordStorageData(String prefix) throws IOException {
        return this.loadStoragePathData(this.getSudoPasswordStoragePath(prefix));
    }

    @Override
    public String getSudoPassword(String prefix) {
        String opt = this.resolve(prefix + "password-option");
        if (null != opt) {
            return NodeSSHConnectionInfo.evaluateSecureOption(opt, this.context);
        }
        return NodeSSHConnectionInfo.evaluateSecureOption("sudo-".equals(prefix) ? "option.sudoPassword" : "option.sudo2Password", this.context);
    }

    @Override
    public String getPrivateKeyPassphrase() {
        String opt = this.resolve("ssh-key-passphrase-option");
        if (null != opt) {
            return NodeSSHConnectionInfo.evaluateSecureOption(opt, this.context);
        }
        return NodeSSHConnectionInfo.evaluateSecureOption("option.sshKeyPassphrase", this.context);
    }

    @Override
    public String getPrivateKeyPassphraseStoragePath() {
        String path = this.resolve("ssh-key-passphrase-storage-path");
        if (path != null && path.contains("${")) {
            path = DataContextUtils.replaceDataReferencesInString(path, this.context.getDataContext());
        }
        return path;
    }

    private String resolve(String propName) {
        return ResolverUtil.resolveProperty(propName, null, this.node, this.frameworkProject, this.framework);
    }

    @Override
    public byte[] getPrivateKeyPassphraseStorageData() throws IOException {
        return this.loadStoragePathData(this.getPrivateKeyPassphraseStoragePath());
    }

    static String evaluateSecureOption(String optionName, ExecutionContext context) {
        if (null == optionName) {
            JschNodeExecutor.logger.debug((Object)"option name was null");
            return null;
        }
        if (null == context.getPrivateDataContext()) {
            JschNodeExecutor.logger.debug((Object)"private context was null");
            return null;
        }
        String[] opts = optionName.split("\\.", 2);
        if (null != opts && 2 == opts.length) {
            Map<String, String> option = context.getPrivateDataContext().get(opts[0]);
            if (null != option) {
                String value = option.get(opts[1]);
                if (null == value) {
                    JschNodeExecutor.logger.debug((Object)("private context '" + optionName + "' was null"));
                }
                return value;
            }
            JschNodeExecutor.logger.debug((Object)("private context '" + opts[0] + "' was null"));
        }
        return null;
    }

    @Override
    public String getPassword() {
        String opt = this.resolve("ssh-password-option");
        if (null != opt) {
            return NodeSSHConnectionInfo.evaluateSecureOption(opt, this.context);
        }
        return NodeSSHConnectionInfo.evaluateSecureOption("option.sshPassword", this.context);
    }

    @Override
    public long getTimeout() {
        int timeout = 0;
        if (this.framework.getPropertyLookup().hasProperty("framework.ssh.timeout")) {
            String val = this.framework.getProperty("framework.ssh.timeout");
            try {
                timeout = Integer.parseInt(val);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return timeout;
    }

    @Override
    public long getCommandTimeout() {
        return this.resolveLongFwk("ssh-command-timeout", "framework.ssh.command.timeout", 0L);
    }

    private long resolveLongFwk(String key, String frameworkProp, long defval) {
        long timeout = defval;
        String opt = this.resolve(key);
        if (opt == null && frameworkProp != null && this.framework.getPropertyLookup().hasProperty(frameworkProp)) {
            opt = this.framework.getProperty(frameworkProp);
        }
        if (opt != null) {
            try {
                timeout = Long.parseLong(opt);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return timeout;
    }

    @Override
    public long getConnectTimeout() {
        long l = this.resolveLongFwk("ssh-connect-timeout", "framework.ssh.connect.timeout", 0L);
        return l > 0L ? l : this.getTimeout();
    }

    public static String nonBlank(String input) {
        if (null == input || "".equals(input.trim())) {
            return null;
        }
        return input.trim();
    }

    @Override
    public String getUsername() {
        String user = null != NodeSSHConnectionInfo.nonBlank(this.node.getUsername()) || this.node.containsUserName() ? NodeSSHConnectionInfo.nonBlank(this.node.extractUserName()) : (this.frameworkProject.hasProperty("project.ssh.user") && null != NodeSSHConnectionInfo.nonBlank(this.frameworkProject.getProperty("project.ssh.user")) ? NodeSSHConnectionInfo.nonBlank(this.frameworkProject.getProperty("project.ssh.user")) : NodeSSHConnectionInfo.nonBlank(this.framework.getProperty("framework.ssh.user")));
        if (null != user && user.contains("${")) {
            return DataContextUtils.replaceDataReferencesInString(user, this.context.getDataContext());
        }
        return user;
    }

    @Override
    public Boolean getLocalSSHAgent() {
        return ResolverUtil.resolveBooleanProperty("local-ssh-agent", false, this.node, this.frameworkProject, this.framework);
    }

    @Override
    public Integer getTtlSSHAgent() {
        return ResolverUtil.resolveIntProperty("local-ttl-ssh-agent", 0, this.node, this.frameworkProject, this.framework);
    }

    public static Map<String, String> sshConfigFromFramework(Framework framework) {
        HashMap<String, String> config = new HashMap<String, String>();
        IPropertyLookup propertyLookup = framework.getPropertyLookup();
        for (Object o : propertyLookup.getPropertiesMap().keySet()) {
            String key = (String)o;
            if (!key.startsWith("framework.ssh-config-")) continue;
            String name = key.substring("framework.ssh-config-".length());
            config.put(name, propertyLookup.getProperty(key));
        }
        return config;
    }

    public static Map<String, String> sshConfigFromProject(IRundeckProject frameworkProject) {
        HashMap<String, String> config = new HashMap<String, String>();
        for (String o : frameworkProject.getProperties().keySet()) {
            String key = o;
            if (!key.startsWith("project.ssh-config-")) continue;
            String name = key.substring("project.ssh-config-".length());
            config.put(name, frameworkProject.getProperty(key));
        }
        return config;
    }

    public static Map<String, String> sshConfigFromNode(INodeEntry node) {
        HashMap<String, String> config = new HashMap<String, String>();
        for (String s : node.getAttributes().keySet()) {
            if (!s.startsWith("ssh-config-")) continue;
            String name = s.substring("ssh-config-".length());
            config.put(name, node.getAttributes().get(s));
        }
        return config;
    }

    @Override
    public Map<String, String> getSshConfig() {
        HashMap<String, String> config = new HashMap<String, String>();
        Map<String, String> fwkConfig = NodeSSHConnectionInfo.sshConfigFromFramework(this.framework);
        Map<String, String> projConfig = NodeSSHConnectionInfo.sshConfigFromProject(this.frameworkProject);
        Map<String, String> nodeConfig = NodeSSHConnectionInfo.sshConfigFromNode(this.node);
        if (null != fwkConfig) {
            config.putAll(fwkConfig);
        }
        if (null != projConfig) {
            config.putAll(projConfig);
        }
        if (null != nodeConfig) {
            config.putAll(nodeConfig);
        }
        return config;
    }
}

