/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.cli;

import com.dtolabs.rundeck.core.cli.ExecTool;
import com.dtolabs.rundeck.core.cli.project.ProjectToolException;
import com.dtolabs.rundeck.core.execution.FailedNodesListener;
import com.dtolabs.rundeck.core.execution.workflow.steps.node.NodeStepResult;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;

public class FailedNodesFilestore {
    public static void clearFailedNodesFile(File failedNodesFile) {
        if (null != failedNodesFile && failedNodesFile.exists()) {
            failedNodesFile.deleteOnExit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean storeFailedNodes(Collection<String> nodenames, File failedNodesFile) {
        if (null == nodenames || 0 == nodenames.size()) {
            FailedNodesFilestore.clearFailedNodesFile(failedNodesFile);
        } else {
            Properties props = new Properties();
            StringBuffer sb = new StringBuffer();
            for (String node : nodenames) {
                if (sb.length() > 0) {
                    sb.append(",");
                }
                sb.append(node);
            }
            props.setProperty("failed.node.names", sb.toString());
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(failedNodesFile);
                try {
                    props.store(fileOutputStream, "Stored by " + ExecTool.class.getName());
                }
                finally {
                    fileOutputStream.close();
                }
                return true;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    public static FailedNodesListener createListener(File failedNodesFile) {
        return new Listener(failedNodesFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, String> parseFailedNodes(File failedNodesFile) {
        Properties failedprops = new Properties();
        HashMap<String, String> includeMap = new HashMap<String, String>();
        try {
            FileInputStream fileInputStream = new FileInputStream(failedNodesFile);
            try {
                failedprops.load(fileInputStream);
            }
            finally {
                fileInputStream.close();
            }
            String propval = failedprops.getProperty("failed.node.names");
            if (null != propval && !"".equals(propval.trim())) {
                String failednodes = propval;
                includeMap.put("name", failednodes);
            }
        }
        catch (FileNotFoundException e) {
            throw new ProjectToolException(e);
        }
        catch (IOException e) {
            throw new ProjectToolException(e);
        }
        return includeMap;
    }

    static class Listener
    implements FailedNodesListener {
        static Logger logger = Logger.getLogger(FailedNodesFilestore.class);
        File failedNodesFile;

        public Listener(File failedNodesFile) {
            this.failedNodesFile = failedNodesFile;
        }

        @Override
        public void matchedNodes(Collection<String> names) {
        }

        @Override
        public void nodesSucceeded() {
            if (null != this.failedNodesFile) {
                FailedNodesFilestore.clearFailedNodesFile(this.failedNodesFile);
                logger.debug((Object)("Failed node list file removed: " + this.failedNodesFile.getAbsolutePath()));
            }
        }

        @Override
        public void nodesFailed(Map<String, NodeStepResult> failedNodeNames) {
            if (null != this.failedNodesFile && failedNodeNames.size() > 0) {
                if (FailedNodesFilestore.storeFailedNodes(failedNodeNames.keySet(), this.failedNodesFile)) {
                    logger.info((Object)("Stored failed node list in: " + this.failedNodesFile.getAbsolutePath()));
                } else {
                    logger.error((Object)("Unable to store failed node list in file: " + this.failedNodesFile.getAbsolutePath()));
                }
            }
        }
    }
}

