/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.execution;

import com.dtolabs.rundeck.core.CoreException;
import com.dtolabs.rundeck.core.common.Framework;
import com.dtolabs.rundeck.core.common.INodeEntry;
import com.dtolabs.rundeck.core.dispatcher.DataContextUtils;
import com.dtolabs.rundeck.core.execution.BaseExecutionResult;
import com.dtolabs.rundeck.core.execution.ContextLoggerExecutionListener;
import com.dtolabs.rundeck.core.execution.ExecArgList;
import com.dtolabs.rundeck.core.execution.ExecutionContext;
import com.dtolabs.rundeck.core.execution.ExecutionContextImpl;
import com.dtolabs.rundeck.core.execution.ExecutionException;
import com.dtolabs.rundeck.core.execution.ExecutionListener;
import com.dtolabs.rundeck.core.execution.ExecutionResult;
import com.dtolabs.rundeck.core.execution.ExecutionService;
import com.dtolabs.rundeck.core.execution.StepExecutionItem;
import com.dtolabs.rundeck.core.execution.dispatch.Dispatchable;
import com.dtolabs.rundeck.core.execution.dispatch.DispatcherException;
import com.dtolabs.rundeck.core.execution.dispatch.DispatcherResult;
import com.dtolabs.rundeck.core.execution.dispatch.NodeDispatcher;
import com.dtolabs.rundeck.core.execution.service.DestinationFileCopier;
import com.dtolabs.rundeck.core.execution.service.ExecutionServiceException;
import com.dtolabs.rundeck.core.execution.service.FileCopier;
import com.dtolabs.rundeck.core.execution.service.FileCopierException;
import com.dtolabs.rundeck.core.execution.service.NodeExecutor;
import com.dtolabs.rundeck.core.execution.service.NodeExecutorResult;
import com.dtolabs.rundeck.core.execution.workflow.StepExecutionContext;
import com.dtolabs.rundeck.core.execution.workflow.WorkflowExecutionListener;
import com.dtolabs.rundeck.core.execution.workflow.steps.FailureReason;
import com.dtolabs.rundeck.core.execution.workflow.steps.StepException;
import com.dtolabs.rundeck.core.execution.workflow.steps.StepExecutionResult;
import com.dtolabs.rundeck.core.execution.workflow.steps.StepExecutionResultImpl;
import com.dtolabs.rundeck.core.execution.workflow.steps.StepExecutor;
import com.dtolabs.rundeck.core.execution.workflow.steps.StepFailureReason;
import com.dtolabs.rundeck.core.execution.workflow.steps.node.NodeStepException;
import com.dtolabs.rundeck.core.execution.workflow.steps.node.NodeStepExecutionItem;
import com.dtolabs.rundeck.core.execution.workflow.steps.node.NodeStepExecutor;
import com.dtolabs.rundeck.core.execution.workflow.steps.node.NodeStepResult;
import com.dtolabs.rundeck.core.execution.workflow.steps.node.NodeStepResultImpl;
import com.dtolabs.rundeck.core.utils.FormattedOutputStream;
import com.dtolabs.rundeck.core.utils.LogReformatter;
import com.dtolabs.rundeck.core.utils.MapGenerator;
import com.dtolabs.rundeck.core.utils.ThreadBoundOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

class ExecutionServiceImpl
implements ExecutionService {
    private final Framework framework;

    public ExecutionServiceImpl(Framework framework) {
        this.framework = framework;
    }

    protected WorkflowExecutionListener getWorkflowListener(ExecutionContext executionContext) {
        WorkflowExecutionListener wlistener = null;
        ExecutionListener elistener = executionContext.getExecutionListener();
        if (null != elistener && elistener instanceof WorkflowExecutionListener) {
            wlistener = (WorkflowExecutionListener)((Object)elistener);
        }
        return wlistener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExecutionResult executeItem(StepExecutionContext context, StepExecutionItem executionItem) throws ExecutionException, ExecutionServiceException {
        if (null != this.getWorkflowListener(context)) {
            this.getWorkflowListener(context).beginStepExecution(null, context, executionItem);
        }
        if (!(executionItem instanceof NodeStepExecutionItem)) {
            throw new IllegalArgumentException("Cannot dispatch item which is not a NodeStepExecutionItem: " + executionItem);
        }
        NodeStepExecutionItem item = (NodeStepExecutionItem)executionItem;
        boolean success = false;
        DispatcherResult result = null;
        BaseExecutionResult baseExecutionResult = null;
        LogReformatter formatter = ExecutionServiceImpl.createLogReformatter(null, context.getExecutionListener());
        ThreadStreamFormatter loggingReformatter = new ThreadStreamFormatter(formatter).invoke();
        try {
            result = this.dispatchToNodes(context, item);
            success = result.isSuccess();
            baseExecutionResult = new BaseExecutionResult(result, success, null);
        }
        catch (DispatcherException e) {
            baseExecutionResult = new BaseExecutionResult(result, success, e);
        }
        finally {
            loggingReformatter.resetOutputStreams();
            if (null != this.getWorkflowListener(context)) {
                this.getWorkflowListener(context).finishStepExecution(null, baseExecutionResult, context, item);
            }
        }
        return baseExecutionResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StepExecutionResult executeStep(StepExecutionContext context, StepExecutionItem item) throws StepException {
        StepExecutor executor;
        try {
            executor = this.framework.getStepExecutionService().getExecutorForItem(item);
        }
        catch (ExecutionServiceException e) {
            return new StepExecutionResultImpl(e, ServiceFailureReason.ServiceFailure, e.getMessage());
        }
        StepExecutionResult result = null;
        try {
            if (null != this.getWorkflowListener(context)) {
                this.getWorkflowListener(context).beginStepExecution(executor, context, item);
            }
            result = executor.executeWorkflowStep(context, item);
        }
        finally {
            if (null != this.getWorkflowListener(context)) {
                this.getWorkflowListener(context).finishStepExecution(executor, result, context, item);
            }
        }
        return result;
    }

    @Override
    public NodeStepResult executeNodeStep(StepExecutionContext context, NodeStepExecutionItem item, INodeEntry node) throws NodeStepException {
        NodeStepExecutor interpreter;
        try {
            interpreter = this.framework.getNodeStepExecutorForItem(item);
        }
        catch (ExecutionServiceException e) {
            throw new NodeStepException(e, (FailureReason)ServiceFailureReason.ServiceFailure, node.getNodename());
        }
        if (null != this.getWorkflowListener(context)) {
            this.getWorkflowListener(context).beginExecuteNodeStep(context, item, node);
        }
        NodeStepResult result = null;
        try {
            ExecutionContextImpl nodeContext = new ExecutionContextImpl.Builder(context).singleNodeContext(node, true).build();
            result = interpreter.executeNodeStep(nodeContext, item, node);
            if (!result.isSuccess()) {
                context.getExecutionListener().log(0, "Failed: " + result.toString());
            }
        }
        catch (NodeStepException e) {
            result = new NodeStepResultImpl(e, e.getFailureReason(), e.getMessage(), node);
            throw e;
        }
        catch (Throwable t) {
            result = new NodeStepResultImpl(t, StepFailureReason.Unknown, t.getMessage(), node);
            throw new NodeStepException(t, (FailureReason)StepFailureReason.Unknown, node.getNodename());
        }
        finally {
            if (null != this.getWorkflowListener(context)) {
                this.getWorkflowListener(context).finishExecuteNodeStep(result, context, item, node);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DispatcherResult dispatchToNodes(StepExecutionContext context, NodeStepExecutionItem item) throws DispatcherException, ExecutionServiceException {
        if (null != context.getExecutionListener()) {
            context.getExecutionListener().beginNodeDispatch((ExecutionContext)context, item);
        }
        NodeDispatcher dispatcher = this.framework.getNodeDispatcherForContext(context);
        DispatcherResult result = null;
        try {
            result = dispatcher.dispatch(context, item);
        }
        finally {
            if (null != context.getExecutionListener()) {
                context.getExecutionListener().finishNodeDispatch(result, (ExecutionContext)context, item);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DispatcherResult dispatchToNodes(StepExecutionContext context, Dispatchable item) throws DispatcherException, ExecutionServiceException {
        if (null != context.getExecutionListener()) {
            context.getExecutionListener().beginNodeDispatch((ExecutionContext)context, item);
        }
        NodeDispatcher dispatcher = this.framework.getNodeDispatcherForContext(context);
        DispatcherResult result = null;
        try {
            result = dispatcher.dispatch(context, item);
        }
        finally {
            if (null != context.getExecutionListener()) {
                context.getExecutionListener().finishNodeDispatch(result, (ExecutionContext)context, item);
            }
        }
        return result;
    }

    @Override
    public String fileCopyFileStream(ExecutionContext context, InputStream input, INodeEntry node) throws FileCopierException {
        return this.fileCopyFileStream(context, input, node, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String fileCopyFileStream(ExecutionContext context, InputStream input, INodeEntry node, String destinationPath) throws FileCopierException {
        FileCopier copier;
        if (null != context.getExecutionListener()) {
            context.getExecutionListener().beginFileCopyFileStream(context, input, node);
        }
        try {
            copier = this.framework.getFileCopierForNodeAndProject(node, context.getFrameworkProject());
        }
        catch (ExecutionServiceException e) {
            throw new FileCopierException(e.getMessage(), ServiceFailureReason.ServiceFailure, e);
        }
        String result = null;
        try {
            if (null != destinationPath && copier instanceof DestinationFileCopier) {
                DestinationFileCopier dcopier = (DestinationFileCopier)copier;
                result = dcopier.copyFileStream(context, input, node, destinationPath);
            } else {
                result = copier.copyFileStream(context, input, node);
            }
        }
        finally {
            if (null != context.getExecutionListener()) {
                context.getExecutionListener().finishFileCopy(result, context, node);
            }
        }
        return result;
    }

    @Override
    public String fileCopyFile(ExecutionContext context, File file, INodeEntry node) throws FileCopierException {
        return this.fileCopyFile(context, file, node, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String fileCopyFile(ExecutionContext context, File file, INodeEntry node, String destinationPath) throws FileCopierException {
        FileCopier copier;
        if (null != context.getExecutionListener()) {
            context.getExecutionListener().beginFileCopyFile(context, file, node);
        }
        try {
            copier = this.framework.getFileCopierForNodeAndProject(node, context.getFrameworkProject());
        }
        catch (ExecutionServiceException e) {
            throw new FileCopierException(e.getMessage(), ServiceFailureReason.ServiceFailure, e);
        }
        String result = null;
        try {
            if (null != destinationPath && copier instanceof DestinationFileCopier) {
                DestinationFileCopier dcopier = (DestinationFileCopier)copier;
                result = dcopier.copyFile(context, file, node, destinationPath);
            } else {
                result = copier.copyFile(context, file, node);
            }
        }
        finally {
            if (null != context.getExecutionListener()) {
                context.getExecutionListener().finishFileCopy(result, context, node);
            }
        }
        return result;
    }

    @Override
    public String fileCopyScriptContent(ExecutionContext context, String script, INodeEntry node) throws FileCopierException {
        return this.fileCopyScriptContent(context, script, node, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String fileCopyScriptContent(ExecutionContext context, String script, INodeEntry node, String destinationPath) throws FileCopierException {
        FileCopier copier;
        if (null != context.getExecutionListener()) {
            context.getExecutionListener().beginFileCopyScriptContent(context, script, node);
        }
        try {
            copier = this.framework.getFileCopierForNodeAndProject(node, context.getFrameworkProject());
        }
        catch (ExecutionServiceException e) {
            throw new FileCopierException(e.getMessage(), ServiceFailureReason.ServiceFailure, e);
        }
        String result = null;
        try {
            if (null != destinationPath && copier instanceof DestinationFileCopier) {
                DestinationFileCopier dcopier = (DestinationFileCopier)copier;
                result = dcopier.copyScriptContent(context, script, node, destinationPath);
            } else {
                result = copier.copyScriptContent(context, script, node);
            }
        }
        finally {
            if (null != context.getExecutionListener()) {
                context.getExecutionListener().finishFileCopy(result, context, node);
            }
        }
        return result;
    }

    @Override
    public NodeExecutorResult executeCommand(ExecutionContext context, String[] command, INodeEntry node) {
        return this.executeCommand(context, ExecArgList.fromStrings(DataContextUtils.stringContainsPropertyReferencePredicate, command), node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NodeExecutorResult executeCommand(ExecutionContext context, ExecArgList command, INodeEntry node) {
        NodeExecutor nodeExecutor;
        if (null != context.getExecutionListener()) {
            context.getExecutionListener().beginNodeExecution(context, command.asFlatStringArray(), node);
        }
        try {
            nodeExecutor = this.framework.getNodeExecutorForNodeAndProject(node, context.getFrameworkProject());
        }
        catch (ExecutionServiceException e) {
            throw new CoreException(e);
        }
        ExecutionContextImpl nodeContext = new ExecutionContextImpl.Builder(context).nodeContextData(node).build();
        ArrayList<String> commandList = command.buildCommandForNode(nodeContext.getDataContext(), node.getOsFamily());
        NodeExecutorResult result = null;
        String[] commandArray = commandList.toArray(new String[commandList.size()]);
        try {
            result = nodeExecutor.executeCommand(nodeContext, commandArray, node);
        }
        finally {
            if (null != context.getExecutionListener()) {
                context.getExecutionListener().finishNodeExecution(result, context, commandArray, node);
            }
        }
        return result;
    }

    @Override
    public String getName() {
        return "ExecutionService";
    }

    public static LogReformatter createLogReformatter(INodeEntry node, ExecutionListener listener) {
        LogReformatter gen;
        if (null != listener && listener.isTerse()) {
            gen = null;
        } else {
            String logformat = "[%user@%node %command][%level] %message";
            if (null != listener && null != listener.getLogFormat()) {
                logformat = listener.getLogFormat();
            }
            if (listener instanceof ContextLoggerExecutionListener) {
                ContextLoggerExecutionListener ctxListener = (ContextLoggerExecutionListener)listener;
                gen = new LogReformatter(logformat, new ContextLoggerExecutionListenerMapGenerator(ctxListener));
            } else {
                HashMap<String, String> baseContext = new HashMap<String, String>();
                baseContext.put("node", null != node ? node.getNodename() : "");
                baseContext.put("user", null != node ? node.extractUserName() : "");
                gen = new LogReformatter(logformat, baseContext);
            }
        }
        return gen;
    }

    static class ThreadStreamFormatter {
        final LogReformatter gen;
        private ThreadBoundOutputStream threadBoundSysOut;
        private ThreadBoundOutputStream threadBoundSysErr;
        private OutputStream origout;
        private OutputStream origerr;

        ThreadStreamFormatter(LogReformatter gen) {
            this.gen = gen;
        }

        public ThreadBoundOutputStream getThreadBoundSysOut() {
            return this.threadBoundSysOut;
        }

        public ThreadBoundOutputStream getThreadBoundSysErr() {
            return this.threadBoundSysErr;
        }

        public OutputStream getOrigout() {
            return this.origout;
        }

        public OutputStream getOrigerr() {
            return this.origerr;
        }

        public ThreadStreamFormatter invoke() {
            FormattedOutputStream errformat;
            FormattedOutputStream outformat;
            this.threadBoundSysOut = ThreadBoundOutputStream.bindSystemOut();
            this.threadBoundSysErr = ThreadBoundOutputStream.bindSystemErr();
            this.origout = this.threadBoundSysOut.getThreadStream();
            this.origerr = this.threadBoundSysErr.getThreadStream();
            if (this.origout instanceof FormattedOutputStream) {
                OutputStream origsink = ((FormattedOutputStream)this.origout).getOriginalSink();
                outformat = new FormattedOutputStream(this.gen, origsink);
            } else {
                outformat = new FormattedOutputStream(this.gen, this.origout);
            }
            outformat.setContext("level", "INFO");
            if (this.origerr instanceof FormattedOutputStream) {
                OutputStream origsink = ((FormattedOutputStream)this.origerr).getOriginalSink();
                errformat = new FormattedOutputStream(this.gen, origsink);
            } else {
                errformat = new FormattedOutputStream(this.gen, this.origerr);
            }
            errformat.setContext("level", "ERROR");
            this.threadBoundSysOut.installThreadStream(outformat);
            this.threadBoundSysErr.installThreadStream(errformat);
            return this;
        }

        public void resetOutputStreams() {
            this.threadBoundSysOut.removeThreadStream();
            this.threadBoundSysErr.removeThreadStream();
            if (null != this.origout) {
                this.threadBoundSysOut.installThreadStream(this.origout);
            }
            if (null != this.origerr) {
                this.threadBoundSysErr.installThreadStream(this.origerr);
            }
        }
    }

    private static class ContextLoggerExecutionListenerMapGenerator
    implements MapGenerator<String, String> {
        final ContextLoggerExecutionListener ctxListener;

        private ContextLoggerExecutionListenerMapGenerator(ContextLoggerExecutionListener ctxListener) {
            this.ctxListener = ctxListener;
        }

        @Override
        public Map<String, String> getMap() {
            return this.ctxListener.getLoggingContext();
        }
    }

    static enum ServiceFailureReason implements FailureReason
    {
        ServiceFailure;

    }
}

