/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.execution.workflow.steps.node.impl;

import com.dtolabs.rundeck.core.common.Framework;
import com.dtolabs.rundeck.core.common.INodeEntry;
import com.dtolabs.rundeck.core.execution.ExecArgList;
import com.dtolabs.rundeck.core.execution.ExecutionContext;
import com.dtolabs.rundeck.core.execution.ExecutionService;
import com.dtolabs.rundeck.core.execution.service.FileCopierException;
import com.dtolabs.rundeck.core.execution.service.NodeExecutorResult;
import com.dtolabs.rundeck.core.execution.workflow.StepExecutionContext;
import com.dtolabs.rundeck.core.execution.workflow.steps.node.NodeStepException;
import com.dtolabs.rundeck.core.execution.workflow.steps.node.NodeStepExecutionItem;
import com.dtolabs.rundeck.core.execution.workflow.steps.node.NodeStepExecutor;
import com.dtolabs.rundeck.core.execution.workflow.steps.node.NodeStepResult;
import com.dtolabs.rundeck.core.execution.workflow.steps.node.impl.ScriptFileCommand;
import com.dtolabs.rundeck.core.utils.ScriptExecUtil;
import java.io.File;

public class ScriptFileNodeStepExecutor
implements NodeStepExecutor {
    public static final String SERVICE_IMPLEMENTATION_NAME = "script";
    public static final String SCRIPT_FILE_REMOVE_TMP = "script-step-remove-tmp-file";
    private Framework framework;

    public ScriptFileNodeStepExecutor(Framework framework) {
        this.framework = framework;
    }

    @Override
    public NodeStepResult executeNodeStep(StepExecutionContext context, NodeStepExecutionItem item, INodeEntry node) throws NodeStepException {
        String filepath;
        ScriptFileCommand script = (ScriptFileCommand)item;
        ExecutionService executionService = this.framework.getExecutionService();
        try {
            filepath = null != script.getScript() ? executionService.fileCopyScriptContent(context, script.getScript(), node) : (null != script.getServerScriptFilePath() ? executionService.fileCopyFile(context, new File(script.getServerScriptFilePath()), node) : executionService.fileCopyFileStream(context, script.getScriptAsStream(), node));
        }
        catch (FileCopierException e) {
            throw new NodeStepException(e.getMessage(), (Throwable)e, e.getFailureReason(), node.getNodename());
        }
        return ScriptFileNodeStepExecutor.executeRemoteScript(context, context.getFramework(), node, script.getArgs(), filepath, script.getScriptInterpreter(), script.getInterpreterArgsQuoted());
    }

    public static NodeStepResult executeRemoteScript(ExecutionContext context, Framework framework, INodeEntry node, String[] args, String filepath) throws NodeStepException {
        return ScriptFileNodeStepExecutor.executeRemoteScript(context, framework, node, args, filepath, null, false);
    }

    public static NodeStepResult executeRemoteScript(ExecutionContext context, Framework framework, INodeEntry node, String[] args, String filepath, String scriptInterpreter, boolean interpreterargsquoted) throws NodeStepException {
        boolean removeFile = true;
        if (null != node.getAttributes() && null != node.getAttributes().get(SCRIPT_FILE_REMOVE_TMP)) {
            removeFile = Boolean.parseBoolean(node.getAttributes().get(SCRIPT_FILE_REMOVE_TMP));
        }
        return ScriptFileNodeStepExecutor.executeRemoteScript(context, framework, node, args, filepath, scriptInterpreter, interpreterargsquoted, removeFile);
    }

    public static NodeStepResult executeRemoteScript(ExecutionContext context, Framework framework, INodeEntry node, String[] args, String filepath, String scriptInterpreter, boolean interpreterargsquoted, boolean removeFile) throws NodeStepException {
        NodeExecutorResult nodeExecutorResult2;
        NodeExecutorResult nodeExecutorResult;
        if (!"windows".equalsIgnoreCase(node.getOsFamily()) && !(nodeExecutorResult = framework.getExecutionService().executeCommand(context, ExecArgList.fromStrings(false, "chmod", "+x", filepath), node)).isSuccess()) {
            return nodeExecutorResult;
        }
        ExecArgList scriptArgList = ScriptExecUtil.createScriptArgList(filepath, null, args, scriptInterpreter, interpreterargsquoted);
        NodeExecutorResult nodeExecutorResult3 = framework.getExecutionService().executeCommand(context, scriptArgList, node);
        if (removeFile && !(nodeExecutorResult2 = framework.getExecutionService().executeCommand(context, ScriptFileNodeStepExecutor.removeArgsForOsFamily(filepath, node.getOsFamily()), node)).isSuccess() && null != context.getExecutionListener()) {
            context.getExecutionListener().log(1, "Failed to remove remote file: " + filepath);
        }
        return nodeExecutorResult3;
    }

    public static ExecArgList removeArgsForOsFamily(String filepath, String osFamily) {
        if ("windows".equalsIgnoreCase(osFamily)) {
            return ExecArgList.fromStrings(false, "del", filepath);
        }
        return ExecArgList.fromStrings(false, "rm", "-f", filepath);
    }
}

